/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder.indexer;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.internal.builder.RelationDataFileTypeUtil;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefInfo;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;

public class TemplateHasTplNodeIndexForFullBuild {
    protected final RelationDataFileTypeUtil fileTypeUtil = new RelationDataFileTypeUtil();
    private final HashMap hasTplCacheData = new HashMap();

    public TemplateHasTplNodeIndexForFullBuild(IProject project) {
        TemplateRefIndex index = TemplateRefIndexManager.getInstance().getIndex(project);
        if (index == null) {
            return;
        }
        this.cacheHasTplIndexes(project, index);
    }

    public boolean hasValidInfo(IFile file) {
        if (file == null) {
            return false;
        }
        Data data = (Data)this.hasTplCacheData.get(file);
        return data != null && file.getModificationStamp() == data.modificationStamp;
    }

    public boolean hasTplNodes(IFile file) {
        if (file == null) {
            return false;
        }
        Data data = (Data)this.hasTplCacheData.get(file);
        return data != null && data.hasTplNode;
    }

    private void cacheHasTplIndexes(IProject project, final TemplateRefIndex index) {
        try {
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    TemplateRefInfo info;
                    IFile file;
                    if (proxy.getType() == 1 && TemplateHasTplNodeIndexForFullBuild.this.fileTypeUtil.isValidFileType((IResource)(file = (IFile)proxy.requestResource())) && index.hasValidInfo(file) && (info = index.getReferedInfo(file)) != null) {
                        Data data = new Data();
                        data.modificationStamp = info.getInfoStamp();
                        data.hasTplNode = info.hasTplNodes();
                        TemplateHasTplNodeIndexForFullBuild.this.hasTplCacheData.put(file, data);
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private class Data {
        long modificationStamp;
        boolean hasTplNode;

        private Data() {
        }
    }
}

