/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder.indexer;

import com.ibm.etools.webpage.template.internal.builder.indexer.IndexedTemplateModelSession;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateHasTplNodeIndexForFullBuild;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefInfo;
import com.ibm.etools.webpage.template.internal.model.TplModelFactory;
import com.ibm.etools.webpage.template.model.TemplateModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;

public class IndexedTemplateNodeFinder {
    private IndexedTemplateModelSession session;
    private IndexedTemplateModelSession mySession;
    private TemplateHasTplNodeIndexForFullBuild hasTplNodeIndex;

    public IndexedTemplateNodeFinder() {
        this(new IndexedTemplateModelSession());
        this.mySession = this.session;
    }

    public IndexedTemplateNodeFinder(IndexedTemplateModelSession sharedSession) {
        this.session = sharedSession;
    }

    public boolean hasTplNodes(IFile file) {
        TemplateRefIndex index = TemplateRefIndexManager.getInstance().getIndex(file.getProject());
        if (index != null && index.hasValidInfo(file)) {
            TemplateRefInfo info = index.getReferedInfo(file);
            return info.hasTplNodes();
        }
        if (this.hasTplNodeIndex != null && this.hasTplNodeIndex.hasValidInfo(file) && !this.hasTplNodeIndex.hasTplNodes(file)) {
            this.session.createNoTplNodeIndex(file);
            return false;
        }
        Boolean textMatchResult = this.hasRawTextMatch(file);
        if (textMatchResult != null && !textMatchResult.booleanValue()) {
            this.session.createNoTplNodeIndex(file);
            return false;
        }
        TemplateModel model = this.session.getTemplateModel(file);
        if (model == null) {
            return false;
        }
        boolean result = model.getRoot().getContentNodeList().getLength() > 0;
        this.session.clearModel(file);
        return result;
    }

    public void dispose() {
        if (this.mySession != null) {
            this.mySession.updateIndex();
            this.mySession.cleanup();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean hasRawTextMatch(IFile file) {
        try {
            String[] matchKeys = TplModelFactory.getRawTextModelNodeFilter();
            if (Arrays.asList(matchKeys).contains("")) {
                return Boolean.TRUE;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(file.getContents()), 4096);
            try {
                block6: while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    int i = matchKeys.length - 1;
                    while (true) {
                        if (i < 0) continue block6;
                        if (line.indexOf(matchKeys[i].toString()) >= 0) {
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                        --i;
                    }
                    break;
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setTemplateHasTplNodeIndex(TemplateHasTplNodeIndexForFullBuild hasTplNodeIndex) {
        this.hasTplNodeIndex = hasTplNodeIndex;
    }
}

