/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.TemplateNature;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.internal.builder.AbortBuildException;
import com.ibm.etools.webpage.template.internal.builder.LinksBuilderRelationDataUtil;
import com.ibm.etools.webpage.template.internal.builder.ReadOnlyFailureDialog;
import com.ibm.etools.webpage.template.internal.builder.RebuildMarkerUtil;
import com.ibm.etools.webpage.template.internal.builder.ReferenceMap;
import com.ibm.etools.webpage.template.internal.builder.RelationDataFileTypeUtil;
import com.ibm.etools.webpage.template.internal.builder.ValidateEditUtil;
import com.ibm.etools.webpage.template.internal.builder.indexer.IndexedTemplateModelSession;
import com.ibm.etools.webpage.template.internal.builder.indexer.IndexedTemplateNodeFinder;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateHasTplNodeIndexForFullBuild;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.exceptions.CharConversionErrorWithDetail;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class RelationDataManager {
    private ArrayList targetChangedTemplate = new ArrayList();
    private ArrayList targetChangedInstance = new ArrayList();
    private ContainerArrayList targetChangedContainer = new ContainerArrayList();
    private ArrayList targetTemplate = new ArrayList();
    private ArrayList targetInstance = new ArrayList();
    private ContainerArrayList targetContainer = new ContainerArrayList();
    private ArrayList candidates = new ArrayList();
    private ArrayList rebuildFiles = new ArrayList();
    private IndexedTemplateModelSession session = new IndexedTemplateModelSession();
    private IndexedTemplateNodeFinder tplNodeFinder = new IndexedTemplateNodeFinder(this.session);
    private RelationDataFileTypeUtil fileTypeUtil = new RelationDataFileTypeUtil();
    private ReferenceMap referenceMap;
    private boolean init_candidates;
    private boolean init_instancecandidates;
    private ArrayList templates;
    private ArrayList instancecandidates;
    protected IProgressMonitor monitor;

    public RelationDataManager(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.referenceMap = new ReferenceMap(monitor);
    }

    protected boolean isValidFileType(IResource src) {
        return this.fileTypeUtil.isValidFileType(src);
    }

    protected boolean isValidTemplateFileType(IResource src) {
        return this.fileTypeUtil.isValidTemplateFileType(src);
    }

    private boolean isValidInstanceFileType(IResource src) {
        return this.fileTypeUtil.isValidInstanceFileType(src);
    }

    public boolean isValidTemplateFile(IResource src) {
        return this.isValidTemplateFileType(src) && this.hasTemplateNode((IFile)src);
    }

    public boolean isValidInstanceFile(IResource src) {
        if (!this.isValidInstanceFileType(src)) {
            return false;
        }
        List candidatelist = this.getInstanceCandidates(src.getProject(), src);
        if (candidatelist == null) {
            return false;
        }
        if (candidatelist.size() == 0) {
            return false;
        }
        return candidatelist.contains(src) && this.hasTemplateNode((IFile)src);
    }

    private List getInstanceCandidates(IProject project, IResource resource) {
        if (!this.init_instancecandidates) {
            IContainer rootfolder = null;
            WebComponent webComp = null;
            try {
                webComp = new WebComponent(resource);
                rootfolder = webComp.getRootPublishableFolder();
            }
            finally {
                if (webComp != null) {
                    webComp.dispose();
                }
            }
            if (rootfolder == null || !rootfolder.exists()) {
                return null;
            }
            this.templates = new ArrayList();
            this.collectTemplates((IResource)rootfolder, this.templates);
            this.instancecandidates = new ArrayList();
            for (IFile template : this.templates) {
                ArrayList candidatelist = this.getCanditates(project, resource);
                if (candidatelist == null || candidatelist.size() == 0) continue;
                for (IFile instance : candidatelist) {
                    if (!this.isValidInstanceFileType((IResource)instance) || !this.isInstanceFileFor(instance, template)) continue;
                    this.instancecandidates.add(instance);
                }
            }
            this.init_instancecandidates = true;
        }
        return this.instancecandidates;
    }

    private void collectTemplates(IResource resource, List list) {
        if (!resource.exists()) {
            return;
        }
        if (this.isValidTemplateFile(resource)) {
            list.add(resource);
        } else if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] members = folder.members();
                int i = 0;
                while (i < members.length) {
                    this.collectTemplates(members[i], list);
                    ++i;
                }
            }
            catch (CoreException e) {
                Logger.log(e);
                return;
            }
        }
    }

    public boolean isValidFragmentFile(IResource src) {
        return this.isValidInstanceFileType(src);
    }

    public void addChangedTemplateToTarget(IFile instance) {
        this.addFileToTarget(instance, this.targetChangedTemplate);
    }

    public void addTemplateToTarget(IFile instance) {
        this.addFileToTarget(instance, this.targetTemplate);
    }

    public void addChangedInstanceToTarget(IFile instance) {
        this.addFileToTarget(instance, this.targetChangedInstance);
    }

    public void addInstanceToTarget(IFile instance) {
        this.addFileToTarget(instance, this.targetInstance);
    }

    public void addChangedContainerToTarget(IFile instance) {
        this.addFileToTarget(instance, this.targetChangedContainer);
    }

    public void addContainerToTarget(IFile instance) {
        this.addFileToTarget(instance, this.targetContainer);
    }

    public void addInstanceFiles(IFile template) {
        this.addInstanceFilesInChangedTarget(template, this.targetInstance, this.targetChangedInstance);
        ArrayList candidatelistAll = this.getCanditates(template.getProject(), (IResource)template);
        ArrayList candidatelist = this.getCanditates(template.getProject(), (IResource)template);
        if (candidatelist == null) {
            return;
        }
        if (candidatelist.size() == 0) {
            return;
        }
        ArrayList<IFile> removelist = new ArrayList<IFile>();
        for (IFile candidate : candidatelist) {
            if (!candidatelistAll.contains(candidate)) continue;
            if (this.isInstanceFileFor(candidate, template)) {
                this.targetInstance.add(candidate);
                if (this.isValidTemplateFile((IResource)candidate)) {
                    this.targetTemplate.add(candidate);
                }
                removelist.add(candidate);
                continue;
            }
            if (this.referenceMap.hasTemplateNode(candidate)) continue;
            this.session.clearModel(candidate);
            removelist.add(candidate);
        }
        if (removelist.size() > 0) {
            candidatelistAll.removeAll(removelist);
        }
    }

    public void addTemplateFiles(IFile template) {
        this.addInstanceFilesInChangedTarget(template, this.targetTemplate, this.targetChangedTemplate);
        ArrayList candidatelistAll = this.getCanditates(template.getProject(), (IResource)template);
        ArrayList candidatelist = this.getCanditates(template.getProject(), (IResource)template);
        if (candidatelist == null) {
            return;
        }
        if (candidatelist.size() == 0) {
            return;
        }
        ArrayList<IFile> removelist = new ArrayList<IFile>();
        for (IFile candidate : candidatelist) {
            if (!candidatelistAll.contains(candidate)) continue;
            if (this.isInstanceFileFor(candidate, template)) {
                this.targetTemplate.add(candidate);
                removelist.add(candidate);
                continue;
            }
            if (this.referenceMap.hasTemplateNode(candidate)) continue;
            this.session.clearModel(candidate);
            removelist.add(candidate);
        }
        if (removelist.size() > 0) {
            candidatelistAll.removeAll(removelist);
        }
    }

    protected void addContainerFiles(IFile fragment, List clist1) {
        this.addContainerFilesInChangedTarget(fragment, this.targetTemplate, this.targetChangedTemplate);
        this.addContainerFilesInChangedTarget(fragment, this.targetInstance, this.targetChangedInstance);
        this.addContainerFilesInChangedTarget(fragment, clist1, this.targetChangedContainer);
        ArrayList candidatelistAll = this.getCanditates(fragment.getProject(), (IResource)fragment);
        ArrayList candidatelist = this.getCanditates(fragment.getProject(), (IResource)fragment);
        if (candidatelist == null) {
            return;
        }
        if (candidatelist.size() == 0) {
            return;
        }
        ArrayList<IFile> removelist = new ArrayList<IFile>();
        for (IFile candidate : candidatelist) {
            if (!candidatelistAll.contains(candidate)) continue;
            if (this.isContainerFileFor(candidate, fragment)) {
                if (this.isValidTemplateFile((IResource)candidate)) {
                    this.targetTemplate.add(candidate);
                } else if (this.isValidInstanceFile((IResource)candidate)) {
                    this.targetInstance.add(candidate);
                } else {
                    clist1.add(candidate);
                }
                removelist.add(candidate);
                continue;
            }
            if (this.referenceMap.hasTemplateNode(candidate)) continue;
            this.session.clearModel(candidate);
            removelist.add(candidate);
        }
        if (removelist.size() > 0) {
            candidatelistAll.removeAll(removelist);
        }
    }

    private void addContainerFilesInChangedTarget(IFile fragment, List clist1, List changedList) {
        List candidatelist = changedList;
        if (candidatelist != null && candidatelist.size() > 0) {
            List candidatelistAll = changedList;
            ArrayList<IFile> removelist = new ArrayList<IFile>();
            for (IFile candidate : candidatelist) {
                if (!candidatelistAll.contains(candidate) || !this.isContainerFileFor(candidate, fragment)) continue;
                clist1.add(candidate);
                removelist.add(candidate);
            }
            if (removelist.size() > 0) {
                candidatelistAll.removeAll(removelist);
            }
        }
    }

    private void addInstanceFilesInChangedTarget(IFile template, List clist1, List changedList) {
        List candidatelist = changedList;
        if (candidatelist != null && candidatelist.size() > 0) {
            List candidatelistAll = changedList;
            ArrayList<IFile> removelist = new ArrayList<IFile>();
            for (IFile candidate : candidatelist) {
                if (!candidatelistAll.contains(candidate) || !this.isInstanceFileFor(candidate, template)) continue;
                clist1.add(candidate);
                removelist.add(candidate);
            }
            if (removelist.size() > 0) {
                candidatelistAll.removeAll(removelist);
            }
        }
    }

    public void addContainerFiles(IFile fragment) {
        this.addContainerFiles(fragment, this.targetContainer);
    }

    private void buildCore(List targets, List readonlyFiles) {
        Iterator i = targets.iterator();
        IFile target = null;
        RebuildMarkerUtil rebuildmarkerutil = new RebuildMarkerUtil(this.referenceMap);
        while (i.hasNext()) {
            TemplateModel tplmodel;
            target = (IFile)i.next();
            this.monitor.subTask(MessageFormat.format(ResourceHandler._UI_Template_Builder_is_building__0__1, target.getFullPath().toString()));
            this.createTree(target);
            if (rebuildmarkerutil.createMarkersBeforeBuild(target) || (tplmodel = this.session.getTemplateModel(target)) == null) continue;
            TemplateTaskReporter reporter = new TemplateTaskReporter();
            boolean changed = false;
            try {
                changed = tplmodel.rebuildContent(reporter);
            }
            catch (Exception e) {
                Logger.log(e);
                continue;
            }
            if (changed) {
                this.commit(target, tplmodel, readonlyFiles);
            }
            rebuildmarkerutil.createMarkersAfterBuild(target, reporter);
            this.monitor.worked(1);
        }
    }

    public void build() throws AbortBuildException {
        List targets = this.getTargets();
        IProject project = targets.isEmpty() ? null : ((IFile)targets.get(0)).getProject();
        final ArrayList readonlyFiles = new ArrayList();
        this.buildCore(targets, readonlyFiles);
        if (!readonlyFiles.isEmpty()) {
            IFile[] readonlyArray = readonlyFiles.toArray(new IFile[readonlyFiles.size()]);
            boolean hasUpdates = ValidateEditUtil.handleValidateReadOnly(readonlyArray, this.getSession());
            int i = 0;
            while (i < readonlyArray.length) {
                if (readonlyArray[i].isReadOnly()) {
                    while (targets.remove(readonlyArray[i])) {
                    }
                } else {
                    readonlyFiles.remove(readonlyArray[i]);
                }
                this.clearModel(readonlyArray[i]);
                ++i;
            }
            if (readonlyArray.length != readonlyFiles.size() || hasUpdates) {
                this.clearReferenceMap(targets);
                this.buildCore(targets, readonlyFiles);
            }
        }
        if (readonlyFiles.size() > 0 && TemplatePlugin.getDefault().getReadOnlyPromptPreference()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        return;
                    }
                    Shell shell = window.getShell();
                    if (shell == null) {
                        return;
                    }
                    ReadOnlyFailureDialog dialog = new ReadOnlyFailureDialog(shell, readonlyFiles);
                    dialog.setBlockOnOpen(true);
                    dialog.create();
                    dialog.open();
                }
            });
        }
        if (this.rebuildFiles.size() > 0) {
            this.monitor.subTask(ResourceHandler._UI_Page_Template_Builder_is_updating_markers__1);
            IFile file = (IFile)this.rebuildFiles.get(0);
            this.updateLink(file.getProject(), this.rebuildFiles);
        }
        try {
            TemplateNature templatenature;
            if (project != null && (templatenature = (TemplateNature)project.getNature("com.ibm.etools.webpage.template.templatenature")) != null) {
                templatenature.setReferenceMap(this.referenceMap);
            }
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    public void updateLink(IProject project, Collection rebuildFiles) {
    }

    protected void createCandiates(IContainer rootfolder) {
        if (!rootfolder.exists()) {
            return;
        }
        this.collectCandidates((IResource)rootfolder, this.candidates);
        this.init_candidates = true;
    }

    protected boolean isChecked(IResource resource) {
        return !this.getCanditates(resource.getProject(), resource).contains(resource);
    }

    protected int getChecked(IResource resource) {
        return this.getCanditates(resource.getProject(), resource).size();
    }

    protected void removeFromCandidates(IResource resource) {
        this.getCanditates(resource.getProject(), resource).remove(resource);
    }

    private ArrayList getCanditates(IProject project, IResource resource) {
        if (!this.init_candidates) {
            IContainer rootfolder = null;
            WebComponent webComp = null;
            try {
                webComp = new WebComponent(resource);
                rootfolder = webComp.getRootPublishableFolder();
            }
            finally {
                if (webComp != null) {
                    webComp.dispose();
                }
            }
            if (rootfolder == null || !rootfolder.exists()) {
                return null;
            }
            this.collectCandidates((IResource)rootfolder, this.candidates);
            this.init_candidates = true;
        }
        return this.candidates;
    }

    private void collectCandidates(IResource resource, List list) {
        if (!resource.exists()) {
            return;
        }
        if (this.isValidFileType(resource)) {
            list.add(resource);
        } else if (resource.getType() == 2) {
            IFolder folder = (IFolder)resource;
            try {
                IResource[] members = folder.members();
                int i = 0;
                while (i < members.length) {
                    this.collectCandidates(members[i], list);
                    ++i;
                }
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    private void addFileToTarget(IFile instance, List targetlist) {
        if (LinksBuilderRelationDataUtil.isEnabled(instance.getProject())) {
            ArrayList candidatelistAll = this.getCanditates(instance.getProject(), (IResource)instance);
            if (candidatelistAll.contains(instance)) {
                targetlist.add(instance);
                candidatelistAll.remove(instance);
            }
        } else {
            ArrayList candidatelist = this.getCanditates(instance.getProject(), (IResource)instance);
            if (candidatelist == null) {
                return;
            }
            if (candidatelist.size() == 0) {
                return;
            }
            this.createTree(instance);
            ArrayList<IFile> removelist = new ArrayList<IFile>();
            for (IFile candidate : candidatelist) {
                if (!candidate.equals((Object)instance)) continue;
                targetlist.add(candidate);
                removelist.add(candidate);
                break;
            }
            if (removelist.size() > 0) {
                candidatelist.removeAll(removelist);
            }
        }
    }

    public boolean isInstanceFileFor(IFile candidate, IFile template) {
        this.createTree(candidate);
        return this.referenceMap.isInstanceFileFor(template, candidate);
    }

    public boolean isContainerFileFor(IFile candidate, IFile fragment) {
        this.createTree(candidate);
        return this.referenceMap.isContainerFileFor(fragment, candidate);
    }

    private void commit(IFile file, TemplateModel tplmodel, List readonlyFiles) {
        if (file.isReadOnly()) {
            readonlyFiles.add(file);
            return;
        }
        IStructuredDocument flatmodel = tplmodel.getFlatModel();
        if (flatmodel == null) {
            return;
        }
        IModelManager mm = StructuredModelManager.getModelManager();
        try {
            mm.saveStructuredDocument(flatmodel, file);
            this.rebuildFiles.add(file);
        }
        catch (UnsupportedCharsetException uce) {
            Logger.log(uce);
        }
        catch (MalformedOutputExceptionWithDetail moe) {
            Logger.log(moe);
        }
        catch (CharConversionErrorWithDetail cce) {
            Logger.log(cce);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private List getTargets() throws AbortBuildException {
        ArrayList targets = new ArrayList();
        this.addIfChanged(this.targetChangedContainer, targets);
        targets.addAll(this.targetContainer);
        List target2 = this.targetContainer;
        while (this.candidates.size() > 0) {
            if ((target2 = this.getNextLevelContainer(target2)).size() == 0) break;
            targets.addAll(target2);
        }
        this.addIfChanged(this.targetChangedTemplate, targets);
        targets.addAll(this.targetTemplate);
        for (IFile file : this.targetTemplate) {
            this.addInstanceFiles(file);
        }
        this.addIfChanged(this.targetChangedInstance, targets);
        targets.addAll(this.targetInstance);
        return targets;
    }

    private void addIfChanged(List src, List target) {
        for (Object obj : src) {
            if (target.contains(obj) || !(obj instanceof IFile)) continue;
            IProject project = ((IFile)obj).getProject();
            TemplateRefIndex index = TemplateRefIndexManager.getInstance().getIndex(project);
            if (index != null && !index.isChanged((IFile)obj, this.getSession())) continue;
            target.add(obj);
        }
    }

    private List getNextLevelContainer(List target1) {
        ArrayList ret = new ArrayList();
        for (IFile file : target1) {
            if (!this.isValidFragmentFile((IResource)file)) continue;
            this.addContainerFiles(file, ret);
        }
        return ret;
    }

    private void createTree(IFile src) {
        this.referenceMap.add(src, this.session);
    }

    protected boolean hasTemplateNode(IFile src) {
        return this.tplNodeFinder.hasTplNodes(src);
    }

    protected void clearModel(IFile src) {
        this.session.clearModel(src);
    }

    protected boolean isInstanceFile(IFile src) {
        this.createTree(src);
        return this.referenceMap.isInstanceFile(src);
    }

    private void clearReferenceMap(List targets) {
        this.referenceMap = new ReferenceMap();
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            this.createTree((IFile)iter.next());
        }
    }

    IndexedTemplateModelSession getSession() {
        return this.session;
    }

    public void setHasTplNodeIndex(TemplateHasTplNodeIndexForFullBuild index) {
        this.tplNodeFinder.setTemplateHasTplNodeIndex(index);
    }

    class ContainerArrayList
    extends ArrayList {
        private static final long serialVersionUID = 1L;

        ContainerArrayList() {
        }

        @Override
        public boolean add(Object candidate) {
            Iterator iter = super.iterator();
            while (iter.hasNext()) {
                IFile container = (IFile)iter.next();
                if (!RelationDataManager.this.isContainerFileFor(container, (IFile)candidate)) continue;
                super.add(super.indexOf(container), candidate);
                return true;
            }
            return super.add(candidate);
        }
    }
}

