/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.internal.builder.MarkerData;
import com.ibm.etools.webpage.template.internal.builder.ReferenceMap;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefInfo;
import com.ibm.etools.webpage.template.internal.model.comment.CommentTagInfo;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplFragment;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplReference;
import com.ibm.etools.webpage.template.model.TplRoot;
import com.ibm.etools.webpage.template.model.TplTemplate;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class ReferenceTree {
    private static final String MARKER_MSG_CYCLIC_LINK = ResourceHandler._UI_Cyclic_link____1;
    private static final String MARKER_MSG_TEMPLATE_ERROR = ResourceHandler._UI_Referenced_Template_has_errors__2;
    private static final String MARKER_MSG_FRAGMENT_ERROR = ResourceHandler._UI_Referenced_Fragment_has_errors__3;
    private static final String MARKER_MSG_FILETYPE_ERROR = ResourceHandler._UI_JSP_or_JSP_Template_is_inserted_in_HTML__4;
    private final IFile src;
    private ReferenceMap referenceMap;
    private TemplateModelSession session;
    private boolean infinite;
    private boolean hasnode;
    private ArrayList referencefiles = new ArrayList();
    private ArrayList containsfiles = new ArrayList();
    private ArrayList templates = new ArrayList();
    private ArrayList fragments = new ArrayList();
    private MarkerData infiniteData;
    private Hashtable mapTemplate = new Hashtable();
    private Hashtable mapFragment = new Hashtable();
    private boolean deferredMake;
    private IFile infiniteDeferedTarget;
    private String infiniteDeferedMessage;

    public ReferenceTree(IFile src, ReferenceMap referenceMap, TemplateModelSession session) {
        this.src = src;
        this.referenceMap = referenceMap;
        this.session = session;
    }

    boolean hasInfiniteReference() {
        return this.infinite;
    }

    boolean hasTemplateNode() {
        return this.hasnode;
    }

    List getTemplates() {
        return this.templates;
    }

    List getFragments() {
        return this.fragments;
    }

    public void make() {
        TemplateRefIndex index = TemplateRefIndexManager.getInstance().getIndex(this.src.getProject());
        if (index != null && index.hasValidInfo(this.src)) {
            this.deferredMake = true;
            TemplateRefInfo info = index.getReferedInfo(this.src);
            this.deferredMake = true;
            this.hasnode = info.hasTplNodes();
            IFile[] fileArray = info.getReferdFilesAsFragment();
            int i = 0;
            while (i < fileArray.length) {
                this.checkReference(fileArray[i]);
                this.fragments.add(fileArray[i]);
                ++i;
            }
            fileArray = info.getReferedFilesAsTemplate();
            i = 0;
            while (i < fileArray.length) {
                this.checkReference(fileArray[i]);
                this.templates.add(fileArray[i]);
                ++i;
            }
            return;
        }
        this.actualMake();
    }

    private void confirmMake() {
        if (this.deferredMake) {
            List nodes;
            TemplateModel model = this.actualMake();
            if (this.hasInfiniteReference() && this.infiniteDeferedTarget != null && (nodes = TemplateModelUtil.collectInclusionNode(model)) != null && nodes.size() > 0) {
                for (Object obj : nodes) {
                    IFile file;
                    if (!(obj instanceof TplReference) || !this.infiniteDeferedTarget.equals((Object)(file = ((TplReference)obj).getReferedFile()))) continue;
                    this.infiniteData = this.createMarkerData(this.infiniteDeferedMessage, (TplNode)obj);
                    break;
                }
            }
        }
        this.deferredMake = false;
    }

    private TemplateModel actualMake() {
        TemplateModel tplmodel;
        this.fragments.clear();
        this.templates.clear();
        if (this.referenceMap.getMonitor() != null && this.src != null) {
            this.referenceMap.getMonitor().subTask(MessageFormat.format(ResourceHandler._UI_Template_Builder_is_checking__0__1, this.src.getFullPath().toString()));
        }
        if ((tplmodel = this.session.getTemplateModel(this.src)) == null) {
            return null;
        }
        TplRoot root = tplmodel.getRoot();
        TplNodeList nodelist = root.getContentNodeList();
        if (nodelist.getLength() > 0) {
            this.processNodeList(nodelist);
            this.hasnode = true;
        }
        return tplmodel;
    }

    boolean isInstanceFileFor(IFile template) {
        return this.templates.contains(template);
    }

    boolean isInstanceFile() {
        return this.templates.size() == 1;
    }

    boolean isContainerFileFor(IFile fragment) {
        return this.fragments.contains(fragment);
    }

    boolean contains(IFile file) {
        if (this.referencefiles.contains(file)) {
            return true;
        }
        if (this.containsfiles.contains(file)) {
            return true;
        }
        Iterator iter = this.referencefiles.iterator();
        while (iter.hasNext()) {
            ReferenceTree tree = this.referenceMap.get((IFile)iter.next());
            if (!tree.contains(file)) continue;
            this.containsfiles.add(file);
            return true;
        }
        return false;
    }

    MarkerData getInfiniteData() {
        this.confirmMake();
        return this.infiniteData;
    }

    private void processNodeList(TplNodeList nodelist) {
        int i = 0;
        while (i < nodelist.getLength()) {
            TplNode node = nodelist.item(i);
            switch (node.getNodeType()) {
                case 2: {
                    this.processTemplateNode((TplTemplate)node);
                    break;
                }
                case 8: {
                    this.processPutNode((TplPut)node);
                    break;
                }
                case 16: {
                    this.processFragmentNode((TplFragment)node);
                    break;
                }
            }
            ++i;
        }
    }

    private void processTemplateNode(TplTemplate tplnode) {
        this.checkReference(tplnode);
        TplNodeList putlist = tplnode.getPutList();
        int i = 0;
        while (i < putlist.getLength()) {
            this.processPutNode((TplPut)putlist.item(i));
            ++i;
        }
        IFile referencefile = tplnode.getReferedFile();
        if (referencefile != null && referencefile.exists()) {
            this.templates.add(referencefile);
            this.mapTemplate.put(referencefile, tplnode);
        }
    }

    private void processPutNode(TplPut putnode) {
        TplNodeList contentlist = putnode.getContentNodeList();
        this.processNodeList(contentlist);
    }

    private void processFragmentNode(TplFragment fragmentnode) {
        this.checkReference(fragmentnode);
        IFile referencefile = fragmentnode.getReferedFile();
        if (referencefile != null && referencefile.exists()) {
            this.fragments.add(referencefile);
            this.mapFragment.put(referencefile, fragmentnode);
        }
    }

    private void checkReference(TplFragment node) {
        IFile referencefile = node.getReferedFile();
        if (referencefile != null && referencefile.exists() && !this.referencefiles.contains(referencefile)) {
            this.referencefiles.add(referencefile);
            if (this.referenceMap.isWorking(referencefile)) {
                this.infinite = true;
                this.infiniteData = this.createMarkerData(String.valueOf(MARKER_MSG_CYCLIC_LINK) + referencefile.getProjectRelativePath().toString(), node);
                return;
            }
            this.referenceMap.add(referencefile, this.session);
            ReferenceTree tree = this.referenceMap.get(referencefile);
            if (tree.hasInfiniteReference()) {
                this.infinite = true;
                this.infiniteData = this.createMarkerData(tree.getInfiniteData().message, node);
            } else if (tree.contains(this.src)) {
                this.infinite = true;
                this.infiniteData = this.createMarkerData(String.valueOf(MARKER_MSG_CYCLIC_LINK) + this.src.getProjectRelativePath().toString(), node);
            }
        }
    }

    private void checkReference(IFile referencefile) {
        if (referencefile != null && referencefile.exists() && !this.referencefiles.contains(referencefile)) {
            this.referencefiles.add(referencefile);
            if (this.referenceMap.isWorking(referencefile)) {
                this.infinite = true;
                this.infiniteDeferedTarget = referencefile;
                this.infiniteDeferedMessage = String.valueOf(MARKER_MSG_CYCLIC_LINK) + referencefile.getProjectRelativePath().toString();
                return;
            }
            this.referenceMap.add(referencefile, this.session);
            ReferenceTree tree = this.referenceMap.get(referencefile);
            if (tree.hasInfiniteReference()) {
                this.infinite = true;
                this.infiniteDeferedTarget = referencefile;
                this.infiniteDeferedMessage = tree.getInfiniteData().message;
            } else if (tree.contains(this.src)) {
                this.infinite = true;
                this.infiniteDeferedTarget = referencefile;
                this.infiniteDeferedMessage = String.valueOf(MARKER_MSG_CYCLIC_LINK) + this.src.getProjectRelativePath().toString();
            }
        }
    }

    protected CommentTagInfo getCommentTagInfo(TplNode node, boolean start) {
        CommentTagInfo[] tagInfos = new CommentTagInfo[]{new CommentTagInfo(node.getRefNode().getStartNode()), new CommentTagInfo(node.getRefNode().getEndNode())};
        return tagInfos[start ? 0 : 1];
    }

    MarkerData getErrorTemplateData(IFile file) {
        this.confirmMake();
        TplNode node = (TplNode)this.mapTemplate.get(file);
        return this.createMarkerData(MARKER_MSG_TEMPLATE_ERROR, node);
    }

    MarkerData getErrorFragmentData(IFile file) {
        this.confirmMake();
        TplNode node = (TplNode)this.mapFragment.get(file);
        return this.createMarkerData(MARKER_MSG_FRAGMENT_ERROR, node);
    }

    MarkerData getWrongFileTypeData(IFile file) {
        this.confirmMake();
        TplNode node = null;
        String fileType = FileTypeHandler.getFileType(file);
        if (fileType.equals("jtpl")) {
            node = (TplNode)this.mapTemplate.get(file);
        }
        if (node == null) {
            node = (TplNode)this.mapFragment.get(file);
        }
        return this.createMarkerData(MARKER_MSG_FILETYPE_ERROR, node);
    }

    private MarkerData createMarkerData(String message, TplNode node) {
        CommentTagInfo.Region reg = this.getCommentTagInfo(node, true).getAttrValueRegion("page");
        int start = this.getCommentTagInfo(node, true).getFlatNode().getStart() + (reg != null ? reg.start : 0);
        int length = reg != null ? reg.offset : this.getCommentTagInfo(node, true).getFlatNode().getLength();
        return new MarkerData(message, start, length, node.getModel().getFlatModel().getLineOfOffset(start));
    }
}

