/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal;

import com.ibm.etools.j2ee.web.WebSettings;
import com.ibm.etools.webpage.template.Logger;
import org.eclipse.core.resources.IProject;

public class BackwardCompatibilityUtil {
    public static final String TEMPLATE_PROJECT_FEATURE_ID = "templatefeature";
    private final String featureName;

    public BackwardCompatibilityUtil() {
        this(TEMPLATE_PROJECT_FEATURE_ID);
    }

    public BackwardCompatibilityUtil(String webFeatureName) {
        this.featureName = webFeatureName;
    }

    public boolean notifyFacetInstalled(IProject project) {
        if (project != null && this.needBackwardCompatibility(project)) {
            try {
                boolean isNew = !this.isWebSettingExist(project);
                WebSettings webSettings = new WebSettings(project);
                if (isNew) {
                    webSettings.setVersion(WebSettings.VERSION_V5);
                }
                if (isNew || !this.hasFeature(webSettings)) {
                    String[] newFeatures = new String[]{this.featureName};
                    webSettings.setFeatureIds(newFeatures);
                    webSettings.write();
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
        return true;
    }

    public boolean notifyFacetUninstalled(IProject project) {
        if (project != null && this.needBackwardCompatibility(project)) {
            try {
                WebSettings webSettings;
                if (this.isWebSettingExist(project) && (webSettings = new WebSettings(project)).isValidWebSettings() && this.hasFeature(webSettings)) {
                    webSettings.removeFeatureId(this.featureName);
                    webSettings.write();
                    return true;
                }
            }
            catch (Exception e) {
                Logger.log(e);
            }
        }
        return false;
    }

    public boolean needBackwardCompatibility(IProject project) {
        return true;
    }

    private boolean hasFeature(WebSettings webSettings) {
        boolean featureExists = false;
        String[] loadedFeatures = webSettings.getFeatureIds();
        int i = 0;
        while (i < loadedFeatures.length) {
            if (loadedFeatures[i].equals(this.featureName)) {
                featureExists = true;
                break;
            }
            ++i;
        }
        return featureExists;
    }

    private boolean isWebSettingExist(IProject project) {
        return project.getFile(WebSettings.WEBSETTINGS_FILE_NAME).exists();
    }
}

