/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.PageTemplateCommentConstants;
import com.ibm.etools.webpage.template.commands.PageTemplateCommandUtil;
import com.ibm.etools.webpage.template.internal.model.LinkUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class TplCommentFactory
implements PageTemplateCommentConstants,
NodeFactory {
    private String tagName = "";
    private String src_data;
    private boolean raw_data;
    private List childFactories;
    private boolean isRangeTarget;
    private Map attributesMap;
    private FileURL fileURL;

    public TplCommentFactory(FileURL fileURL) {
        this("tpl:insert");
        this.setFileReference(fileURL);
    }

    public TplCommentFactory(String name, boolean inTemplate) {
        this("tpl:" + (inTemplate ? "insert" : "put"));
        if (name != null && name.length() > 0) {
            if (inTemplate) {
                this.pushAttribute("attribute", name);
            } else {
                this.pushAttribute("name", name);
            }
        }
    }

    public TplCommentFactory(String name) {
        this.tagName = name;
    }

    public void setFileReference(FileURL fileURL) {
        this.fileURL = fileURL;
        String pageAttr = fileURL.getURL();
        if (pageAttr != null) {
            this.pushAttribute("page", pageAttr);
        }
    }

    protected Element createElement(Document doc) {
        if (doc instanceof IDOMDocument) {
            return PageTemplateCommandUtil.createCommentElement((IDOMDocument)doc, this.getTagName());
        }
        return this.createElementDefault(doc);
    }

    protected Element createElementDefault(Document doc) {
        if (this.tagName.length() == 0) {
            return null;
        }
        return doc.createElement(this.tagName);
    }

    public boolean canCreateNode(Document doc) {
        return true;
    }

    public Node createNode(Document doc, Range range) {
        Node created;
        IDOMModel model;
        if (doc instanceof IDOMDocument && this.fileURL != null && (model = ((IDOMDocument)doc).getModel()) != null) {
            String pageAttr;
            String location = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(location));
            if (file != null && (pageAttr = LinkUtil.getResolvedNonPortalAwareURI(WebComponent.getComponent((IResource)file), this.fileURL)) != null) {
                this.pushAttribute("page", pageAttr);
            }
        }
        if ((created = this.createNodeDefault(doc, range)) != null && created.getNodeType() == 1) {
            range.setStart(created, created.getChildNodes().getLength());
            range.collapse(true);
        }
        return created;
    }

    protected Node createNodeDefault(Document doc, Range range) {
        Element elm = this.createElement(doc);
        if (elm == null) {
            return null;
        }
        this.setAttributes(elm);
        Text text = null;
        if (this.src_data != null && (text = doc.createTextNode("")) != null) {
            if (!this.raw_data && text instanceof IDOMText) {
                ((IDOMText)text).setValueSource(this.src_data);
            } else {
                text.setData(this.src_data);
            }
        }
        Node item = null;
        if (this.childFactories != null) {
            int i = 0;
            while (i < this.childFactories.size()) {
                NodeFactory factory = (NodeFactory)this.childFactories.get(i);
                item = factory.createNode(doc, range);
                if (item != null) {
                    elm.appendChild(item);
                }
                ++i;
            }
        }
        if (text != null) {
            elm.appendChild(text);
        }
        if (text != null) {
            range.setStart(text, text.getData().length());
        } else if (item != null && !this.isRangeTarget) {
            NodeList c = item.getChildNodes();
            int offset = c == null ? 0 : c.getLength();
            range.setStart(item, offset);
        } else {
            NodeList c = elm.getChildNodes();
            int offset = c == null ? 0 : c.getLength();
            range.setStart(elm, offset);
        }
        range.collapse(true);
        return elm;
    }

    protected boolean isRangeTarget() {
        return this.isRangeTarget;
    }

    public void setRangeTarget(boolean b) {
        this.isRangeTarget = b;
    }

    public void setTextSourceAsChild(String src) {
        this.src_data = src;
        this.raw_data = false;
    }

    protected void pushAttribute(String attrName, String attrValue) {
        if (this.attributesMap == null) {
            this.attributesMap = new HashMap();
        }
        this.attributesMap.put(attrName, attrValue);
    }

    protected void setAttributes(Element ele) {
        if (this.attributesMap != null && ele != null) {
            Set keySet = this.attributesMap.keySet();
            for (Object key : keySet) {
                ele.setAttribute(key.toString(), this.attributesMap.get(key).toString());
            }
        }
    }

    protected String getTagName() {
        return this.tagName;
    }
}

