/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.util.HTMLTaglibDirectiveUtil;
import com.ibm.etools.webedit.util.ITaglibDirective;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.PageTemplateCommentConstants;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplTemplate;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import java.util.List;
import java.util.Locale;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class PageTemplateCommandUtil
implements PageTemplateCommentConstants {
    static final String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    static final String USE_FACES_TAGNAME = ":view";
    static final String CONTENT_TYPE = "Content-Type";
    static final String CHARSET = "charset";

    public static boolean isTemplate(Document doc) {
        if (doc instanceof IDOMDocument) {
            IDOMModel model = ((IDOMDocument)doc).getModel();
            TemplateModelSession session = new TemplateModelSession();
            TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
            return tplModel.isTemplate();
        }
        return false;
    }

    public static boolean isValidModel(IDOMModel model) {
        String baseLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        String fType = FileTypeHandler.getFileType(baseLocation);
        if (fType != null) {
            if (baseLocation.toLowerCase(Locale.US).endsWith(".wml") || baseLocation.toLowerCase(Locale.US).endsWith(".jspf")) {
                return false;
            }
            return !ModelManagerUtil.isWML((IDOMDocument)model.getDocument());
        }
        return false;
    }

    public static Element createCommentElement(IDOMDocument doc, String elementName) {
        return doc.createCommentElement(elementName, PageTemplateCommandUtil.isJSPCommentPreferred(doc));
    }

    public static boolean isJSPCommentPreferred(IDOMDocument doc) {
        boolean jspComment = false;
        if ((doc.getModel().getContentTypeIdentifier().equals(ContentTypeIdForJSP.ContentTypeID_JSP) || doc.getModel().getContentTypeIdentifier().equals(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT)) && TemplatePlugin.getDefault().getJSPCommentPreference() && !doc.isJSPDocument()) {
            jspComment = true;
        }
        return jspComment;
    }

    public static boolean isPageSpecificNode(Node node) {
        while (node != null) {
            if (node instanceof IDOMElement && ((IDOMElement)node).isCommentTag() && node.getNodeName().startsWith("tpl:")) {
                return !node.getNodeName().equals("tpl:insert") || ((IDOMElement)node).getAttributeNode("page") == null;
            }
            node = node.getParentNode();
        }
        return true;
    }

    public static Element findEncodingMetaTag(List metaTags) {
        if (metaTags == null) {
            return null;
        }
        int j = 0;
        while (j < metaTags.size()) {
            String attr2;
            String attr;
            Element metaEle;
            Object obj = metaTags.get(j);
            if (obj instanceof Element && (metaEle = (Element)obj) != null && (attr = metaEle.getAttribute("http-equiv")) != null && attr.equalsIgnoreCase(CONTENT_TYPE) && (attr2 = metaEle.getAttribute("content")) != null && attr2.indexOf(CHARSET) >= 0) {
                return metaEle;
            }
            ++j;
        }
        return null;
    }

    public static Element findTaglibDirectiveWithSpecifiedPrefix(List taglibs, String prefix) {
        if (taglibs == null || prefix == null) {
            return null;
        }
        int i = 0;
        while (taglibs != null && i < taglibs.size()) {
            String pref;
            Element taglib;
            Object obj = taglibs.get(i);
            if (obj instanceof Element && "jsp:directive.taglib".equals((taglib = (Element)obj).getNodeName()) && (pref = taglib.getAttribute("prefix")) != null && pref.equals(prefix)) {
                return taglib;
            }
            ++i;
        }
        return null;
    }

    public static Element findTaglibDirectiveWithSpecifiedPrefix(NodeList taglibs, String prefix) {
        if (taglibs == null || prefix == null) {
            return null;
        }
        int i = 0;
        while (taglibs != null && i < taglibs.getLength()) {
            String pref;
            Element taglib;
            Node obj = taglibs.item(i);
            if (obj instanceof Element && "jsp:directive.taglib".equals((taglib = (Element)obj).getNodeName()) && (pref = taglib.getAttribute("prefix")) != null && pref.equals(prefix)) {
                return taglib;
            }
            ++i;
        }
        return null;
    }

    private static boolean isSimilarElement(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!node1.getNodeName().equals(node2.getNodeName())) {
            return false;
        }
        if (node1.getNodeType() != node2.getNodeType() || node1.getNodeType() != 1) {
            return false;
        }
        NamedNodeMap map1 = node1.getAttributes();
        NamedNodeMap map2 = node2.getAttributes();
        if (map1.getLength() != map2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < map1.getLength()) {
            Attr attr1 = (Attr)map1.item(i);
            Attr attr2 = (Attr)map2.getNamedItem(attr1.getName());
            if (attr2 == null || !attr1.getValue().equals(attr2.getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSimilarElement(Node node1, Node node2, boolean isIgnoreCase) {
        if (!isIgnoreCase) {
            return PageTemplateCommandUtil.isSimilarElement(node1, node2);
        }
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!node1.getNodeName().equalsIgnoreCase(node2.getNodeName())) {
            return false;
        }
        if (node1.getNodeType() != node2.getNodeType() || node1.getNodeType() != 1) {
            return false;
        }
        NamedNodeMap map1 = node1.getAttributes();
        NamedNodeMap map2 = node2.getAttributes();
        if (map1.getLength() != map2.getLength()) {
            return false;
        }
        int i = 0;
        while (i < map1.getLength()) {
            Attr attr1 = (Attr)map1.item(i);
            Attr attr2 = (Attr)map2.getNamedItem(attr1.getName());
            if (attr2 == null || !attr1.getValue().equals(attr2.getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEncodingPageDirective(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1) {
            return false;
        }
        if (!node.getNodeName().equals("jsp:directive.page")) {
            return false;
        }
        Element ele = (Element)node;
        String value = ele.getAttribute("pageEncoding");
        if (value != null && value.trim().length() > 0) {
            return true;
        }
        value = ele.getAttribute("contentType");
        return value != null && value.indexOf("charset=") >= 0;
    }

    public static void collectDocTypeNodes(Node node, List docTypes) {
        if (node == null || docTypes == null) {
            return;
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 10) {
                docTypes.add(child);
            } else if (child.getNodeType() == 1 && ((IDOMElement)child).isCommentTag()) {
                PageTemplateCommandUtil.collectDocTypeNodes(child, docTypes);
            }
            child = child.getNextSibling();
        }
    }

    protected static String getJSFPrefix(IDOMModel model) {
        if (model == null) {
            return null;
        }
        Object[] taglibs = HTMLTaglibDirectiveUtil.getTaglibDirectivesEx((IDOMModel)model);
        String prefix = null;
        int i = 0;
        while (taglibs != null && i < taglibs.length) {
            if (JSF_CORE_URI.equals(((ITaglibDirective)taglibs[i]).getURI()) || "urn:jsptld:http://java.sun.com/jsf/core".equals(((ITaglibDirective)taglibs[i]).getURI())) {
                prefix = ((ITaglibDirective)taglibs[i]).getPrefix();
                break;
            }
            ++i;
        }
        return prefix;
    }

    protected static Node getUseFacesNode(IDOMModel model) {
        if (model == null) {
            return null;
        }
        String prefix = PageTemplateCommandUtil.getJSFPrefix(model);
        if (prefix != null && prefix.length() > 0) {
            return PageTemplateCommandUtil.getFirstNodeInstance((Document)model.getDocument(), String.valueOf(prefix) + USE_FACES_TAGNAME);
        }
        return null;
    }

    protected static Node getFirstNodeInstance(Document d, String nodeName) {
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d, 1, null, false);
        Node node = iter.nextNode();
        while (node != null) {
            if (nodeName.equalsIgnoreCase(node.getNodeName())) {
                return node;
            }
            node = iter.nextNode();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean isContainer(Node src, Node child) {
        if (src != null && child != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (src == child) {
                return true;
            }
            child = child.getParentNode();
lbl6:
            // 2 sources

            ** while (child != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public static String getReadOnlyExceptionMessage(Node selectedNode, DOMException ex) {
        if (!(selectedNode instanceof IDOMNode)) {
            return null;
        }
        TemplateModel tplModel = new TemplateModelSession().getTemplateModel((IStructuredModel)((IDOMNode)selectedNode).getModel());
        List getNodes = TemplateModelUtil.collectInclusionNode(tplModel);
        block0: for (TplTemplate element : getNodes) {
            Node tplNode = element.getRefNode().getDomNode();
            Node n = selectedNode;
            while (n != tplNode) {
                if (n == null) continue block0;
                n = n.getParentNode();
            }
            return NLS.bind((String)ResourceHandler._UI_CannotEditSelection, (Object)element.getReferedFileLocation().lastSegment());
        }
        return null;
    }
}

