/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.commands;

import com.ibm.etools.webedit.common.commands.InsertSolidCommand;
import com.ibm.etools.webedit.common.commands.factories.NodeFactory;
import com.ibm.etools.webedit.common.commands.utils.CommandTreeManipulator;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.commands.PageTemplateCommandUtil;
import com.ibm.etools.webpage.template.commands.TplCommentFactory;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class InsertFragmentCommand
extends InsertSolidCommand {
    private TplCommentFactory tplFactory;
    private IFile file;

    public InsertFragmentCommand(IFile file) {
        super(null);
        this.tplFactory = new TplCommentFactory(file != null ? new FileURL(file.getLocation()) : null);
        this.setNodeFactory(this.tplFactory);
        this.file = file;
    }

    public boolean isCommandValidForSource() {
        return true;
    }

    protected Range doInsert(Document document, Range range, NodeFactory factory) {
        Range textTargetRange = ((DocumentRange)((Object)document)).createRange();
        Node node = factory.createNode(document, textTargetRange);
        if (node == null) {
            return null;
        }
        this.deleteRange(false);
        new CommandTreeManipulator(range).insertNode(node, null, range.getEndContainer(), range.getEndOffset(), true);
        TemplateModelSession session = new TemplateModelSession();
        TemplateModel tplModel = session.getTemplateModel((IStructuredModel)((IDOMDocument)document).getModel());
        String sseId = ModelManagerUtil.calculateSSEModelId((IFile)this.file);
        IStructuredModel sedModel = this.getModelManager().getExistingModelForRead((Object)sseId);
        try {
            TplNode tplNode;
            if (sedModel != null) {
                session.getTemplateModel(sedModel);
            }
            if ((tplNode = TemplateModelUtil.findTplNodeOf(tplModel, node)) != null) {
                TemplateTaskReporter reporter = new TemplateTaskReporter();
                tplNode.rebuildContent(reporter, false);
            }
        }
        finally {
            if (sedModel != null) {
                sedModel.releaseFromRead();
            }
        }
        return range;
    }

    private IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    protected boolean canDoExecute() {
        IDOMModel model;
        HTMLCommandTarget target = this.getCommandTarget();
        IDOMModel iDOMModel = model = target != null ? target.getActiveModel() : null;
        if (model == null || !PageTemplateCommandUtil.isValidModel(model)) {
            return false;
        }
        return super.canDoExecute();
    }
}

