/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template;

import com.ibm.etools.webpage.template.Logger;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;

public class FileTypeHandler {
    public static final String TPL_HTML_EXT = "htpl";
    public static final String TPL_JSP_EXT = "jtpl";
    public static final String FTYPE_HTML = "html";
    public static final String FTYPE_JSP = "jsp";
    public static final String FTYPE_TPL_HTML = "htpl";
    public static final String FTYPE_TPL_JSP = "jtpl";
    private static final String DOT = ".";

    public static String getFileType(IFile file) {
        String id;
        IContentType cid;
        block17: {
            if (file == null || file.getFileExtension() == null) {
                return null;
            }
            if (file.getFileExtension().equalsIgnoreCase("htpl")) {
                return "htpl";
            }
            if (file.getFileExtension().equalsIgnoreCase("jtpl")) {
                return "jtpl";
            }
            boolean exists = file.exists();
            cid = null;
            if (exists) {
                IContentDescription description;
                block16: {
                    description = file.getContentDescription();
                    if (description != null) break block16;
                    return null;
                }
                try {
                    cid = description.getContentType();
                }
                catch (ResourceException resourceException) {
                    if (file.isSynchronized(0)) break block17;
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    description = null;
                    if (file.exists()) {
                        description = file.getContentDescription();
                    }
                    if (description == null) {
                        return null;
                    }
                    try {
                        cid = description.getContentType();
                    }
                    catch (CoreException e) {
                        Logger.log(e);
                    }
                }
            } else {
                cid = Platform.getContentTypeManager().findContentTypeFor(file.getName());
            }
        }
        String string = id = cid == null ? null : cid.getId();
        if (id == null) {
            return null;
        }
        if (id.equals(ContentTypeIdForHTML.ContentTypeID_HTML)) {
            return FTYPE_HTML;
        }
        if (id.equals(ContentTypeIdForJSP.ContentTypeID_JSP) || id.equals(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT)) {
            return FTYPE_JSP;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileType(String fileLocation) {
        BufferedInputStream bin;
        block28: {
            String id;
            block27: {
                block26: {
                    if (fileLocation == null) {
                        return null;
                    }
                    int pos = fileLocation.lastIndexOf(DOT);
                    String ext = null;
                    if (pos <= 0) return null;
                    ext = fileLocation.substring(pos + 1);
                    if (ext.equalsIgnoreCase("htpl")) {
                        return "htpl";
                    }
                    if (ext.equalsIgnoreCase("jtpl")) {
                        return "jtpl";
                    }
                    bin = null;
                    try {
                        IContentDescription description;
                        IContentType cid;
                        block24: {
                            cid = null;
                            FileInputStream fis = new FileInputStream(fileLocation);
                            bin = new BufferedInputStream(fis);
                            description = Platform.getContentTypeManager().getDescriptionFor((InputStream)bin, fileLocation, IContentDescription.ALL);
                            if (description != null) break block24;
                            if (bin == null) return null;
                            try {
                                bin.close();
                                return null;
                            }
                            catch (IOException iOException) {}
                            return null;
                        }
                        try {
                            cid = description.getContentType();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            cid = Platform.getContentTypeManager().findContentTypeFor(fileLocation);
                        }
                        catch (IOException ie) {
                            Logger.log(ie);
                        }
                        String string = id = cid == null ? null : cid.getId();
                    }
                    catch (Throwable throwable) {
                        if (bin == null) throw throwable;
                        try {
                            bin.close();
                            bin = null;
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    {
                        if (id != null) break block26;
                        if (bin == null) return null;
                    }
                    try {
                        bin.close();
                        return null;
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                if (!id.equals(ContentTypeIdForHTML.ContentTypeID_HTML)) break block27;
                if (bin == null) return FTYPE_HTML;
                try {
                    bin.close();
                    return FTYPE_HTML;
                }
                catch (IOException iOException) {}
                return FTYPE_HTML;
            }
            if (!id.equals(ContentTypeIdForJSP.ContentTypeID_JSP) && !id.equals(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT)) break block28;
            if (bin == null) return FTYPE_JSP;
            try {
                bin.close();
                return FTYPE_JSP;
            }
            catch (IOException iOException) {}
            return FTYPE_JSP;
        }
        if (bin == null) return null;
        try {
            bin.close();
            return null;
        }
        catch (IOException iOException) {}
        return null;
    }

    public static boolean isTemplate(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        int pos = fileLocation.lastIndexOf(DOT);
        String ext = null;
        if (pos <= 0) {
            return false;
        }
        ext = fileLocation.substring(pos + 1);
        return ext.equalsIgnoreCase("htpl") || ext.equalsIgnoreCase("jtpl");
    }

    public static boolean isTemplate(IFile file) {
        if (file == null) {
            return false;
        }
        String ext = file.getFileExtension();
        if (ext == null) {
            return false;
        }
        return ext.equalsIgnoreCase("htpl") || ext.equalsIgnoreCase("jtpl");
    }
}

