/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles.areas;

import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.utils.FileTypeUtil;
import com.ibm.etools.webedit.util.WebFileViewerFilter;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.tiles.ITilesConfigContentAreaConstants;
import com.ibm.etools.webpage.template.tiles.util.TilesConfigContentAreaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.j2ee.internal.dialogs.FilteredFileSelectionDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class TilesConfigOneAreaWidget
implements ITilesConfigContentAreaConstants,
ITilesConstants,
ISelectionProvider {
    private static final String EMPTY_STRING = "";
    private IVirtualComponent component;
    private String definitionName;
    private IFile templateFile;
    private IFile srcFile;
    private Control control;
    private Button selectFileRadio;
    private Button defaultPutRadio;
    private Button directTextRadio;
    private Button definitionRadio;
    private Button browseButton;
    private Text selectFileFolder;
    private Text selectFileName;
    private Text defaultPutFolder;
    private Text defaultPutName;
    private Text directText;
    private Label selectFileFolderLabel;
    private Label selectFileNameLabel;
    private Label defaultPutFolderLabel;
    private Label defaultPutNameLabel;
    private Label definitionLabel;
    private Label directTextLabel;
    private Combo definitionCombo;
    private String areaName;
    private boolean suspendValidate = false;
    private boolean isDirect;
    private Map putAreaMap;
    private List definitionNames;
    private boolean stopStore;
    private TilesDefinitionUtil defUtil;
    private Image buttonImage;
    private String areaValue;
    private boolean forceCreate;
    private List selectionListeners = new ArrayList();

    public Control createContents(Composite parent) {
        Composite rightSide = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 0;
        layout.marginHeight = 0;
        rightSide.setLayout((Layout)layout);
        rightSide.setLayoutData((Object)new GridData(770));
        Label label = new Label(rightSide, 0);
        label.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_13);
        this.createSelectFileField(rightSide);
        this.createDirectTextField(rightSide);
        this.createDefaultPutField(rightSide);
        this.createDefinitionField(rightSide);
        this.control = rightSide;
        return rightSide;
    }

    private void createSelectFileField(Composite composite) {
        this.selectFileRadio = new Button(composite, 16);
        this.selectFileRadio.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_0);
        Composite selectBox = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        selectBox.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        selectBox.setLayoutData((Object)data);
        this.selectFileNameLabel = new Label(selectBox, 0);
        this.selectFileNameLabel.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_1);
        this.selectFileName = new Text(selectBox, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 150;
        this.selectFileName.setLayoutData((Object)data);
        this.selectFileFolderLabel = new Label(selectBox, 0);
        this.selectFileFolderLabel.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_2);
        this.selectFileFolder = new Text(selectBox, 2048);
        data = new GridData(768);
        this.selectFileFolder.setLayoutData((Object)data);
        this.browseButton = new Button(selectBox, 8);
        this.browseButton.setText(ResourceHandler._UI_New_Fragment_Creation_Dialog_3);
        data = new GridData();
        this.browseButton.setLayoutData((Object)data);
        this.selectFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
            }
        });
        this.selectFileFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
            }
        });
        this.selectFileRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TilesConfigOneAreaWidget.this.selectFileRadio.getSelection() && !TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
                TilesConfigOneAreaWidget.this.setEnabledSelectedField(TilesConfigOneAreaWidget.this.selectFileRadio.getSelection());
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TilesConfigOneAreaWidget.this.browse();
            }
        });
        this.browseButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Image img;
                if (e.widget instanceof Button && (img = ((Button)e.widget).getImage()) != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
    }

    private void createDefaultPutField(Composite composite) {
        this.defaultPutRadio = new Button(composite, 16);
        this.defaultPutRadio.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_6);
        Composite defaultPutBox = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        defaultPutBox.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        defaultPutBox.setLayoutData((Object)data);
        this.defaultPutNameLabel = new Label(defaultPutBox, 0);
        this.defaultPutNameLabel.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_7);
        this.defaultPutName = new Text(defaultPutBox, 2048);
        this.defaultPutName.setEditable(false);
        this.defaultPutName.setLayoutData((Object)new GridData(768));
        this.defaultPutFolderLabel = new Label(defaultPutBox, 0);
        this.defaultPutFolderLabel.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_8);
        this.defaultPutFolder = new Text(defaultPutBox, 2048);
        this.defaultPutFolder.setEditable(false);
        this.defaultPutFolder.setLayoutData((Object)new GridData(768));
        this.defaultPutRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TilesConfigOneAreaWidget.this.defaultPutRadio.getSelection() && !TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
                TilesConfigOneAreaWidget.this.defaultPutFolder.setEnabled(TilesConfigOneAreaWidget.this.control.getEnabled() && TilesConfigOneAreaWidget.this.defaultPutRadio.getSelection());
                TilesConfigOneAreaWidget.this.defaultPutName.setEnabled(TilesConfigOneAreaWidget.this.control.getEnabled() && TilesConfigOneAreaWidget.this.defaultPutRadio.getSelection());
            }
        });
    }

    private void createDefinitionField(Composite composite) {
        this.definitionRadio = new Button(composite, 16);
        this.definitionRadio.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_14);
        Composite newBox = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        newBox.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        newBox.setLayoutData((Object)data);
        this.definitionLabel = new Label(newBox, 0);
        this.definitionLabel.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_15);
        this.definitionCombo = new Combo(newBox, 2060);
        data = new GridData(768);
        this.definitionCombo.setLayoutData((Object)data);
        this.definitionRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TilesConfigOneAreaWidget.this.definitionRadio.getSelection() && !TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
                TilesConfigOneAreaWidget.this.setEnabledDefinitionField(TilesConfigOneAreaWidget.this.definitionRadio.getSelection());
            }
        });
        this.definitionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
            }
        });
    }

    private void createDirectTextField(Composite composite) {
        this.directTextRadio = new Button(composite, 16);
        this.directTextRadio.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_9);
        Composite newBox = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        newBox.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        newBox.setLayoutData((Object)data);
        this.directTextLabel = new Label(newBox, 0);
        this.directTextLabel.setText(ResourceHandler._UI_Tiles_Config_One_Area_Widget_10);
        this.directTextLabel.setLayoutData((Object)new GridData(2));
        this.directText = new Text(newBox, 2562);
        data = new GridData(768);
        data.heightHint = 30;
        this.directText.setLayoutData((Object)data);
        this.directTextRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TilesConfigOneAreaWidget.this.directTextRadio.getSelection() && !TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
                TilesConfigOneAreaWidget.this.setEnabledDirectTextField(TilesConfigOneAreaWidget.this.directTextRadio.getSelection());
            }
        });
        this.directText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TilesConfigOneAreaWidget.this.suspendValidate && TilesConfigOneAreaWidget.this.validateData()) {
                    TilesConfigOneAreaWidget.this.storeData();
                }
            }
        });
    }

    public void dispose() {
        if (this.buttonImage != null) {
            this.buttonImage.dispose();
            this.buttonImage = null;
        }
        this.disposeDefinitionUtil();
    }

    public Control getControl() {
        return this.control;
    }

    protected Shell getShell() {
        return this.control.getShell();
    }

    protected void setComponent(IVirtualComponent component) {
        if (component != null && !component.equals(this.component)) {
            this.disposeDefinitionUtil();
        }
        this.component = component;
    }

    protected IVirtualComponent getComponent() {
        return this.component;
    }

    protected void setPutAreaMap(Map map) {
        this.putAreaMap = map;
    }

    protected void browse() {
        IFile file = TilesConfigOneAreaWidget.selectFile(this.getShell(), this.getComponent());
        if (file != null) {
            this.selectFileFolder.setText(file.getFullPath().removeLastSegments(1).toString());
            this.selectFileName.setText(file.getName());
            if (!this.suspendValidate && this.validateData()) {
                this.storeData();
            }
        }
    }

    private static IFile selectFile(Shell shell, IVirtualComponent component) {
        WebComponent webComp = null;
        FilteredFileSelectionDialog dialog = null;
        try {
            webComp = new WebComponent(component);
            IContainer root = webComp.getRootPublishableFolder();
            String[] filterExt = FileTypeUtil.getFileExtensionsForHtml((int)3);
            dialog = new FilteredFileSelectionDialog(shell, ResourceHandler._UI_Tiles_Config_One_Area_Widget_11, ResourceHandler._UI_Tiles_Config_One_Area_Widget_12, filterExt, false);
            dialog.addFilter((ViewerFilter)new WebFileViewerFilter(component));
            dialog.setInput((Object)root);
            dialog.setInitialSelection((Object)root);
            dialog.setSorter((ViewerSorter)new ResourceSorter(2));
        }
        finally {
            if (webComp != null) {
                webComp.dispose();
            }
        }
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    protected String[] getGetAreaNames(String defName, boolean all) {
        if (this.getDefinitionUtil() == null || defName == null) {
            return new String[0];
        }
        return this.getDefinitionUtil().collectGetAreaNames(defName, all, all, true);
    }

    protected String[] getGetAreaNames(IFile template, boolean all) {
        if (template == null) {
            return new String[0];
        }
        ModelManagerUtil util = new ModelManagerUtil(null, null);
        IDOMModel model = (IDOMModel)util.getModelForRead(template);
        try {
            String[] stringArray = TilesUtil.collectGetAreaNames((IDOMModel)model, (boolean)all, (boolean)all, (boolean)true);
            return stringArray;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected static Map getGetAreaMap(IFile template) {
        ModelManagerUtil util = new ModelManagerUtil(null, null);
        IDOMModel model = (IDOMModel)util.getModelForRead(template);
        try {
            Map map = TilesUtil.collectGetAreaMap((IDOMModel)model, (boolean)true, (boolean)true, (boolean)true);
            return map;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected TilesDefinitionUtil getDefinitionUtil() {
        if (this.defUtil == null) {
            this.defUtil = new TilesDefinitionUtil(this.getComponent(), this.srcFile);
        }
        return this.defUtil;
    }

    protected void disposeDefinitionUtil() {
        if (this.defUtil != null) {
            this.defUtil.dispose();
            this.defUtil = null;
        }
    }

    public void setArea(IFile srcFile, IVirtualComponent component, String defName, String areaName) {
        this.setComponent(component);
        this.srcFile = srcFile;
        this.definitionName = defName;
        this.templateFile = null;
        this.areaName = areaName;
        this.initializeData();
    }

    public void setArea(IFile srcFile, IFile file, String areaName) {
        this.setComponent(WebComponent.getComponent((IResource)file));
        this.srcFile = srcFile;
        this.definitionName = null;
        this.templateFile = file;
        this.areaName = areaName;
        this.initializeData();
    }

    protected String getDefinition() {
        return this.definitionName;
    }

    protected void setEnabledDefaultPut(boolean enabled) {
        enabled = this.control.getEnabled() && enabled;
        this.defaultPutRadio.setEnabled(enabled);
        this.defaultPutFolderLabel.setEnabled(enabled);
        this.defaultPutFolder.setEnabled(enabled);
        this.defaultPutNameLabel.setEnabled(enabled);
        this.defaultPutName.setEnabled(enabled);
    }

    protected void setEnabledSelectedField(boolean enabled) {
        enabled = this.control.getEnabled() && enabled;
        this.selectFileFolder.setEnabled(enabled);
        this.selectFileName.setEnabled(enabled);
        this.selectFileFolderLabel.setEnabled(enabled);
        this.selectFileNameLabel.setEnabled(enabled);
        this.browseButton.setEnabled(enabled && !this.forceCreate);
    }

    protected void setEnabledDefinitionField(boolean enabled) {
        enabled = this.control.getEnabled() && enabled;
        this.definitionLabel.setEnabled(enabled);
        this.definitionCombo.setEnabled(enabled);
    }

    protected void setEnabledDirectTextField(boolean enabled) {
        enabled = this.control.getEnabled() && enabled;
        this.directText.setEnabled(enabled);
        this.directTextLabel.setEnabled(enabled);
    }

    protected void setEnabledSelection(boolean enabled) {
        this.selectFileRadio.setEnabled(this.control.getEnabled() && enabled);
    }

    protected void setEnabledDirectTextSelection(boolean enabled) {
        this.directTextRadio.setEnabled(this.control.getEnabled() && enabled);
    }

    protected void setEnabledDefinitionSelection(boolean enabled) {
        this.definitionRadio.setEnabled(this.control.getEnabled() && enabled);
    }

    protected void clearTexts() {
        this.selectFileFolder.setText(EMPTY_STRING);
        this.selectFileName.setText(EMPTY_STRING);
        this.defaultPutFolder.setText(EMPTY_STRING);
        this.defaultPutName.setText(EMPTY_STRING);
        this.directText.setText(EMPTY_STRING);
        this.definitionCombo.removeAll();
    }

    protected int getSelectedType() {
        if (this.defaultPutRadio.getSelection()) {
            return 1;
        }
        if (this.selectFileRadio.getSelection()) {
            return 2;
        }
        if (this.directTextRadio.getSelection()) {
            return 4;
        }
        if (this.definitionRadio.getSelection()) {
            return 5;
        }
        return 0;
    }

    protected String getFolderName() {
        Text text = null;
        int selection = this.getSelectedType();
        switch (selection) {
            case 1: {
                text = this.defaultPutFolder;
                break;
            }
            case 2: {
                text = this.selectFileFolder;
            }
        }
        return text != null ? text.getText() : EMPTY_STRING;
    }

    protected String getFileName() {
        Text text = null;
        int selection = this.getSelectedType();
        switch (selection) {
            case 1: {
                text = this.defaultPutName;
                break;
            }
            case 2: {
                text = this.selectFileName;
            }
        }
        return text != null ? text.getText() : EMPTY_STRING;
    }

    protected String getAreaName() {
        return this.areaName;
    }

    protected void initializeData() {
        this.definitionNames = new ArrayList();
        IPath excludePath = null;
        if (this.definitionName != null) {
            this.isDirect = Arrays.asList(this.getGetAreaNames(this.definitionName, false)).contains(this.areaName);
            this.setPutAreaMap(this.getDefinitionUtil().lookupPutAreaMapWithType(this.definitionName, true));
            excludePath = this.getDefinitionUtil().lookupTemplateJspFor(this.definitionName);
        } else if (this.templateFile != null) {
            this.isDirect = Arrays.asList(this.getGetAreaNames(this.templateFile, false)).contains(this.areaName);
            this.setPutAreaMap(new HashMap());
            excludePath = TilesDefinitionUtil.getWebFilePath((IVirtualComponent)this.component, (IFile)this.templateFile);
        }
        if (this.getDefinitionUtil() != null) {
            String[] definitionCandidates = this.getDefinitionUtil().getDefinitions();
            int i = 0;
            while (i < definitionCandidates.length) {
                if (excludePath == null || !excludePath.equals((Object)this.getDefinitionUtil().lookupTemplateJspFor(definitionCandidates[i]))) {
                    this.definitionNames.add(definitionCandidates[i]);
                }
                ++i;
            }
        }
        if (this.definitionNames.size() <= 0) {
            this.definitionNames = null;
        } else {
            Collections.sort(this.definitionNames);
        }
    }

    protected void updateFileFields() {
        this.suspendValidate = true;
        this.stopStore = true;
        this.clearTexts();
        String defaultPath = this.areaValue;
        if (defaultPath == null) {
            this.setEnabledSelection(false);
            this.setEnabledSelectedField(false);
            this.setEnabledDefaultPut(false);
            this.setEnabledDirectTextSelection(false);
            this.setEnabledDirectTextField(false);
            this.setEnabledDefinitionSelection(false);
            this.setEnabledDefinitionField(false);
            this.stopStore = false;
            this.suspendValidate = false;
            return;
        }
        int type = TilesConfigContentAreaUtil.getType(defaultPath);
        this.selectRadio(type);
        if (this.definitionNames != null) {
            Iterator it = this.definitionNames.iterator();
            while (it.hasNext()) {
                this.definitionCombo.add(it.next().toString());
            }
        }
        this.setEnabledDefinitionSelection(!this.forceCreate && this.definitionCombo.getItemCount() > 0);
        if (type == 4) {
            this.directText.setText(TilesConfigContentAreaUtil.getDirectText(defaultPath));
        } else if (type == 2 || type == 3) {
            IPath path = TilesConfigContentAreaUtil.getFilePath(defaultPath);
            if (path != null && path.segmentCount() > 0) {
                IFile file = this.srcFile != null ? TilesDefinitionUtil.getWebFile((IFile)this.srcFile, (IPath)path) : TilesDefinitionUtil.getWebFile((IVirtualComponent)this.component, (IPath)path);
                this.selectFileFolder.setText(file.getFullPath().removeLastSegments(1).toString());
                this.selectFileName.setText(path.lastSegment());
            } else {
                this.selectFileFolder.setText(EMPTY_STRING);
                this.selectFileName.setText(EMPTY_STRING);
            }
        } else if (type == 5) {
            this.definitionCombo.setText(TilesConfigContentAreaUtil.getDefinition(defaultPath));
        }
        if (this.putAreaMap != null && this.putAreaMap.get(this.areaName) != null) {
            this.setEnabledDefaultPut(!this.forceCreate);
            Object[] putValueArray = (Object[])this.putAreaMap.get(this.areaName);
            if ("page".equals(putValueArray[1])) {
                IFile file;
                Path path = new Path(putValueArray[0].toString());
                IFile iFile = file = this.srcFile != null ? TilesDefinitionUtil.getWebFile((IFile)this.srcFile, (IPath)path) : TilesDefinitionUtil.getWebFile((IVirtualComponent)this.component, (IPath)path);
                if (file != null) {
                    this.defaultPutFolder.setText(file.getFullPath().removeLastSegments(1).toString());
                }
                this.defaultPutName.setText(path.lastSegment());
            } else if ("definition".equals(putValueArray[1]) || "string".equals(putValueArray[1])) {
                this.defaultPutName.setText(putValueArray[0].toString());
            }
        } else {
            this.setEnabledDefaultPut(false);
            if (this.defaultPutRadio.getSelection()) {
                this.defaultPutRadio.setSelection(false);
            }
        }
        this.setEnabledDirectTextSelection(!this.forceCreate);
        this.setEnabledDirectTextField(type == 4);
        this.setEnabledDefinitionField(type == 5);
        if (this.isDirect) {
            this.selectFileRadio.setEnabled(false);
        } else {
            this.selectFileRadio.setEnabled(this.control.getEnabled());
            if (type == 0 || type == 1 && !this.defaultPutRadio.getSelection()) {
                this.selectRadio(2);
            }
        }
        if (this.selectFileFolder.getText() == null || this.selectFileFolder.getText().length() <= 0) {
            this.selectFileFolder.setText(this.component.getRootFolder().getUnderlyingFolder().getFullPath().append("tilesContent").toString());
        }
        this.stopStore = false;
        this.suspendValidate = false;
        this.validateData();
    }

    private void selectRadio(int selection) {
        this.defaultPutRadio.setSelection(selection == 1);
        this.selectFileRadio.setSelection(selection == 2 || selection == 3);
        this.directTextRadio.setSelection(selection == 4);
        this.definitionRadio.setSelection(selection == 5);
        this.setEnabledSelectedField(selection == 2 || selection == 3);
    }

    private void storeData() {
        if (this.stopStore) {
            return;
        }
        if (this.getAreaName() == null) {
            return;
        }
        Path path = null;
        int selected = this.getSelectedType();
        String newData = null;
        if (selected == 2) {
            String fileName = this.getFileName();
            if (fileName.length() > 0 && fileName.indexOf(46) < 0) {
                fileName = String.valueOf(fileName) + ".jsp";
            }
            if (fileName.length() > 0) {
                newData = this.errorsInFileNameAndFolder(fileName, this.getFolderName());
            }
            if (newData == null) {
                if (fileName.trim().length() > 0) {
                    path = new Path(this.getFolderName());
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path.append(fileName));
                    path = TilesDefinitionUtil.getWebFilePath((IVirtualComponent)this.component, (IFile)file);
                    if (!file.exists()) {
                        selected = 3;
                    }
                }
                if (path != null) {
                    newData = path.toString();
                }
            }
        } else if (selected == 4) {
            newData = this.directText.getText();
        } else if (selected == 5) {
            newData = this.definitionCombo.getText();
        } else if (selected == 1) {
            Object[] putValueArray = (Object[])this.putAreaMap.get(this.areaName);
            newData = TilesConfigContentAreaUtil.generateFromPutTypeValue(putValueArray, false);
        }
        if (newData == null) {
            newData = EMPTY_STRING;
        }
        if ((newData = this.forceCreate ? TilesConfigContentAreaUtil.generateForceCreateData(newData) : TilesConfigContentAreaUtil.generateData(selected, newData)) != null && !newData.equals(this.areaValue)) {
            this.areaValue = newData;
            this.fireSelectionChange();
        }
    }

    protected String errorsInFileNameAndFolder(String name, String folder) {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
        String message = null;
        if (status != null && !status.isOK()) {
            message = status.getMessage();
        } else {
            status = ResourcesPlugin.getWorkspace().validatePath(folder, 2);
            if (status != null && !status.isOK()) {
                message = status.getMessage();
            } else {
                Path filePath = new Path(folder);
                filePath = filePath.append(name);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
                if (!file.getProject().equals((Object)this.component.getProject())) {
                    message = ResourceHandler._UI_New_Fragment_Creation_Dialog_4;
                    message = NLS.bind((String)message, (Object)this.component.getProject().getName());
                } else if (!this.isInComponentRoot((IResource)file.getParent())) {
                    message = ResourceHandler._UI_New_Fragment_Creation_Dialog_5;
                }
            }
        }
        if (message != null) {
            return TilesConfigContentAreaUtil.generateErrorFilePathData(4, message);
        }
        return null;
    }

    private boolean isInComponentRoot(IResource resource) {
        if (resource != null && this.component != null) {
            IContainer container = this.component.getRootFolder().getUnderlyingFolder();
            IPath root = container.getFullPath();
            return root.isPrefixOf(resource.getFullPath());
        }
        return false;
    }

    protected boolean validateData() {
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.areaValue);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        Object sel;
        Object object = sel = selection != null ? ((StructuredSelection)selection).getFirstElement() : null;
        if (sel != null) {
            this.areaValue = sel.toString();
            this.forceCreate = TilesConfigContentAreaUtil.isForceCreate(this.areaValue);
        } else {
            this.areaValue = null;
            this.forceCreate = false;
        }
        this.updateFileFields();
    }

    protected void fireSelectionChange() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }
}

