/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles;

import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesFacetUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.tiles.ITilesConfigContentAreaConstants;
import com.ibm.etools.webpage.template.tiles.commands.TilesApplyTemplateCommand;
import com.ibm.etools.webpage.template.tiles.util.TilesConfigContentAreaUtil;
import com.ibm.etools.webpage.template.tiles.util.TilesNewFileUtil;
import com.ibm.etools.webpage.template.wizards.model.ApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.pages.operations.AbstractApplyTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.tiles.TilesApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.tiles.TilesSampleDefinitionElement;
import com.ibm.etools.webpage.template.wizards.tiles.TilesTemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NodeList;

public class TilesApplyTemplateToMultipageOperation
extends AbstractApplyTemplateToMultiPageOperation
implements ITilesConfigContentAreaConstants {
    private List newFiles = new ArrayList();

    public TilesApplyTemplateToMultipageOperation(ApplyTemplateDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected Object fixupTemplate(IVirtualComponent component, Object template, String ianaEncoding, Shell shell) {
        if ("".equals(ianaEncoding)) {
            ianaEncoding = null;
        }
        if (template instanceof TilesSampleDefinitionElement) {
            TilesSampleDefinitionElement ele = (TilesSampleDefinitionElement)((Object)template);
            return TilesTemplateURLFixup.performFixupAndRegisterSampleTemplate(ele, ianaEncoding, shell);
        }
        return template;
    }

    @Override
    protected HTMLCommand generateCommand(HTMLCommandTarget target, Map contentsMap) {
        TilesDefinitionElement ele = (TilesDefinitionElement)this.getDataModel().getTemplate();
        TilesApplyTemplateCommand command = new TilesApplyTemplateCommand(ele.getDefinitionName());
        command.setPutMap(((TilesApplyTemplateDataModel)this.getDataModel()).getPutValues(target.getActiveModel().getBaseLocation()));
        command.setCommandTarget(target);
        return command;
    }

    @Override
    protected void preApplyTemplate(final HTMLCommandTarget target, final Map contentsMap) {
        if (((TilesApplyTemplateDataModel)this.getDataModel()).getPutValues(target.getActiveModel().getBaseLocation()) == null) {
            ((TilesApplyTemplateDataModel)this.getDataModel()).setDefaultPutValues(target.getActiveModel().getBaseLocation(), contentsMap, this.newFiles);
        }
        final Map putMap = ((TilesApplyTemplateDataModel)this.getDataModel()).getPutValues(target.getActiveModel().getBaseLocation());
        boolean newFile = false;
        for (Object key : putMap.keySet()) {
            Object putValue = putMap.get(key);
            if (TilesConfigContentAreaUtil.getType(putValue.toString()) != 3) continue;
            newFile = true;
            break;
        }
        if (newFile) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    Iterator it = putMap.keySet().iterator();
                    IFile baseFile = WebComponent.getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)target.getActiveModel())));
                    while (it.hasNext()) {
                        Object key = it.next();
                        Object putValue = putMap.get(key);
                        if (TilesConfigContentAreaUtil.getType(putValue.toString()) != 3) continue;
                        IFile file = TilesDefinitionUtil.getWebFile((IFile)baseFile, (IPath)TilesConfigContentAreaUtil.getFilePath(putValue.toString()));
                        TilesNewFileUtil.createNewContentFile(target, TilesApplyTemplateToMultipageOperation.this.getDataModel().getFixuppedTemplate(), monitor, file, target.getActiveModel(), (NodeList)contentsMap.get(key));
                    }
                }
            };
            try {
                op.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException ite) {
                Logger.log((Throwable)ite);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected boolean validate(IDOMModel model, IFile file, TemplateModelSession session, ITemplateErrorInfo errorInfo, boolean templateSyntax, String ianaEncoding, Map contentsMap) {
        boolean destSyntax;
        if (model == null) {
            errorInfo.setUnexpactedError(true);
            return false;
        }
        boolean errorFound = false;
        String type = TilesUtil.getTilesType((IDOMModel)model);
        if ("TilesInstance".equals(type) || "TilesTemplate".equals(type)) {
            errorInfo.setFileTemplateError(true);
            errorFound = true;
        }
        if (templateSyntax != (destSyntax = WizardFileUtil.isXMLSyntaxJSP(file.getLocation()))) {
            errorInfo.setSyntaxError(true);
            errorFound = true;
        }
        if (contentsMap == null || contentsMap.size() <= 0) {
            errorInfo.setMappingError(true);
            errorFound = true;
        }
        if (!this.checkEncoding(ianaEncoding, file)) {
            errorInfo.setEncodingError(true);
            errorFound = true;
        }
        return !errorFound;
    }

    @Override
    public void doConfigComponent(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        TilesFacetUtil.installTilesFacet((IVirtualComponent)component, (IProgressMonitor)monitor);
    }
}

