/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles;

import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.tiles.util.TilesConfigContentAreaUtil;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.tiles.SpecifyContentFileNameTreeContentProvider;
import com.ibm.etools.webpage.template.wizards.tiles.areas.IContentAreaDescriptor;
import com.ibm.etools.webpage.template.wizards.tiles.areas.IPutMapHolder;
import com.ibm.etools.webpage.template.wizards.tiles.areas.ITilesPutMap;
import com.ibm.etools.webpage.template.wizards.tiles.areas.TilesConfigContentAreaLabelProvider;
import com.ibm.etools.webpage.template.wizards.tiles.areas.TilesConfigContentAreaWidget;
import com.ibm.etools.webpage.template.wizards.util.WizardIconUtil;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class SpecifyContentFileNamePage
extends WizardPage
implements IPutMapHolder {
    private TilesConfigContentAreaWidget widget = new TilesConfigContentAreaWidget(){

        @Override
        protected IContentProvider createContentProvider() {
            return new SpecifyContentFileNameTreeContentProvider(this.getPutMap());
        }

        @Override
        protected IBaseLabelProvider createLabelProvider() {
            return new TilesConfigContentAreaLabelProvider(this.getPutMap()){

                @Override
                public String getColumnText(Object element, int columnIndex) {
                    if (element instanceof SpecifyContentFileNameTreeContentProvider.ParentElement) {
                        SpecifyContentFileNameTreeContentProvider.ParentElement ele = (SpecifyContentFileNameTreeContentProvider.ParentElement)element;
                        if (columnIndex == 0) {
                            return String.valueOf(ele.getFileModelProxy().getTitle()) + "(" + ele.getFileModelProxy().getSrc() + ")";
                        }
                    }
                    return super.getColumnText(element, columnIndex);
                }

                @Override
                public Image getColumnImage(Object element, int columnIndex) {
                    if (columnIndex == 0 && element instanceof SpecifyContentFileNameTreeContentProvider.ParentElement) {
                        SpecifyContentFileNameTreeContentProvider.ParentElement ele = (SpecifyContentFileNameTreeContentProvider.ParentElement)element;
                        FileModelProxy proxy = ele.getFileModelProxy();
                        if (proxy.isRealized()) {
                            return SpecifyContentFileNamePage.this.iconUtil.getRealizeIcon();
                        }
                        return SpecifyContentFileNamePage.this.iconUtil.getUnRealizeIcon();
                    }
                    return super.getColumnImage(element, columnIndex);
                }
            };
        }
    };
    private final WizardIconUtil iconUtil = new WizardIconUtil();
    private Map mapInDef;

    public SpecifyContentFileNamePage() {
        super("Specify Content File Name");
        this.setTitle(ResourceHandler._UI_Specify_Content_File_Name_Page_1);
        this.setDescription(ResourceHandler._UI_Specify_Content_File_Name_Page_2);
    }

    public void createControl(Composite parent) {
        this.widget.setInput(this.getWizard());
        Control control = this.widget.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "com.ibm.etools.webpage.template.apltpl0050");
        this.widget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
                if ((selection = ((StructuredSelection)selection).getFirstElement()) instanceof IContentAreaDescriptor) {
                    Object value;
                    IContentAreaDescriptor desc = (IContentAreaDescriptor)selection;
                    Map map = SpecifyContentFileNamePage.this.getPutMap().getPutValues(ModelManagerUtil.calculateSSEModelId((IFile)desc.getFile()));
                    if (map != null && (value = map.get(desc.getAreaName())) != null) {
                        IStatus status = TilesConfigContentAreaUtil.validate(value.toString(), desc.getFile(), desc.getAreaName(), SpecifyContentFileNamePage.this.getMapInDefinition());
                        int type = 0;
                        switch (status.getSeverity()) {
                            case 4: {
                                type = 3;
                                break;
                            }
                            case 2: {
                                type = 2;
                                break;
                            }
                            case 1: {
                                type = 1;
                            }
                        }
                        if (type == 0) {
                            SpecifyContentFileNamePage.this.setMessage(ResourceHandler._UI_Specify_Content_File_Name_Page_2, 0);
                        } else {
                            SpecifyContentFileNamePage.this.setMessage(status.getMessage(), type);
                        }
                    }
                }
            }
        });
        this.setControl(control);
        this.setPageComplete(true);
    }

    @Override
    public ITilesPutMap getPutMap() {
        return this.widget.getPutMap();
    }

    @Override
    public void setPutMap(ITilesPutMap putMap) {
        if (this.getPutMap() != putMap) {
            this.mapInDef = null;
        }
        this.widget.setPutMap(putMap);
    }

    protected abstract void initializePage();

    public void setVisible(boolean visible) {
        if (visible) {
            this.initializePage();
            this.widget.aboutToShow();
        }
        super.setVisible(visible);
    }

    public void dispose() {
        this.iconUtil.dispose();
        this.widget.dispose();
        super.dispose();
    }

    protected Map getMapInDefinition() {
        if (this.mapInDef == null) {
            TilesDefinitionElement ele = (TilesDefinitionElement)this.getPutMap().getTemplate();
            TilesDefinitionUtil util = new TilesDefinitionUtil(ele.getComponent());
            try {
                this.mapInDef = util.lookupPutAreaMap(ele.getDefinitionName());
            }
            finally {
                util.dispose();
            }
        }
        return this.mapInDef;
    }
}

