/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.tiles;

import com.ibm.etools.tiles.util.ITilesConstants;
import com.ibm.etools.tiles.util.TilesDefinitionUtil;
import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.pages.operations.IReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.tiles.TilesReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicContentMappingTemplateDataModel
extends ContentMappingTemplateDataModel
implements ITilesConstants {
    public static final int STATIC = 0;
    public static final int DYNAMIC = 1;
    public static final int NONE = -1;
    private TilesDefinitionElement ele;
    private IDOMModel templateJspModel;
    private TilesDefinitionUtil defUtil;

    public static int getInstanceType(IDOMModel model) {
        if ("TilesInstance".equals(TilesUtil.getTilesType((IDOMModel)model))) {
            return 1;
        }
        if (TemplateTypeUtil.isInstance((IStructuredModel)model)) {
            return 0;
        }
        return -1;
    }

    public DynamicContentMappingTemplateDataModel(TilesDefinitionElement element) {
        this.ele = element;
        this.templateJspModel = SelectRegionsUtil.getTempTemplateModelForRead(element);
        if (this.templateJspModel == null) {
            return;
        }
        IVirtualComponent component = element.getComponent();
        this.defUtil = new TilesDefinitionUtil(component);
        String[] nodes = TilesUtil.collectGetAreaNames((IDOMModel)this.templateJspModel, (boolean)true, (boolean)true, (boolean)true);
        if (nodes == null) {
            return;
        }
    }

    protected TilesDefinitionUtil getDefinitionUtil() {
        return this.defUtil;
    }

    public TilesDefinitionElement getTilesTemplate() {
        return this.ele;
    }

    @Override
    public List getAreasInSourceModel(IDOMModel model) {
        String[] areaNames = TilesUtil.collectPutAreaNames((IDOMModel)model);
        return Arrays.asList(areaNames);
    }

    @Override
    public List getAreasInTemplate() {
        String[] nodes = TilesUtil.collectGetAreaNames((IDOMModel)this.templateJspModel, (boolean)true, (boolean)true, (boolean)true);
        return Arrays.asList(nodes);
    }

    @Override
    public Object getTemplate() {
        return this.ele;
    }

    @Override
    protected IDOMModel createPreviewModel(IDOMModel sourceModel) {
        if (this.getSourceModelType(sourceModel) != 1) {
            return null;
        }
        IDOMModel modelForPreview = this.createCopyModel(sourceModel);
        String prefix = TilesUtil.getTilesTaglibPrefix(null, (IDOMModel)modelForPreview);
        Element template = (Element)TilesUtil.getTemplateNode((IDOMModel)modelForPreview);
        if (this.ele.getFile().exists()) {
            template.setAttribute("definition", this.ele.getDefinitionName());
            template.removeAttribute("page");
        } else {
            Path tplLocation = new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)this.templateJspModel));
            IPath runtimePath = WebComponent.getVirtualResource((IResource)WebComponent.getFileForLocation((IPath)tplLocation)).getRuntimePath();
            template.setAttribute("page", runtimePath.toString());
            template.removeAttribute("definition");
        }
        List keys = this.getAreasInSourceModel(sourceModel);
        for (String key : keys) {
            Object value = this.getMappingData().get(key);
            Node node = TilesUtil.getPutAreaNode((IDOMModel)modelForPreview, (String)key);
            if (node != null) {
                if (value != null) {
                    ((Element)node).setAttribute("name", value.toString());
                    continue;
                }
                node.getParentNode().removeChild(node);
                continue;
            }
            if (value == null) continue;
            Element put = modelForPreview.getDocument().createElement(String.valueOf(prefix) + ":" + "put");
            put.setAttribute("name", value.toString());
            template.appendChild(put);
        }
        modelForPreview.setDirtyState(false);
        return modelForPreview;
    }

    @Override
    public boolean hasDefaultMap(String key) {
        Map map = null;
        map = this.ele.getFile().exists() ? this.defUtil.lookupPutAreaMap(this.ele.getDefinitionName()) : TilesUtil.collectPutAreaMap((IDOMModel)this.templateJspModel);
        return map != null && map.get(key) != null;
    }

    @Override
    public void releaseAllModel() {
        if (this.defUtil != null) {
            this.defUtil.dispose();
            this.defUtil = null;
        }
        if (this.templateJspModel != null) {
            this.templateJspModel.releaseFromRead();
            this.templateJspModel = null;
        }
        super.releaseAllModel();
    }

    public int getSourceModelType() {
        return this.getSourceModelType(this.getSourceModel());
    }

    private int getSourceModelType(IDOMModel model) {
        return DynamicContentMappingTemplateDataModel.getInstanceType(model);
    }

    @Override
    public IPath getTemplateLocation() {
        return SelectRegionsUtil.getTemplateLocation(this.ele);
    }

    @Override
    public boolean replaceable(IFile sourceFile) {
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        IStructuredModel sourceModel = mmu.getModelForRead(sourceFile);
        try {
            if (sourceModel instanceof IDOMModel) {
                boolean bl = TilesUtil.getTilesType((IDOMModel)((IDOMModel)sourceModel)).equals("TilesInstance");
                return bl;
            }
        }
        finally {
            if (sourceModel != null) {
                sourceModel.releaseFromRead();
            }
        }
        return false;
    }

    @Override
    public IReplaceTemplateToMultiPageOperation getMultiPageOperation() {
        return new TilesReplaceTemplateToMultiPageOperation(this);
    }

    protected IDOMModel getTemplateJspModel() {
        return this.templateJspModel;
    }
}

