/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.selecttpl;

import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webpage.template.selection.core.MyTemplateDescriptor;
import com.ibm.etools.webpage.template.selection.core.SampleTemplateDescriptor;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.selection.core.TilesTemplateDescriptor;
import com.ibm.etools.webpage.template.selection.ui.PageTemplateSelector;
import com.ibm.etools.webpage.template.selection.ui.PageThumbnailLabelProvider;
import com.ibm.etools.webpage.template.selection.ui.TemplateTreeContentProvider;
import com.ibm.etools.webpage.template.selection.ui.TemplateTreeNode;
import com.ibm.etools.webpage.template.wizards.selecttpl.AbstractSelectTemplateSampleTypeWidget;
import com.ibm.etools.webpage.template.wizards.selecttpl.TemplateFileManager;
import com.ibm.etools.webpage.template.wizards.tiles.TilesSampleDefinitionElement;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class AbstractTemplateSelectionWidget {
    protected IVirtualComponent webComponent;
    private IProject project;
    private boolean requiresTilesSamplePane;
    private boolean autoSelection;
    private boolean useSampleTemplate;
    private TemplateTreeContentProvider contentProvider;
    private PageThumbnailLabelProvider thumbnailProvider;
    protected Composite composite;
    protected PageTemplateSelector selector;
    protected Control selectorControl;
    protected AbstractSelectTemplateSampleTypeWidget sampleTypeWidget;
    private boolean templateSelectionChanging;

    public AbstractTemplateSelectionWidget(Shell shell, IVirtualComponent component, boolean requiresStaticTemplate) {
        this(shell, component, component == null ? null : component.getProject(), requiresStaticTemplate ? new StaticTemplateTreeContentProvider() : new TemplateTreeContentProvider(), new PageThumbnailLabelProvider(), !requiresStaticTemplate);
    }

    public AbstractTemplateSelectionWidget(Shell shell, IProject project, boolean requiresStaticTemplate) {
        this(shell, WebComponent.getComponent((IResource)project), project, requiresStaticTemplate ? new StaticTemplateTreeContentProvider() : new TemplateTreeContentProvider(), new PageThumbnailLabelProvider(), !requiresStaticTemplate);
    }

    public AbstractTemplateSelectionWidget(Shell shell, IFile file) {
        this(shell, WebComponent.getComponent((IResource)file), AbstractTemplateSelectionWidget.isStatic(file, null));
    }

    public AbstractTemplateSelectionWidget(Shell shell, IVirtualComponent component, IProject project, TemplateTreeContentProvider contentProvider, PageThumbnailLabelProvider thumbnailProvider, boolean requiresTilesSamplePane) {
        this.webComponent = component;
        this.project = project;
        this.contentProvider = contentProvider;
        this.thumbnailProvider = thumbnailProvider;
        this.requiresTilesSamplePane = requiresTilesSamplePane && project != null && project.exists();
        TemplateFileManager fileManager = this.getFileManager();
        fileManager.initialize();
    }

    protected abstract void templateSelected(Object var1);

    protected void dispose() {
        TemplateFileManager templateFileManager = this.getFileManager();
        if (templateFileManager != null) {
            templateFileManager.initialize();
        }
    }

    protected IVirtualComponent getComponent() {
        return this.webComponent;
    }

    public void createControls(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                AbstractTemplateSelectionWidget.this.dispose();
            }
        });
        this.selector = new PageTemplateSelector(this.contentProvider, this.thumbnailProvider);
        this.selectorControl = this.selector.createComposite(this.composite);
        this.selectorControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTemplateSelectionWidget.this.templateSelectionChanged(AbstractTemplateSelectionWidget.this.selector);
            }
        });
        this.selector.setProject(this.project, true);
        if (this.requiresTilesSamplePane) {
            this.sampleTypeWidget = new AbstractSelectTemplateSampleTypeWidget(){

                @Override
                protected void templateNameModified(String name) {
                    AbstractTemplateSelectionWidget.this.templateSelectionChanged(AbstractTemplateSelectionWidget.this.sampleTypeWidget);
                }

                @Override
                protected void templateTypeSelected(boolean staticTemplate) {
                    AbstractTemplateSelectionWidget.this.templateSelectionChanged(AbstractTemplateSelectionWidget.this.sampleTypeWidget);
                }
            };
            this.sampleTypeWidget.createControls(this.composite);
        }
        this.updateControls();
    }

    public void setEnabled(boolean enabled) {
        this.composite.setEnabled(enabled);
        this.selector.setEnabled(enabled);
        this.updateControls();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void templateSelectionChanged(Object source) {
        if (this.templateSelectionChanging) {
            return;
        }
        this.templateSelectionChanging = true;
        try {
            TilesDefinitionElement template = null;
            boolean isSampleTemplateSelected = false;
            ITemplateDescriptor desc = this.getTemplateDescriptorFromSelection(this.selector.getSelection());
            if (desc == null) {
                template = null;
            } else if (desc.getCategory() == 2) {
                if (this.sampleTypeWidget != null) {
                    this.sampleTypeWidget.setDynamicSampleSelected(desc.isTiles());
                }
                if (desc instanceof TilesTemplateDescriptor) {
                    template = this.getTilesDefinisionElement((TilesTemplateDescriptor)desc);
                } else {
                    if (!(desc instanceof MyTemplateDescriptor)) throw new RuntimeException("Unknown template descriptor type: " + desc.getClass().getName());
                    template = ((MyTemplateDescriptor)desc).getContentPath();
                }
            } else if (desc.getCategory() == 1) {
                if (this.sampleTypeWidget != null && !this.sampleTypeWidget.isEnabled() && this.composite.getEnabled()) {
                    this.sampleTypeWidget.setDynamicSampleSelected(true);
                }
                template = ((SampleTemplateDescriptor)desc).getContentPath();
                if (this.sampleTypeWidget != null && this.sampleTypeWidget.isDynamicSampleSelected()) {
                    IPath sampleLocation = (IPath)template;
                    template = new TilesSampleDefinitionElement(this.getComponent(), sampleLocation);
                }
                isSampleTemplateSelected = true;
            }
            this.updateControls();
            this.templateSelected(template);
            this.setTemplateSelectionToFileManager(template, isSampleTemplateSelected);
            if (this.selector == null || desc == null) return;
            String templateType = null;
            boolean tilesTemplate = desc.isTiles() || this.sampleTypeWidget != null && this.sampleTypeWidget.isDynamicSampleSelected();
            templateType = tilesTemplate ? NLS.bind((String)ResourceHandler._UI_AbstractTemplateSelectionWidget_0, (Object)desc.getName()) : NLS.bind((String)ResourceHandler._UI_AbstractTemplateSelectionWidget_1, (Object)desc.getName());
            this.selector.setTemplateTypeText(templateType);
            return;
        }
        finally {
            this.templateSelectionChanging = false;
        }
    }

    protected void updateControls() {
        if (this.sampleTypeWidget != null) {
            ITemplateDescriptor descSelector = this.getTemplateDescriptorFromSelection(this.selector.getSelection());
            if (descSelector != null && descSelector.getCategory() == 1) {
                this.sampleTypeWidget.setEnabled(this.composite.getEnabled());
            } else {
                this.sampleTypeWidget.setEnabled(false);
            }
        }
    }

    public void setAutoSelection(boolean autoSelection) {
        this.autoSelection = autoSelection;
        this.executeAutoSelection();
    }

    public void setUseSampleTemplate(boolean useSampleTemplate) {
        this.useSampleTemplate = useSampleTemplate;
        if (useSampleTemplate) {
            this.forceExecuteAutoSelection();
        }
    }

    protected void executeAutoSelection() {
        if (this.autoSelection && this.getTemplateDescriptorFromSelection(this.selector.getSelection()) == null) {
            this.forceExecuteAutoSelection();
        }
    }

    private void forceExecuteAutoSelection() {
        final ITemplateDescriptor[] firstOne = new ITemplateDescriptor[1];
        this.acceptContentProvider(new Visitor(){

            @Override
            public boolean visit(ITemplateDescriptor desc) {
                if (AbstractTemplateSelectionWidget.this.useSampleTemplate && desc.getCategory() != 1) {
                    return true;
                }
                firstOne[0] = desc;
                return false;
            }
        });
        if (firstOne[0] != null) {
            this.selector.setSelection((ISelection)new StructuredSelection((Object)firstOne[0]));
        }
    }

    public void setInitialTemplateFile(Object initialTemplate) {
        ITemplateDescriptor found = null;
        boolean tiles = false;
        if (initialTemplate instanceof IPath) {
            IFile file = WebComponent.getFileForLocation((IPath)((IPath)initialTemplate));
            found = file != null ? this.searchDescriptor((ITemplateDescriptor)new MyTemplateDescriptor(file)) : this.searchSample((IPath)initialTemplate);
        } else if (initialTemplate instanceof TilesSampleDefinitionElement) {
            if (this.sampleTypeWidget != null) {
                found = this.searchSample(((TilesSampleDefinitionElement)((Object)initialTemplate)).getSampleLocation());
            }
            tiles = true;
        } else if (initialTemplate instanceof TilesDefinitionElement) {
            found = this.searchDescriptor((ITemplateDescriptor)new TilesTemplateDescriptor(((TilesDefinitionElement)initialTemplate).getDefinitionName(), this.project));
            tiles = true;
        }
        if (found != null) {
            this.selector.setSelection((ISelection)new StructuredSelection((Object)found));
            if (this.sampleTypeWidget != null) {
                this.sampleTypeWidget.setDynamicSampleSelected(tiles);
            }
        }
    }

    public void setAndValidateInitialSelection(Object template) {
        this.setInitialTemplateFile(template);
    }

    private ITemplateDescriptor searchDescriptor(final ITemplateDescriptor desc) {
        final ITemplateDescriptor[] result = new ITemplateDescriptor[1];
        this.acceptContentProvider(new Visitor(){

            @Override
            public boolean visit(ITemplateDescriptor cur) {
                if (desc.getID() == cur.getID()) {
                    result[0] = desc;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    private ITemplateDescriptor searchSample(final IPath sample) {
        final ITemplateDescriptor[] result = new ITemplateDescriptor[1];
        this.acceptContentProvider(new Visitor(){

            @Override
            public boolean visit(ITemplateDescriptor cur) {
                if (cur instanceof SampleTemplateDescriptor && ((SampleTemplateDescriptor)cur).getContentPath().equals((Object)sample)) {
                    result[0] = cur;
                    return false;
                }
                return true;
            }
        });
        return result[0];
    }

    protected ITemplateDescriptor getTemplateDescriptorFromSelection(ISelection selection) {
        Object selected = ((IStructuredSelection)selection).getFirstElement();
        if (selected instanceof ITemplateDescriptor) {
            return (ITemplateDescriptor)selected;
        }
        return null;
    }

    protected TilesDefinitionElement getTilesDefinisionElement(TilesTemplateDescriptor tilesDescriptor) {
        IVirtualComponent component = (IVirtualComponent)tilesDescriptor.getProject().getAdapter(IVirtualComponent.class);
        return new TilesDefinitionElement(tilesDescriptor.getID(), component);
    }

    private void setTemplateSelectionToFileManager(Object path, boolean isSample) {
        TemplateFileManager fileManager = this.getFileManager();
        if (fileManager == null) {
            return;
        }
        fileManager.setSelection(path);
        fileManager.setUseSample(isSample);
    }

    protected TemplateFileManager getFileManager() {
        return TemplateFileManager.getInstance();
    }

    public void setRequiresTilesSamplePane(boolean requiresTilesSamplePane) {
        this.requiresTilesSamplePane = requiresTilesSamplePane;
    }

    protected final boolean acceptContentProvider(Visitor visitor) {
        return this.acceptContentProvider(visitor, this.contentProvider.getElements((Object)this.project));
    }

    private boolean acceptContentProvider(Visitor visitor, Object[] elements) {
        if (elements == null) {
            return true;
        }
        int i = 0;
        while (i < elements.length) {
            ITemplateDescriptor desc;
            Object element = elements[i];
            if (element instanceof TemplateTreeNode && (desc = ((TemplateTreeNode)element).getTemplateDescriptor()) != null && !visitor.visit(desc)) {
                return false;
            }
            if (!this.acceptContentProvider(visitor, this.contentProvider.getChildren(element))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isStatic(IFile file, String location) {
        if (file != null) {
            return FileTypeHandler.getFileType((IFile)file) == "html";
        }
        if (location != null) {
            return FileTypeHandler.getFileType((String)location) == "html";
        }
        return false;
    }

    static class StaticTemplateTreeContentProvider
    extends TemplateTreeContentProvider {
        StaticTemplateTreeContentProvider() {
        }

        protected List validateTemplates(List descs) {
            Iterator iter = descs.iterator();
            while (iter.hasNext()) {
                ITemplateDescriptor desc = (ITemplateDescriptor)iter.next();
                if (desc.getPageType() == "STATIC") continue;
                iter.remove();
            }
            return descs;
        }
    }

    protected static interface Visitor {
        public boolean visit(ITemplateDescriptor var1);
    }
}

