/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.testpreview;

import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.internal.wizards.ApplyTemplateValidationFacade;
import com.ibm.etools.webpage.template.internal.wizards.WizardMessageHolder;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ErrorInfoValidationUtil {
    public static WizardMessageHolder generateWizardMessage(ITemplateErrorInfo errorInfo) {
        WizardMessageHolder result = new WizardMessageHolder();
        if (errorInfo == null) {
            return result;
        }
        int state = 0;
        String msg = null;
        if (errorInfo.isCommandError()) {
            state = 3;
            msg = IMsgReplaceTemplateErrorInfo.MSG_UNEXPECTED_ERROR;
        } else if (errorInfo.isFileTemplateError()) {
            state = 1;
            msg = IMsgReplaceTemplateErrorInfo.MSG_HAS_TEMPLATE_ERROR;
        } else if (errorInfo.isCommandError()) {
            state = 3;
            msg = IMsgReplaceTemplateErrorInfo.MSG_UNEXPECTED_ERROR;
        } else if (errorInfo.isCyclicNestingError()) {
            state = 3;
            msg = IMsgReplaceTemplateErrorInfo.MSG_CYCLIC_NESTING_ERROR;
        } else if (errorInfo.isEncodingError()) {
            state = 3;
            msg = IMsgReplaceTemplateErrorInfo.MSG_ENCODING_ERROR;
        } else if (errorInfo.isMappingError()) {
            state = 3;
            msg = IMsgReplaceTemplateErrorInfo.MSG_MAPPING_ERROR;
        } else if (errorInfo.isSyntaxError()) {
            state = 3;
            msg = IMsgReplaceTemplateErrorInfo.MSG_JSP_SYNTAX_ERROR;
        } else if (errorInfo.isExpandMapping()) {
            state = 2;
            msg = IMsgReplaceTemplateErrorInfo.MSG_EXPAND_MAPPING_WARNING;
        }
        result.setMessage(msg, state);
        result.updateMessage(errorInfo.getExternalValidsationError());
        return result;
    }

    public static void execExternalValidation(ITemplateErrorInfo baseErrorInfo, TemplateWizardDataModel tpl, IDOMModel instanceModel) {
        if (!baseErrorInfo.hasSomeError()) {
            int currentType;
            WizardMessageHolder external = ApplyTemplateValidationFacade.getInstance().validateForApply(tpl.getTemplate(), instanceModel);
            int n = currentType = baseErrorInfo.hasSomeWarning() ? 2 : 0;
            if (external.getMessageType() > currentType) {
                baseErrorInfo.setExternalValidationError(external);
            }
        }
    }

    public static void execExternalValidation(ITemplateErrorInfo baseErrorInfo, IPath templatePath, IDOMModel instanceModel) {
        if (!baseErrorInfo.hasSomeError()) {
            int currentType;
            WizardMessageHolder external = ApplyTemplateValidationFacade.getInstance().validateForApply(templatePath, instanceModel);
            int n = currentType = baseErrorInfo.hasSomeWarning() ? 2 : 0;
            if (external.getMessageType() > currentType) {
                baseErrorInfo.setExternalValidationError(external);
            }
        }
    }
}

