/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.testpreview;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.internal.wizards.WizardMessageHolder;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITestPreviewDataModel;
import com.ibm.etools.webpage.template.wizards.pages.composer.ISelectTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.AbstractPreviewWithTestButton;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.ErrorInfoValidationUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardIconUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractTPLPreviewListWithTest
extends AbstractPreviewWithTestButton {
    protected String selectPaneLabel;
    CheckboxTableViewer listViewer;
    protected IFile displayedSourceFile;
    private Object selectedObjCache;
    private boolean checkStateCache;
    protected MyPrev runnable;
    Map replaceErrorList = new HashMap();

    AbstractTPLPreviewListWithTest(String sLabel, String sName, String sShortCut, String rLabel, String rName, String rShortCut, String eLabel, String eTooltip, String tLabel, String tTooltip, String paneLabel) {
        super(sLabel, sName, sShortCut, rLabel, rName, rShortCut, eLabel, eTooltip, tLabel, tTooltip);
        this.selectPaneLabel = paneLabel;
    }

    @Override
    protected Control createSelectPane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(this.selectPaneLabel);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.listViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.listViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractTPLPreviewListWithTest.this.listViewer.getLabelProvider().dispose();
            }
        });
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                AbstractTPLPreviewListWithTest.this.fireCheckPressed(e);
                AbstractTPLPreviewListWithTest.this.fireUpdateFrag(e);
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                boolean doReplace;
                Object selectedObj = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (selectedObj == null) {
                    AbstractTPLPreviewListWithTest.this.fireSelectionChanged(null, false, false);
                    return;
                }
                FileModelProxy proxy = null;
                IFile file = null;
                if (selectedObj instanceof FileModelProxy) {
                    proxy = (FileModelProxy)selectedObj;
                    file = proxy.getFile();
                }
                AbstractTPLPreviewListWithTest.this.doReplaceTest(proxy);
                boolean checkState = AbstractTPLPreviewListWithTest.this.listViewer.getChecked(selectedObj);
                boolean bl = doReplace = !AbstractTPLPreviewListWithTest.this.listViewer.getGrayed(selectedObj) && checkState;
                if (selectedObj.equals(AbstractTPLPreviewListWithTest.this.selectedObjCache)) {
                    if (checkState == AbstractTPLPreviewListWithTest.this.checkStateCache) {
                        return;
                    }
                    if (AbstractTPLPreviewListWithTest.this.displayedSourceFile != null && AbstractTPLPreviewListWithTest.this.displayedSourceFile.equals((Object)file)) {
                        AbstractTPLPreviewListWithTest.this.fireSelectionChanged(file, doReplace, false);
                    } else {
                        AbstractTPLPreviewListWithTest.this.fireSelectionChanged(file, doReplace, true);
                    }
                } else {
                    AbstractTPLPreviewListWithTest.this.fireSelectionChanged(file, doReplace, true);
                }
                AbstractTPLPreviewListWithTest.this.showErrorMsg(selectedObj, proxy);
                AbstractTPLPreviewListWithTest.this.selectedObjCache = selectedObj;
                AbstractTPLPreviewListWithTest.this.checkStateCache = checkState;
            }
        });
        return composite;
    }

    void showErrorMsg(Object selectedObj, FileModelProxy selectedProxy) {
        Object obj;
        WizardMessageHolder result = new WizardMessageHolder();
        if (selectedProxy != null && (obj = this.replaceErrorList.get(selectedProxy)) instanceof ITemplateErrorInfo) {
            result.updateMessage(ErrorInfoValidationUtil.generateWizardMessage((ITemplateErrorInfo)obj));
        }
        this.setMessageToPage(result.getMessageType(), result.getMessage(), selectedObj);
    }

    protected final void fireSelectionChanged(IFile file, boolean doReplace, boolean doUpdateSource) {
        if (file != null && file.exists()) {
            this.setEnablePreview(true, doReplace);
            ITestPreviewDataModel dataModel = this.getDataModel();
            this.updatePreview(file, doReplace, dataModel, doUpdateSource);
        } else {
            if (this.runnable != null) {
                this.runnable.kill();
                this.runnable = null;
            }
            this.setEnablePreview(false, false);
            this.displayedSourceFile = null;
        }
    }

    @Override
    protected void fireSelectAllButtonPressed() {
        int itemCount = this.listViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            Object obj = this.listViewer.getElementAt(i);
            if (!this.listViewer.getGrayed(obj)) {
                this.listViewer.setChecked(obj, true);
                this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, true));
                this.listViewer.setSelection(this.listViewer.getSelection());
            }
            ++i;
        }
    }

    @Override
    protected void fireDeselectAllButtonPressed() {
        int itemCount = this.listViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            Object obj = this.listViewer.getElementAt(i);
            if (!this.listViewer.getGrayed(obj)) {
                this.listViewer.setChecked(obj, false);
                this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, false));
                this.listViewer.setSelection(this.listViewer.getSelection());
            }
            ++i;
        }
    }

    protected void fireUpdateFrag(CheckStateChangedEvent e) {
        Object obj = e.getElement();
        boolean bln = true;
        if (this.listViewer.getGrayed(obj) || !this.listViewer.getChecked(obj)) {
            bln = false;
        }
        if (obj instanceof FileModelProxy) {
            FileModelProxy proxy = (FileModelProxy)obj;
            proxy.setApplyTemplateFlag(bln);
        }
    }

    protected void fireCheckPressed(CheckStateChangedEvent e) {
        Object obj = e.getElement();
        if (this.listViewer.getGrayed(obj)) {
            this.listViewer.setChecked(obj, false);
        }
    }

    final void doReplaceTest(FileModelProxy selectedFileModelProxy) {
        ITestPreviewDataModel dataModel;
        if (selectedFileModelProxy == null || !selectedFileModelProxy.isRealized() || selectedFileModelProxy.getFile() == null) {
            return;
        }
        if (this.replaceErrorList == null) {
            this.replaceErrorList = new HashMap();
        }
        if ((dataModel = this.getDataModel()) == null) {
            return;
        }
        IPath tplPath = dataModel.getTemplateLocation();
        if (tplPath == null) {
            return;
        }
        IDOMModel instanceModel = null;
        try {
            IFile selectedFile = selectedFileModelProxy.getFile();
            instanceModel = SelectRegionsUtil.getModelForRead(selectedFile);
            if (TemplateURLFixup.isSample(tplPath)) {
                IWizard iWiz = this.getWiz();
                if (iWiz instanceof ISelectTplComposeInfo) {
                    ISelectTplComposeInfo wizard = (ISelectTplComposeInfo)iWiz;
                    IDOMModel masterPageModel = wizard.getSourceFileModel();
                    dataModel.setMasterEncoding(WizardFileUtil.getIANAEncoding((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)masterPageModel))));
                }
            } else {
                dataModel.setMasterEncoding(WizardFileUtil.getIANAEncoding(tplPath));
            }
            ITemplateErrorInfo errorInfo = dataModel.getErrorInfo(instanceModel);
            errorInfo.setErrorFileModelProxy(new FileModelProxy(selectedFile));
            if (errorInfo.hasSomeMessage()) {
                this.replaceErrorList.put(selectedFileModelProxy, errorInfo);
            } else {
                this.replaceErrorList.remove(selectedFileModelProxy);
            }
        }
        finally {
            if (instanceModel != null) {
                instanceModel.releaseFromRead();
                instanceModel = null;
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible && this.listViewer != null && this.listViewer.getControl() != null && !this.listViewer.getControl().isDisposed() && !this.listViewer.getSelection().isEmpty()) {
            this.fireSelectionChanged(null, false, false);
            this.selectedObjCache = null;
            this.listViewer.setSelection(this.listViewer.getSelection(), true);
        }
    }

    protected abstract ITestPreviewDataModel getDataModel();

    abstract void updatePreview(IFile var1, boolean var2, ITestPreviewDataModel var3, boolean var4);

    abstract void setMessageToPage(int var1, String var2, Object var3);

    protected abstract IWizard getWiz();

    protected class MyException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private boolean displaySource;
        private boolean displayResult;

        protected MyException(boolean displaySource, boolean displayResult) {
            this.displaySource = displaySource;
            this.displayResult = displayResult;
        }

        boolean isDisplayResult() {
            return this.displayResult;
        }

        boolean isDisplaySource() {
            return this.displaySource;
        }
    }

    private class MyLabelProvider
    extends LabelProvider {
        private final WizardIconUtil iconUtil = new WizardIconUtil();

        private MyLabelProvider() {
        }

        public void dispose() {
            if (this.iconUtil != null) {
                this.iconUtil.dispose();
            }
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof FileModelProxy) {
                ITemplateErrorInfo info;
                FileModelProxy proxy = (FileModelProxy)element;
                image = proxy.isRealized() ? this.iconUtil.getRealizeIcon() : this.iconUtil.getUnRealizeIcon();
                if (AbstractTPLPreviewListWithTest.this.replaceErrorList != null && (info = (ITemplateErrorInfo)AbstractTPLPreviewListWithTest.this.replaceErrorList.get(proxy)) != null && info.hasSomeError()) {
                    image = JFaceResources.getImage((String)"dialog_message_error_image");
                }
            }
            return image;
        }

        public String getText(Object element) {
            if (element instanceof FileModelProxy) {
                FileModelProxy proxy = (FileModelProxy)element;
                String title = proxy.getTitle();
                String path = proxy.getSrc();
                return String.valueOf(title) + "(" + path + ")";
            }
            return "";
        }
    }

    protected abstract class MyPrev
    implements Runnable {
        private boolean kill = false;
        protected IFile sourceFile;
        protected boolean doReplaceTemplate;
        protected ITestPreviewDataModel dataModel;
        protected boolean doUpdateSource;

        protected MyPrev() {
        }

        abstract void doUpdatePreview() throws MyException;

        public void init(IFile sourceFile, boolean doReplaceTemplate, ITestPreviewDataModel dataModel, boolean doUpdateSource) {
            this.sourceFile = sourceFile;
            this.doReplaceTemplate = doReplaceTemplate;
            this.dataModel = dataModel;
            this.doUpdateSource = doUpdateSource;
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                dsp.timerExec(2000, (Runnable)this);
            }
        }

        public void kill() {
            this.kill = true;
        }

        @Override
        public void run() {
            if (this.kill) {
                return;
            }
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                BusyIndicator.showWhile((Display)dsp, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                MyPrev.this.doUpdatePreview();
                            }
                            catch (MyException e) {
                                if (!e.isDisplaySource()) {
                                    AbstractTPLPreviewListWithTest.this.getPrevSource().setModel(null);
                                }
                                if (e.isDisplayResult()) break block3;
                                AbstractTPLPreviewListWithTest.this.getPrevResult().setModel(null);
                            }
                        }
                    }
                });
            }
            AbstractTPLPreviewListWithTest.this.displayedSourceFile = this.sourceFile;
        }
    }
}

