/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.testpreview;

import com.ibm.etools.webpage.template.dialog.CannotReplaceTPLDialog;
import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.selection.ui.viewer.TilesDefinitionImageItemProvider;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITestPreviewDataModel;
import com.ibm.etools.webpage.template.wizards.pages.composer.IReplaceTemplateComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgComposer;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.AbstractTPLPreviewListWithTest;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractReplaceTPLPreviewList
extends AbstractTPLPreviewListWithTest {
    private String errorStatusMessage;
    private String failureDialogMessage;
    private String successfulDialogMessage;
    private boolean updateLabelRequired;

    public static String[] getParamsForReplace() {
        String[] result = new String[]{REPLACE_TPL_PREVIEW_SOURCE_PREVIEW, REPLACE_TPL_PREVIEW_SOURCE_PREVIEW_NAME, REPLACE_TPL_PREVIEW_SOURCE_PREVIEW_SHORTCUT, REPLACE_TPL_PREVIEW_RESULT_PREVIEW, REPLACE_TPL_PREVIEW_RESULT_PREVIEW_NAME, REPLACE_TPL_PREVIEW_RESULT_PREVIEW_SHORTCUT, SHOW_ERROR_PAGES_BUTTON, SHOW_ERROR_PAGES_BUTTON_FOR_REPLACE_TOOLTIP, TEST_APPLY_BUTTON, TEST_REPLACE_BUTTON_TOOLTIP, REPLACE_TPL_TREE_LABEL, IMsgReplaceTemplateErrorInfo.MSG_CANNOT_REPLACE, IMsgReplaceTemplateErrorInfo.MSG_COULDNOT_REPLACE, IMsgReplaceTemplateErrorInfo.MSG_CAN_REPLACE_ALL_PAGES};
        return result;
    }

    public static String[] getParamsForFix() {
        String[] result = new String[]{FIX_TPL_PREVIEW_SOURCE_PREVIEW, FIX_TPL_PREVIEW_SOURCE_PREVIEW_NAME, FIX_TPL_PREVIEW_SOURCE_PREVIEW_SHORTCUT, FIX_TPL_PREVIEW_RESULT_PREVIEW, FIX_TPL_PREVIEW_RESULT_PREVIEW_NAME, FIX_TPL_PREVIEW_RESULT_PREVIEW_SHORTCUT, SHOW_ERROR_PAGES_BUTTON, SHOW_ERROR_PAGES_BUTTON_FOR_FIX_TOOLTIP, TEST_APPLY_BUTTON, TEST_FIX_BUTTON_TOOLTIP, FIX_TPL_TREE_LABEL, IMsgReplaceTemplateErrorInfo.MSG_CANNOT_FIX, IMsgReplaceTemplateErrorInfo.MSG_COULDNOT_FIX, IMsgReplaceTemplateErrorInfo.MSG_CAN_FIX_ALL_PAGES};
        return result;
    }

    protected AbstractReplaceTPLPreviewList(String[] params, boolean updateLabelRequired) {
        super(params[0], params[1], params[2], params[3], params[4], params[5], params[6], params[7], params[8], params[9], params[10]);
        this.errorStatusMessage = params[11];
        this.failureDialogMessage = params[12];
        this.successfulDialogMessage = params[13];
        this.updateLabelRequired = updateLabelRequired;
    }

    @Override
    protected void setMessageToPage(int state, String msg, Object selectedObj) {
        if (state == 3) {
            msg = NLS.bind((String)this.errorStatusMessage, (Object)msg);
            this.listViewer.setChecked(selectedObj, false);
            this.listViewer.setGrayed(selectedObj, true);
            this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, selectedObj, false));
        } else if (state == 2) {
            this.listViewer.setGrayed(selectedObj, false);
        } else {
            this.listViewer.setGrayed(selectedObj, false);
        }
        this.setValidateMessage(state, msg);
        this.listViewer.refresh(selectedObj);
    }

    protected abstract void setValidateMessage(int var1, String var2);

    public void initializeViewer(FileModelProxy[] inputItems) {
        List<FileModelProxy> items = Arrays.asList(inputItems);
        this.listViewer.setInput(items);
        for (FileModelProxy proxy : items) {
            this.listViewer.setChecked((Object)proxy, true);
            this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, (Object)proxy, this.listViewer.getChecked((Object)proxy)));
        }
        this.listViewer.setSelection(this.listViewer.getSelection(), true);
        if (this.updateLabelRequired) {
            this.updatePreviewLabel(this.getSourcePreviewLabel(), this.getSourcePreviewName(), this.getResultPreviewLabel(), this.getResultPreviewName());
        }
    }

    @Override
    protected void fireShowErrorButtonPressed() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (shell == null) {
            return;
        }
        Collection cl = this.replaceErrorList.values();
        boolean hasError = false;
        ITemplateErrorInfo[] infoArray = null;
        if (cl != null && cl.size() != 0) {
            infoArray = cl.toArray(new ITemplateErrorInfo[cl.size()]);
            int i = 0;
            while (i < infoArray.length) {
                ITemplateErrorInfo info = infoArray[i];
                if (info.hasSomeError()) {
                    hasError = true;
                    break;
                }
                ++i;
            }
        }
        if (hasError) {
            CannotReplaceTPLDialog.openError(shell, IMsgReplaceTemplateErrorInfo.TITLE_ERROR_PAGES, this.failureDialogMessage, infoArray);
        } else {
            MessageDialog.openInformation((Shell)shell, (String)IMsgReplaceTemplateErrorInfo.TITLE_ERROR_PAGES, (String)this.successfulDialogMessage);
        }
    }

    @Override
    protected final void updatePreview(IFile file, boolean doReplace, ITestPreviewDataModel dataModel, boolean doUpdateSource) {
        if (this.runnable != null) {
            this.runnable.kill();
            this.runnable = null;
        }
        this.runnable = new MyUpdatePreview();
        this.runnable.init(file, doReplace, dataModel, doUpdateSource);
    }

    public void doReplaceTestToAll(IProgressMonitor monitor) throws InterruptedException {
        if (this.listViewer == null) {
            return;
        }
        List items = (List)this.listViewer.getInput();
        if (items == null) {
            return;
        }
        try {
            monitor.beginTask(IMsgComposer.PROGRESS_PROCESSING, items.size());
            Iterator it = items.iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                Object obj = it.next();
                if (obj instanceof FileModelProxy) {
                    monitor.subTask(((FileModelProxy)obj).getSrc());
                    this.doReplaceTest((FileModelProxy)obj);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refleshViewer() {
        this.listViewer.refresh();
        int numOfError = 0;
        try {
            List items = (List)this.listViewer.getInput();
            if (items == null) {
                return;
            }
            if (this.replaceErrorList == null) {
                return;
            }
            for (Object obj : items) {
                ITemplateErrorInfo info;
                if (!(obj instanceof FileModelProxy)) continue;
                FileModelProxy proxy = (FileModelProxy)obj;
                if (this.replaceErrorList.containsKey(proxy) && (info = (ITemplateErrorInfo)this.replaceErrorList.get(proxy)).hasSomeError()) {
                    this.listViewer.setGrayed(obj, true);
                    this.listViewer.setChecked(obj, false);
                    this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, false));
                    ++numOfError;
                    continue;
                }
                this.listViewer.setGrayed(obj, false);
            }
            return;
        }
        finally {
            this.setErrorNumber(numOfError);
        }
    }

    @Override
    protected String getResultPreviewLabel() {
        if (!this.updateLabelRequired) {
            return super.getResultPreviewLabel();
        }
        String msg = NLS.bind((String)REPLACE_TPL_PREVIEW_RESULT_PREVIEW, (Object)this.getResultTemplateName());
        return msg;
    }

    @Override
    protected String getResultPreviewName() {
        if (!this.updateLabelRequired) {
            return super.getResultPreviewName();
        }
        String msg = NLS.bind((String)REPLACE_TPL_PREVIEW_RESULT_PREVIEW_NAME, (Object)this.getResultTemplateName());
        return msg;
    }

    @Override
    protected String getSourcePreviewLabel() {
        if (!this.updateLabelRequired) {
            return super.getSourcePreviewLabel();
        }
        String msg = NLS.bind((String)REPLACE_TPL_PREVIEW_SOURCE_PREVIEW, (Object)this.getCurrentTemplateName());
        return msg;
    }

    @Override
    protected String getSourcePreviewName() {
        if (!this.updateLabelRequired) {
            return super.getSourcePreviewName();
        }
        String msg = NLS.bind((String)REPLACE_TPL_PREVIEW_SOURCE_PREVIEW_NAME, (Object)this.getCurrentTemplateName());
        return msg;
    }

    private String getCurrentTemplateName() {
        ITestPreviewDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return "";
        }
        IReplaceTemplateComposeInfo info = (IReplaceTemplateComposeInfo)this.getWiz();
        return ApplyTplUtil.getTemplateLabelOfInstance(info.getSourceFileModel());
    }

    private String getResultTemplateName() {
        ITestPreviewDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return "";
        }
        return new TilesDefinitionImageItemProvider().getText(dataModel.getTemplate());
    }

    private class MyUpdatePreview
    extends AbstractTPLPreviewListWithTest.MyPrev {
        private MyUpdatePreview() {
            super(AbstractReplaceTPLPreviewList.this);
        }

        @Override
        void doUpdatePreview() throws AbstractTPLPreviewListWithTest.MyException {
            IDOMModel sourceModel = null;
            Object resultModel = null;
            try {
                sourceModel = SelectRegionsUtil.getModelForRead(this.sourceFile);
                if (sourceModel == null) {
                    throw new AbstractTPLPreviewListWithTest.MyException(AbstractReplaceTPLPreviewList.this, false, false);
                }
                if (this.doUpdateSource) {
                    AbstractReplaceTPLPreviewList.this.getPrevSource().setModel(sourceModel);
                }
                if (this.doReplaceTemplate) {
                    AbstractReplaceTPLPreviewList.this.getPrevResult().setModel(AbstractReplaceTPLPreviewList.this.getDataModel().getPreviewModel(sourceModel));
                }
            }
            finally {
                if (sourceModel != null) {
                    sourceModel.releaseFromRead();
                    sourceModel = null;
                }
                if (resultModel != null) {
                    resultModel.releaseFromEdit();
                    resultModel = null;
                }
            }
        }
    }
}

