/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.testpreview;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.pages.composer.IApplyTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgComposer;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.AbstractApplyTPLPreview;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardIconUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractApplyTPLPreviewList
extends AbstractApplyTPLPreview {
    protected CheckboxTableViewer listViewer;

    @Override
    protected Control createSelectPane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(this.selectPaneLabel);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.listViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.listViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractApplyTPLPreviewList.this.listViewer.getLabelProvider().dispose();
            }
        });
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                AbstractApplyTPLPreviewList.this.fireCheckPressed(e);
                AbstractApplyTPLPreviewList.this.fireUpdateFrag(e);
            }
        });
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                boolean doApply;
                Object selectedObj = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (selectedObj == null) {
                    AbstractApplyTPLPreviewList.this.fireSelectionChanged(null, false, false);
                    return;
                }
                IFile file = null;
                if (selectedObj instanceof FileModelProxy) {
                    file = ((FileModelProxy)selectedObj).getFile();
                }
                AbstractApplyTPLPreviewList.this.doApplyTest(file);
                boolean checkState = AbstractApplyTPLPreviewList.this.listViewer.getChecked(selectedObj);
                boolean bl = doApply = !AbstractApplyTPLPreviewList.this.listViewer.getGrayed(selectedObj) && checkState;
                if (selectedObj.equals(AbstractApplyTPLPreviewList.this.selectedObjCache)) {
                    if (checkState == AbstractApplyTPLPreviewList.this.checkStateCache) {
                        return;
                    }
                    if (AbstractApplyTPLPreviewList.this.getDisplayedSourceFile() != null && AbstractApplyTPLPreviewList.this.getDisplayedSourceFile().equals((Object)file)) {
                        AbstractApplyTPLPreviewList.this.fireSelectionChanged(file, doApply, false);
                    } else {
                        AbstractApplyTPLPreviewList.this.fireSelectionChanged(file, doApply, true);
                    }
                } else {
                    AbstractApplyTPLPreviewList.this.fireSelectionChanged(file, doApply, true);
                }
                AbstractApplyTPLPreviewList.this.showApplyErrorMsg(selectedObj, file);
                AbstractApplyTPLPreviewList.this.selectedObjCache = selectedObj;
                AbstractApplyTPLPreviewList.this.checkStateCache = checkState;
            }
        });
        return composite;
    }

    public void setVisible(boolean visible) {
        if (visible && this.listViewer != null && this.listViewer.getControl() != null && !this.listViewer.getControl().isDisposed() && !this.listViewer.getSelection().isEmpty()) {
            this.fireSelectionChanged(null, false, false);
            this.selectedObjCache = null;
            this.listViewer.setSelection(this.listViewer.getSelection(), true);
        }
    }

    @Override
    protected void setMessageToPage(int state, String msg, Object selectedObj) {
        if (state == 3) {
            msg = NLS.bind((String)IMsgReplaceTemplateErrorInfo.MSG_CANNOT_APPLY, (Object)msg);
            this.listViewer.setChecked(selectedObj, false);
            this.listViewer.setGrayed(selectedObj, true);
            this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, selectedObj, false));
        } else if (state == 2) {
            this.listViewer.setGrayed(selectedObj, false);
        } else if (state == 1) {
            msg = NLS.bind((String)IMsgReplaceTemplateErrorInfo.MSG_CANNOT_APPLY, (Object)msg);
            this.listViewer.setChecked(selectedObj, false);
            this.listViewer.setGrayed(selectedObj, true);
            this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, selectedObj, false));
        } else {
            this.listViewer.setGrayed(selectedObj, false);
        }
        this.setValidateMessage(state, msg);
        this.listViewer.refresh(selectedObj);
    }

    public void initializeViewer(FileModelProxy[] inputItems) {
        List<FileModelProxy> items = Arrays.asList(inputItems);
        this.listViewer.setInput(items);
        Iterator<FileModelProxy> it = items.iterator();
        IPath templatePath = this.getDataModel().getTemplateLocation();
        if (templatePath != null) {
            if (TemplateURLFixup.isSample(templatePath)) {
                IDOMModel masterModel;
                IApplyTplComposeInfo wizInfo = (IApplyTplComposeInfo)this.getWiz();
                if (wizInfo != null && (masterModel = wizInfo.getSourceFileModel()) != null) {
                    this.getDataModel().setMasterEncoding(WizardFileUtil.getIANAEncoding((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)masterModel))));
                }
            } else {
                this.getDataModel().setMasterEncoding(WizardFileUtil.getIANAEncoding(templatePath));
            }
        }
        while (it.hasNext()) {
            FileModelProxy proxy = it.next();
            IFile file = proxy.getFile();
            if (ApplyTplUtil.hasTemplate(file)) {
                this.listViewer.setGrayed((Object)proxy, true);
                this.listViewer.setChecked((Object)proxy, false);
            } else {
                this.listViewer.setChecked((Object)proxy, true);
            }
            this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, (Object)proxy, this.listViewer.getChecked((Object)proxy)));
        }
        this.listViewer.setSelection(this.listViewer.getSelection(), true);
    }

    @Override
    protected void fireSelectAllButtonPressed() {
        int itemCount = this.listViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            Object obj = this.listViewer.getElementAt(i);
            if (!this.listViewer.getGrayed(obj)) {
                this.listViewer.setChecked(obj, true);
                this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, true));
                this.listViewer.setSelection(this.listViewer.getSelection());
            }
            ++i;
        }
    }

    @Override
    protected void fireDeselectAllButtonPressed() {
        int itemCount = this.listViewer.getTable().getItemCount();
        int i = 0;
        while (i < itemCount) {
            Object obj = this.listViewer.getElementAt(i);
            if (!this.listViewer.getGrayed(obj)) {
                this.listViewer.setChecked(obj, false);
                this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, false));
                this.listViewer.setSelection(this.listViewer.getSelection());
            }
            ++i;
        }
    }

    @Override
    public void doApplyTestToAll(IProgressMonitor monitor) throws InterruptedException {
        if (this.listViewer == null) {
            return;
        }
        List items = (List)this.listViewer.getInput();
        if (items == null) {
            return;
        }
        try {
            monitor.beginTask(IMsgComposer.PROGRESS_PROCESSING, items.size());
            Iterator it = items.iterator();
            while (it.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                Object obj = it.next();
                if (obj instanceof FileModelProxy) {
                    FileModelProxy proxy = (FileModelProxy)obj;
                    monitor.subTask(proxy.getSrc());
                    IFile file = proxy.getFile();
                    this.doApplyTest(file);
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refleshViewer() {
        this.listViewer.refresh();
        int counter = 0;
        try {
            List items = (List)this.listViewer.getInput();
            if (items == null) {
                return;
            }
            if (this.applyErrorList == null) {
                return;
            }
            for (Object obj : items) {
                ITemplateErrorInfo errorInfo;
                IFile file;
                if (!(obj instanceof FileModelProxy) || (file = ((FileModelProxy)obj).getFile()) == null || (errorInfo = (ITemplateErrorInfo)this.applyErrorList.get(file)) == null) continue;
                if (errorInfo.isFileTemplateError()) {
                    this.listViewer.setGrayed(obj, true);
                    this.listViewer.setChecked(obj, false);
                    this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, false));
                    continue;
                }
                if (errorInfo.hasSomeError()) {
                    this.listViewer.setGrayed(obj, true);
                    this.listViewer.setChecked(obj, false);
                    this.fireUpdateFrag(new CheckStateChangedEvent((ICheckable)this.listViewer, obj, false));
                    ++counter;
                    continue;
                }
                this.listViewer.setGrayed(obj, false);
            }
            return;
        }
        finally {
            this.setErrorNumber(counter);
        }
    }

    @Override
    protected void fireCheckPressed(CheckStateChangedEvent e) {
        Object obj = e.getElement();
        if (this.listViewer.getGrayed(obj)) {
            this.listViewer.setChecked(obj, false);
        }
    }

    @Override
    protected void fireUpdateFrag(CheckStateChangedEvent e) {
        Object obj = e.getElement();
        boolean bln = true;
        if (this.listViewer.getGrayed(obj) || !this.listViewer.getChecked(obj)) {
            bln = false;
        }
        if (obj instanceof FileModelProxy) {
            FileModelProxy proxy = (FileModelProxy)obj;
            proxy.setApplyTemplateFlag(bln);
        }
    }

    protected class MyLabelProvider
    extends LabelProvider {
        private final WizardIconUtil iconUtil = new WizardIconUtil();

        protected MyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof FileModelProxy) {
                FileModelProxy proxy = (FileModelProxy)element;
                String title = proxy.getTitle();
                String path = proxy.getSrc();
                return String.valueOf(title) + "(" + path + ")";
            }
            return "";
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof FileModelProxy) {
                ITemplateErrorInfo errorInfo;
                FileModelProxy proxy = (FileModelProxy)element;
                image = proxy.isRealized() ? this.iconUtil.getRealizeIcon() : this.iconUtil.getUnRealizeIcon();
                IFile file = proxy.getFile();
                if (file != null && AbstractApplyTPLPreviewList.this.applyErrorList != null && (errorInfo = (ITemplateErrorInfo)AbstractApplyTPLPreviewList.this.applyErrorList.get(file)) != null && !errorInfo.isFileTemplateError()) {
                    if (errorInfo.hasSomeError()) {
                        image = JFaceResources.getImage((String)"dialog_message_error_image");
                    } else if (errorInfo.hasSomeWarning()) {
                        image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    }
                }
            }
            return image;
        }

        public void dispose() {
            if (this.iconUtil != null) {
                this.iconUtil.dispose();
            }
        }
    }
}

