/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.selectmaster;

import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgCommonParts;
import com.ibm.etools.webpage.template.wizards.pages.selectmaster.FileSelectionWidget;
import com.ibm.etools.webpage.template.wizards.selecttpl.ModelPreviewWidget;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractSelectMasterSourceWidget
implements IMsgCommonParts {
    private ModelPreviewWidget preview;
    private int SIZING_DESCRIPTION_TEXT = 300;
    private int SIZING_PREVIEW_WIDTH = 300;
    private int SIZING_PREVIEW_HEIGHT = 300;
    protected IVirtualComponent component;
    protected FileSelectionWidget selectFileArea;
    private MyUpdatePreview runnable;

    public AbstractSelectMasterSourceWidget(IVirtualComponent component) {
        this.component = component;
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gdComposite = new GridData(1808);
        composite.setLayoutData((Object)gdComposite);
        this.createDescriptionArea(composite);
        this.createSelectFileArea(composite);
        this.createPreviewArea(composite);
    }

    private void createDescriptionArea(Composite parent) {
        Text descriptionText = new Text(parent, 74);
        GridData gdDescription = new GridData(768);
        gdDescription.widthHint = this.SIZING_DESCRIPTION_TEXT;
        descriptionText.setLayoutData((Object)gdDescription);
        descriptionText.setText(this.getDescriptionMessage());
        descriptionText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = AbstractSelectMasterSourceWidget.this.getDescriptionMessage();
                }
            }
        });
    }

    protected abstract String getDescriptionMessage();

    protected void createSelectFileArea(Composite parent) {
        this.selectFileArea = new FileSelectionWidget();
        this.selectFileArea.initWidget("", this.component);
        this.selectFileArea.createControls(parent);
        this.selectFileArea.getFileSelectionText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSelectMasterSourceWidget.this.fireSelectionChanged(AbstractSelectMasterSourceWidget.this.selectFileArea.getSelectedObj());
            }
        });
    }

    private void createPreviewArea(Composite parent) {
        String previewLabel = APPLY_TPL_PREVIEW_LABEL;
        String previewName = APPLY_TPL_PREVIEW_LABEL_NAME;
        String previewShortCut = APPLY_TPL_PREVIEW_LABEL_SHORTCUT;
        this.preview = new ModelPreviewWidget(previewLabel, previewName, previewShortCut);
        this.preview.createControls(parent, this.SIZING_PREVIEW_WIDTH, this.SIZING_PREVIEW_HEIGHT, 32);
    }

    public final void setPreviewModel(IDOMModel model) {
        if (this.runnable != null) {
            this.runnable.kill();
            this.runnable = null;
        }
        if (this.preview != null) {
            this.runnable = new MyUpdatePreview(this.preview, model);
        }
    }

    public void disposeThumbnail() {
        if (this.preview != null) {
            this.preview.disposeThumbnail();
        }
    }

    public abstract void setDefaultSelection(TemplateWizardDataModel var1);

    protected abstract void fireSelectionChanged(Object var1);

    private class MyUpdatePreview
    implements Runnable {
        private IDOMModel model;
        private final int delayMSec = 100;
        private boolean killFlag;
        private ModelPreviewWidget widget;

        public void kill() {
            this.killFlag = true;
        }

        public MyUpdatePreview(ModelPreviewWidget widget, IDOMModel model) {
            this.widget = widget;
            this.model = model;
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                dsp.timerExec(100, (Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.killFlag) {
                return;
            }
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                BusyIndicator.showWhile((Display)dsp, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MyUpdatePreview.this.doUpdate();
                    }
                });
            }
        }

        void doUpdate() {
            this.widget.setModel(this.model);
        }
    }
}

