/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.selectmaster;

import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import com.ibm.etools.webpage.template.wizards.pages.selectmaster.AbstractSelectMasterSourceWidget;
import com.ibm.etools.webpage.template.wizards.pages.selectmaster.PageModelProxySelectionWidget;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class AbstractSelectMasterSourceFromComboWidget
extends AbstractSelectMasterSourceWidget {
    private List fileModelProxies;

    public AbstractSelectMasterSourceFromComboWidget(IVirtualComponent component, FileModelProxy[] selectedFiles) {
        super(component);
        this.fileModelProxies = Arrays.asList(selectedFiles);
    }

    @Override
    protected void createSelectFileArea(Composite parent) {
        this.selectFileArea = new PageModelProxySelectionWidget();
        this.selectFileArea.initWidget(SELECT_SOURCE_SELECT_LABEL, this.component);
        this.selectFileArea.createControls(parent);
        FileModelProxy[] items = this.fileModelProxies.toArray(new FileModelProxy[this.fileModelProxies.size()]);
        ((PageModelProxySelectionWidget)this.selectFileArea).setComboItems(items);
        ((PageModelProxySelectionWidget)this.selectFileArea).getFileSelectionCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSelectMasterSourceFromComboWidget.this.fireComboSelection();
            }
        });
    }

    protected void fireComboSelection() {
        Combo source = ((PageModelProxySelectionWidget)this.selectFileArea).getFileSelectionCombo();
        int selectedIndex = source.getSelectionIndex();
        if (selectedIndex < 0) {
            return;
        }
        Object selectedObj = source.getData(source.getItem(selectedIndex));
        this.selectFileArea.setSelectedObj(selectedObj);
        this.fireSelectionChanged(selectedObj);
    }

    @Override
    public void setDefaultSelection(TemplateWizardDataModel tplProxy) {
        if (tplProxy == null) {
            return;
        }
        IPath tplPath = tplProxy.getTemplateLocation();
        if (tplPath == null) {
            return;
        }
        Combo combo = ((PageModelProxySelectionWidget)this.selectFileArea).getFileSelectionCombo();
        if (combo == null || combo.isDisposed()) {
            return;
        }
        int comboSelectionIndex = combo.getSelectionIndex();
        if (comboSelectionIndex < 0 || this.selectFileArea.getSelectedObj() == null) {
            String[] items = combo.getItems();
            if (items == null) {
                return;
            }
            IDOMModel templateModel = null;
            try {
                templateModel = SelectRegionsUtil.getModelForRead(tplPath);
                if (templateModel == null) {
                    return;
                }
                int i = 0;
                while (i < items.length) {
                    Object obj = combo.getData(items[i]);
                    if (obj instanceof IFile && this.canSelectFile((IFile)obj, tplProxy, templateModel, tplPath)) {
                        combo.select(i);
                        this.fireComboSelection();
                        break;
                    }
                    ++i;
                }
            }
            finally {
                if (templateModel != null) {
                    templateModel.releaseFromRead();
                    templateModel = null;
                }
            }
        }
    }

    public void setSelection(IFile file) {
        Combo combo = ((PageModelProxySelectionWidget)this.selectFileArea).getFileSelectionCombo();
        if (combo == null || combo.isDisposed()) {
            return;
        }
        int comboSelectionIndex = combo.getSelectionIndex();
        if (comboSelectionIndex < 0 || this.selectFileArea.getSelectedObj() == null) {
            String[] items = combo.getItems();
            if (items == null) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                Object obj = combo.getData(items[i]);
                if (obj instanceof IFile && obj.equals(file)) {
                    combo.select(i);
                    this.fireComboSelection();
                    break;
                }
                ++i;
            }
        }
    }

    protected abstract boolean canSelectFile(IFile var1, TemplateWizardDataModel var2, IDOMModel var3, IPath var4);
}

