/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.operations;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.commands.ReplaceTemplateCommand;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.ErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.newfile.instance.GenericUtil;
import com.ibm.etools.webpage.template.wizards.pages.operations.AbstractReplaceTemplateToMuliPageOperation;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class StaticReplaceTemplateToMultipageOperation
extends AbstractReplaceTemplateToMuliPageOperation {
    public StaticReplaceTemplateToMultipageOperation(ContentMappingTemplateDataModel dataModel) {
        super(dataModel);
    }

    @Override
    public void doConfigComponent(IVirtualComponent component, IProgressMonitor monitor) throws CoreException {
        TemplatePlugin.getDefault().addTemplateFacetAndNature(component.getProject(), monitor);
    }

    @Override
    protected HTMLCommand generateCommand(HTMLCommandTarget commandTarget, Map map, IPath newTemplateFile) {
        ReplaceTemplateCommand command = new ReplaceTemplateCommand();
        command.setNewTemplateFileURL(new FileURL(newTemplateFile));
        command.setContentsMap(map);
        command.setCommandTarget(commandTarget);
        List commandsForReplace = GenericUtil.createCommandsForReplace((HTMLCommand)command, newTemplateFile, commandTarget.getActiveModel());
        CompoundHTMLCommand compCommand = new CompoundHTMLCommand(command.getLabel(), commandsForReplace);
        compCommand.setCommandTarget(commandTarget);
        return compCommand;
    }

    @Override
    protected Object fixupTemplate(IVirtualComponent component, Object template, String ianaEncoding, Shell shell) {
        if ("".equals(ianaEncoding)) {
            ianaEncoding = null;
        }
        return TemplateURLFixup.performLinkFixup(component, (IPath)template, ianaEncoding, shell);
    }

    @Override
    protected ITemplateErrorInfo canChange(IDOMModel targetFileModel, IDOMModel templateFileModel, Map specifiedMapping) {
        TemplateModelSession session;
        TemplateModel instanceTPL;
        List putNodeList;
        ErrorInfo ret = new ErrorInfo();
        if (targetFileModel == null || templateFileModel == null) {
            ret.setUnexpactedError(true);
            return ret;
        }
        ret.setSyntaxError(!ApplyTplUtil.checkJSPSyntax(targetFileModel, templateFileModel));
        ret.setEncodingError(!ApplyTplUtil.checkEncoding(targetFileModel, templateFileModel));
        if (specifiedMapping == null) {
            ret.setUnexpactedError(true);
        }
        if ((putNodeList = TemplateTypeUtil.collectPutNode((TemplateModel)(instanceTPL = (session = new TemplateModelSession()).getTemplateModel((IStructuredModel)targetFileModel)))) == null) {
            ret.setMappingError(true);
        } else {
            ArrayList<String> contentAreasList = new ArrayList<String>(0);
            for (TplPut putNode : putNodeList) {
                String key = putNode.getName();
                if (key == null) continue;
                contentAreasList.add(key);
            }
            if (contentAreasList != null && specifiedMapping != null) {
                Set keyset = specifiedMapping.keySet();
                if (keyset == null) {
                    ret.setMappingError(true);
                } else if (!contentAreasList.containsAll(keyset)) {
                    ret.setMappingError(true);
                }
            }
        }
        return ret;
    }
}

