/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.operations;

import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistry;
import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.TemplateWizardsPlugin;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.TemplateCommandExtensionContext;
import com.ibm.etools.webpage.template.wizards.model.TemplateForCommands;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgComposer;
import com.ibm.etools.webpage.template.wizards.pages.operations.IReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public abstract class AbstractReplaceTemplateToMuliPageOperation
implements IReplaceTemplateToMultiPageOperation,
IMsgComposer {
    private List errors;
    private ContentMappingTemplateDataModel dataModel;

    public AbstractReplaceTemplateToMuliPageOperation(ContentMappingTemplateDataModel dataModel) {
        this.dataModel = dataModel;
    }

    protected ContentMappingTemplateDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void doReplaceTemplate(IVirtualComponent component, Map contentIdMap, FileModelProxy[] targetFilesProxy, Shell shell, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(PREGRESS_STATE_PREPARING_TEMPLATE);
        IPath path = this.dataModel.getTemplateLocation();
        String ianaEncoding = null;
        if (TemplateURLFixup.isSample(path)) {
            IDOMModel model = this.dataModel.getSourceModel();
            if (model != null) {
                ianaEncoding = SelectRegionsUtil.getIANAEncoding(model);
            }
        } else {
            ianaEncoding = WizardFileUtil.getEncoding(path);
        }
        Object fixuppedTemplate = this.fixupTemplate(component, this.dataModel.getTemplate(), ianaEncoding, shell);
        this.dataModel.setFixuppedTemplate(fixuppedTemplate);
        if (this.dataModel.getFixuppedTemplate() == null) {
            return;
        }
        monitor.worked(1000);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1000);
        try {
            IPath location = SelectRegionsUtil.getTemplateLocation(this.dataModel.getFixuppedTemplate());
            this.processChangeTemplate(location, targetFilesProxy, contentIdMap, subMonitor);
        }
        finally {
            subMonitor.done();
        }
    }

    protected abstract Object fixupTemplate(IVirtualComponent var1, Object var2, String var3, Shell var4);

    @Override
    public List getErrorFileList() {
        return this.errors;
    }

    private void processChangeTemplate(IPath newTemplatePath, FileModelProxy[] targetFilesProxy, Map contentIdMap, SubProgressMonitor monitor) throws CoreException {
        if (targetFilesProxy == null) {
            return;
        }
        ArrayList<IFile> errorFilesList = new ArrayList<IFile>(0);
        monitor.beginTask("", targetFilesProxy.length);
        IDOMModel templateModel = null;
        IDOMModel instanceModel = null;
        try {
            if (newTemplatePath == null) {
                throw new CoreException((IStatus)new Status(4, TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), 4, IMsgReplaceTemplateErrorInfo.MSG_UNEXPECTED_ERROR, null));
            }
            templateModel = SelectRegionsUtil.getModelForRead(newTemplatePath);
            if (templateModel == null) {
                throw new CoreException((IStatus)new Status(4, TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), 4, IMsgReplaceTemplateErrorInfo.MSG_UNEXPECTED_ERROR, null));
            }
            int i = 0;
            while (i < targetFilesProxy.length) {
                FileModelProxy proxy = targetFilesProxy[i];
                if (!proxy.isApplyTemplateFlag()) {
                    monitor.worked(1);
                } else {
                    IFile file = proxy.getFile();
                    if (file != null && file.exists()) {
                        try {
                            monitor.subTask(file.getProjectRelativePath().toString());
                            instanceModel = SelectRegionsUtil.getModelForEdit(file);
                            ITemplateErrorInfo errorInfo = this.canChange(instanceModel, templateModel, contentIdMap);
                            if (errorInfo.hasSomeError()) {
                                errorFilesList.add(file);
                                monitor.worked(1);
                            } else {
                                this.doReplaceCommand(instanceModel, contentIdMap, newTemplatePath, (IProgressMonitor)monitor);
                                monitor.worked(1);
                            }
                        }
                        finally {
                            if (instanceModel != null) {
                                if (!instanceModel.isSharedForEdit() && file != null) {
                                    SelectRegionsUtil.saveModel(instanceModel, file);
                                    file = null;
                                }
                                instanceModel.releaseFromEdit();
                                instanceModel = null;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (templateModel != null) {
                templateModel.releaseFromRead();
                templateModel = null;
            }
        }
        this.errors = errorFilesList;
        monitor.done();
    }

    protected abstract ITemplateErrorInfo canChange(IDOMModel var1, IDOMModel var2, Map var3);

    protected abstract HTMLCommand generateCommand(HTMLCommandTarget var1, Map var2, IPath var3);

    protected void doReplaceCommand(IDOMModel model, Map map, IPath newTemplateFile, IProgressMonitor monitor) {
        HTMLCommand command;
        HTMLEditDomainCommandProxy commandTarget = new HTMLEditDomainCommandProxy(model);
        Range range = ((DocumentRange)model.getDocument()).createRange();
        range.setStart((Node)model.getDocument(), 0);
        range.collapse(true);
        commandTarget.getSelectionMediator().setRange(range);
        Map newMap = this.preReplaceTemplate((HTMLCommandTarget)commandTarget, map, monitor);
        HTMLCommand baseCommand = command = this.generateCommand((HTMLCommandTarget)commandTarget, newMap, newTemplateFile);
        while (baseCommand instanceof CompoundHTMLCommand) {
            baseCommand = (HTMLCommand)((CompoundHTMLCommand)baseCommand).getCommandList().get(0);
        }
        command = OverrideActionRegistry.generateExtendedCommand((HTMLCommand)command, (CommandExtensionContext)new TemplateCommandExtensionContext((HTMLCommandTarget)commandTarget, baseCommand, new TemplateForCommands(this.getDataModel().getFixuppedTemplate()), "pagetemplate.replacetemplate"), (String)"pagetemplate.replacetemplate");
        command.setCommandTarget((HTMLCommandTarget)commandTarget);
        command.execute();
    }

    protected Map preReplaceTemplate(HTMLCommandTarget target, Map map, IProgressMonitor monitor) {
        return map;
    }
}

