/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.composer;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.TemplateWizardsPlugin;
import com.ibm.etools.webpage.template.wizards.pages.composer.IReplaceTemplateComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgComposer;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgWizPageCommon;
import com.ibm.etools.webpage.template.wizards.pages.operations.IReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateLastSelectionUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ReplaceTemplateComposer
extends WorkspaceModifyOperation
implements IMsgComposer,
IMsgWizPageCommon,
IMsgReplaceTemplateErrorInfo {
    private IReplaceTemplateComposeInfo info;

    public ReplaceTemplateComposer(IReplaceTemplateComposeInfo info) {
        this.info = info;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException {
        if (this.info == null || this.info.getContentMappingTemplateDataModel() == null) {
            throw new CoreException((IStatus)new Status(4, TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), 4, IMsgReplaceTemplateErrorInfo.MSG_UNEXPECTED_ERROR, null));
        }
        try {
            monitor.beginTask(PROGRESS_STATE_REPLACE_TEMPLATE, 2000);
            IReplaceTemplateToMultiPageOperation operation = this.info.getContentMappingTemplateDataModel().getMultiPageOperation();
            operation.doConfigComponent(this.info.getComponent(), monitor);
            operation.doReplaceTemplate(this.info.getComponent(), this.info.getContentMappingTemplateDataModel().getMappingData(), this.info.getTargetFilesProxy(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), monitor);
            IFile tplFile = SelectRegionsUtil.getTemplateFile(this.info.getComponent(), this.info.getTemplateDataModel().getFixuppedTemplate());
            if (FileTypeHandler.getFileType((IFile)tplFile).equalsIgnoreCase("htpl")) {
                TemplateLastSelectionUtil.setLastSelection(tplFile, "htpl");
                TemplateLastSelectionUtil.setLastSelection(tplFile, "jtpl");
            } else if (FileTypeHandler.getFileType((IFile)tplFile).equalsIgnoreCase("jtpl")) {
                TemplateLastSelectionUtil.setLastSelection(tplFile, "jtpl");
            }
        }
        finally {
            monitor.done();
        }
    }
}

