/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.applytpl;

import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.internal.wizards.ApplyTemplateValidationFacade;
import com.ibm.etools.webpage.template.internal.wizards.WizardMessageHolder;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.pages.applytpl.WizPageApplyTPLSelectSource;
import com.ibm.etools.webpage.template.wizards.pages.composer.IApplyTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgWizPageCommon;
import com.ibm.etools.webpage.template.wizards.selecttpl.AbstractTemplateSelectionWidget;
import com.ibm.etools.webpage.template.wizards.tiles.TilesTemplateLastSelectionUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateLastSelectionUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardsInfopopIDConstant;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WizPageApplyTPLSelectPT
extends WizardPage
implements IMsgWizPageCommon {
    private IApplyTplComposeInfo wizard;
    private IVirtualComponent component;
    protected AbstractTemplateSelectionWidget selectPT;
    private boolean initSelect = false;
    private Object templateCache = null;

    public WizPageApplyTPLSelectPT() {
        super(COMMON_SELECT_PT_TITLE);
        this.setTitle(COMMON_SELECT_PT_TITLE);
        this.setDescription(SELECT_PT_WIZ_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        Object tilesSelection;
        Object selection;
        this.wizard = (IApplyTplComposeInfo)this.getWizard();
        this.component = this.wizard.getComponent();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gData = new GridData(1296);
        composite.setLayoutData((Object)gData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, WizardsInfopopIDConstant.SELECT_TPL_ID);
        boolean wizType = this.isHTPLOnly(this.wizard.getTargetFilesProxy()) || this.isStaticComponent(this.component);
        this.selectPT = new AbstractTemplateSelectionWidget(this.getShell(), this.component, wizType){

            @Override
            protected void templateSelected(Object selection) {
                WizPageApplyTPLSelectPT.this.setTemplate(selection);
            }
        };
        this.selectPT.createControls(composite);
        this.selectPT.setAutoSelection(true);
        String wizardType = wizType ? "htpl" : "jtpl";
        IFile initialTpl = TemplateLastSelectionUtil.getLastSelection(this.component, wizardType);
        IPath iPath = selection = initialTpl == null ? null : initialTpl.getLocation();
        if (!wizType && (tilesSelection = TilesTemplateLastSelectionUtil.getLastSelection(this.wizard.getComponent())) != null) {
            selection = tilesSelection;
        }
        this.selectPT.setAndValidateInitialSelection(selection);
        this.setControl((Control)composite);
    }

    protected void setTemplate(Object template) {
        if (template == null) {
            this.setPageComplete(false);
            if (this.initSelect) {
                this.setMessage(SELECT_PT_EMPTY_MSG, 3);
            }
            this.initSelect = true;
            return;
        }
        if (this.wizard != null) {
            if (!template.equals(this.templateCache)) {
                this.templateCache = template;
                this.wizard.setTemplate(template);
            }
            this.setMessage(null, 0);
            this.setPageComplete(true);
        }
        this.validatePage();
    }

    private WizardMessageHolder getValidateResult() {
        WizardMessageHolder result = new WizardMessageHolder();
        if (this.wizard == null) {
            result.setMessage(SELECT_PT_EMPTY_MSG, 3);
        } else if (this.wizard.getTemplateDataModel() == null || this.wizard.getTemplateDataModel().getTemplate() == null) {
            result.updateMessage(SELECT_PT_EMPTY_MSG, 3);
        } else if (this.getNextPage() instanceof WizPageApplyTPLSelectSource) {
            result.updateMessage(ApplyTemplateValidationFacade.getInstance().validateForApply(this.wizard.getTemplateDataModel().getTemplate(), this.component));
        } else {
            result.updateMessage(ApplyTemplateValidationFacade.getInstance().validateForApply(this.wizard.getTemplateDataModel().getTemplate(), this.wizard.getSourceFileModel()));
        }
        return result;
    }

    private void validatePage() {
        WizardMessageHolder result = this.getValidateResult();
        if (result.getMessage() == WizardMessageHolder.MISSING_TEMPLATE) {
            result.setMessage(SELECT_PT_EMPTY_MSG, 3);
        }
        this.setMessage(result.getMessage(), result.getMessageType());
        this.setPageComplete(result.getMessageType() < 3);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            WizardMessageHolder result;
            if (!this.isPageComplete() && (result = this.getValidateResult()) != null && result.getMessage() != WizardMessageHolder.MISSING_TEMPLATE) {
                this.selectPT.setInitialTemplateFile(null);
            }
            this.setMessage(null);
        }
        super.setVisible(visible);
    }

    protected boolean isHTPLOnly(FileModelProxy[] pageModelProxyArray) {
        for (FileModelProxy proxy : Arrays.asList(pageModelProxyArray)) {
            String type;
            String src = proxy.getSrc();
            if (src == null || !"html".equals(type = FileTypeHandler.getFileType((String)src)) && !"htpl".equals(type)) continue;
            return true;
        }
        return false;
    }

    protected boolean isStaticComponent(IVirtualComponent vc) {
        if (vc == null) {
            return false;
        }
        WebComponent wc = new WebComponent(vc);
        try {
            boolean bl = wc.getWebApp() == null;
            return bl;
        }
        finally {
            wc.dispose();
        }
    }
}

