/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.pages.applytpl;

import com.ibm.etools.webedit.common.utils.ValidateEditUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.dialog.TableMessageDialog;
import com.ibm.etools.webpage.template.selection.core.TilesDefinitionElement;
import com.ibm.etools.webpage.template.wizards.model.ApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.StaticApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import com.ibm.etools.webpage.template.wizards.pages.applytpl.WizPageApplyTPLContentMapping;
import com.ibm.etools.webpage.template.wizards.pages.applytpl.WizPageApplyTPLSelectPT;
import com.ibm.etools.webpage.template.wizards.pages.applytpl.WizPageApplyTPLSelectSource;
import com.ibm.etools.webpage.template.wizards.pages.applytpl.WizPageApplyTPLTest;
import com.ibm.etools.webpage.template.wizards.pages.composer.ApplyTplComposer;
import com.ibm.etools.webpage.template.wizards.pages.composer.IApplyTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.composer.ISelectTplComposeInfo;
import com.ibm.etools.webpage.template.wizards.pages.msg.IMsgWizPageCommon;
import com.ibm.etools.webpage.template.wizards.pages.operations.AbstractApplyTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.selecttpl.TemplateFileManager;
import com.ibm.etools.webpage.template.wizards.tiles.ITilesPutMapInfo;
import com.ibm.etools.webpage.template.wizards.tiles.SpecifyContentFileNamePage;
import com.ibm.etools.webpage.template.wizards.tiles.TilesApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardIconUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardsImageDescriptorUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ApplyTplWizard
extends Wizard
implements IApplyTplComposeInfo,
IMsgWizPageCommon {
    private WizPageApplyTPLSelectPT pageSelectPT;
    private WizPageApplyTPLSelectSource pageSelectSource;
    private WizPageApplyTPLContentMapping pageContentMapping;
    private WizPageApplyTPLTest pageApplyTest;
    private SpecifyContentFileNamePage specifyContentFileNamePage;
    private IVirtualComponent component;
    protected FileModelProxy[] targetFilesProxyArray;
    protected FileModelProxy[] invalidFilesProxyArray;
    protected boolean hasRealizedPage = false;
    private ApplyTemplateDataModel dataModel = null;
    private List applyErrorFiles;
    private IDOMModel selectedSourceFileModel = null;

    public ApplyTplWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WINDOW_TITLE_APPLY_TEMPLATE);
        ImageDescriptor desc = WizardsImageDescriptorUtil.createWizbanImageDescriptor("apply_template_wizban.gif");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean init(IVirtualComponent component, IFile[] selectedFiles) {
        return this.init(component, FileModelProxy.createFileModelProxies(selectedFiles));
    }

    protected boolean init(IVirtualComponent component, FileModelProxy[] selectedFiles) {
        int i;
        this.component = component;
        ArrayList<FileModelProxy> validFilesList = new ArrayList<FileModelProxy>();
        ArrayList<FileModelProxy> invalidFilesList = new ArrayList<FileModelProxy>();
        if (selectedFiles != null) {
            i = 0;
            while (i < selectedFiles.length) {
                FileModelProxy proxy = selectedFiles[i];
                if (ApplyTplUtil.hasTemplate(proxy.getFile())) {
                    invalidFilesList.add(proxy);
                } else {
                    validFilesList.add(proxy);
                }
                ++i;
            }
        }
        this.targetFilesProxyArray = validFilesList.toArray(new FileModelProxy[validFilesList.size()]);
        this.invalidFilesProxyArray = invalidFilesList.toArray(new FileModelProxy[invalidFilesList.size()]);
        i = 0;
        while (i < this.targetFilesProxyArray.length) {
            if (this.targetFilesProxyArray[i].isRealized()) {
                this.hasRealizedPage = true;
                break;
            }
            ++i;
        }
        return this.openDialog();
    }

    protected final boolean openDialog() {
        if (this.targetFilesProxyArray.length < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)WINDOW_TITLE_APPLY_TEMPLATE, (String)ResourceHandler._UI_Apply_Tpl_Wizard_0);
            return false;
        }
        if (this.invalidFilesProxyArray.length > 0) {
            return this.openQuestionDialog();
        }
        return true;
    }

    private boolean openQuestionDialog() {
        final WizardIconUtil iconUtil = new WizardIconUtil();
        String dialogMsg = ResourceHandler._UI_Some_files_you_selected_already_have_a_page_template__You_cannot_apply_a_second_page_template_to_the_page__Do_you_apply_a_page_template_to_the_following_pages_which_do_not_have_a_page_template_among_the_files_you_selected__2;
        TableMessageDialog dialog = TableMessageDialog.getQuestionDialog(this.getShell(), WINDOW_TITLE_APPLY_TEMPLATE, dialogMsg, dialogMsg);
        dialog.create();
        dialog.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (iconUtil != null) {
                    iconUtil.dispose();
                }
            }
        });
        dialog.createColumn("", null, true, 0, 10, 0);
        int i = 0;
        while (i < this.targetFilesProxyArray.length) {
            FileModelProxy proxy = this.targetFilesProxyArray[i];
            TableItem tableItem = dialog.createNewTableItem();
            if (proxy.isRealized()) {
                tableItem.setImage(iconUtil.getRealizeIcon());
            } else {
                tableItem.setImage(iconUtil.getUnRealizeIcon());
            }
            String title = proxy.getTitle();
            String src = proxy.getSrc();
            tableItem.setText(String.valueOf(title) + " (" + src + ")");
            ++i;
        }
        dialog.getTable().setHeaderVisible(false);
        dialog.getTable().setLinesVisible(false);
        TableColumn[] columns = dialog.getTable().getColumns();
        if (columns != null) {
            int i2 = 0;
            while (i2 < columns.length) {
                TableColumn column = columns[i2];
                column.pack();
                ++i2;
            }
            int areaWidth = dialog.getTable().getClientArea().width;
            int i3 = 0;
            while (i3 < columns.length) {
                TableColumn column = columns[i3];
                if (column.getWidth() < areaWidth) {
                    column.setWidth(areaWidth);
                }
                ++i3;
            }
        }
        return dialog.open() == 0;
    }

    public void addPages() {
        boolean needSelectTPLPage = false;
        boolean needSelectMasterPage = false;
        boolean needContentMappingPage = false;
        boolean needApplyTestPage = false;
        boolean needSpecifyContentFileNamePage = false;
        if (this.dataModel == null) {
            needSelectTPLPage = true;
        }
        if (this.hasRealizedPage) {
            needSelectMasterPage = true;
            needContentMappingPage = true;
            needApplyTestPage = true;
            needSpecifyContentFileNamePage = true;
        }
        if (this.targetFilesProxyArray.length == 1) {
            needSelectMasterPage = false;
            needApplyTestPage = false;
            this.setSourceFileModel(this.targetFilesProxyArray[0].getFile());
            this.targetFilesProxyArray[0].setApplyTemplateFlag(true);
        }
        if (needSelectTPLPage) {
            this.pageSelectPT = new WizPageApplyTPLSelectPT();
            this.addPage((IWizardPage)this.pageSelectPT);
        }
        if (needSelectMasterPage) {
            this.pageSelectSource = new WizPageApplyTPLSelectSource();
            this.addPage((IWizardPage)this.pageSelectSource);
        }
        if (needContentMappingPage) {
            this.pageContentMapping = new WizPageApplyTPLContentMapping();
            this.addPage((IWizardPage)this.pageContentMapping);
        }
        if (needApplyTestPage) {
            this.pageApplyTest = new WizPageApplyTPLTest();
            this.addPage((IWizardPage)this.pageApplyTest);
        }
        if (needSpecifyContentFileNamePage) {
            this.specifyContentFileNamePage = new SpecifyContentFileNamePage(){

                @Override
                protected void initializePage() {
                    TemplateWizardDataModel dm = ((ISelectTplComposeInfo)this.getWizard()).getTemplateDataModel();
                    if (dm instanceof ITilesPutMapInfo) {
                        ITilesPutMapInfo tdm = (ITilesPutMapInfo)((Object)dm);
                        if (this.getWizard() instanceof ISelectTplComposeInfo) {
                            ISelectTplComposeInfo info = (ISelectTplComposeInfo)this.getWizard();
                            FileModelProxy[] proxy = info.getTargetFilesProxy();
                            ArrayList newFiles = new ArrayList();
                            int i = 0;
                            while (i < proxy.length) {
                                String id;
                                if (proxy[i].isRealized() && proxy[i].isApplyTemplateFlag() && tdm.getPutValues(id = ModelManagerUtil.calculateSSEModelId((IFile)proxy[i].getFile())) == null) {
                                    IDOMModel sourceModel = (IDOMModel)new ModelManagerUtil(null, null).getModelForRead(proxy[i].getFile());
                                    try {
                                        boolean[] exactMatch = new boolean[]{true};
                                        HashMap contentsMap = ((AbstractApplyTemplateToMultiPageOperation)((ApplyTemplateDataModel)dm).getMultiPageOperation()).getContentsMap(sourceModel, null, exactMatch);
                                        tdm.setDefaultPutValues(id, contentsMap, newFiles);
                                    }
                                    finally {
                                        if (sourceModel != null) {
                                            sourceModel.releaseFromRead();
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        this.setPutMap(tdm);
                    } else {
                        this.setPutMap(null);
                    }
                }
            };
            this.addPage((IWizardPage)this.specifyContentFileNamePage);
        }
    }

    public boolean performFinish() {
        if (!this.hasRealizedPage) {
            int i = 0;
            while (i < this.targetFilesProxyArray.length) {
                this.targetFilesProxyArray[i].setApplyTemplateFlag(true);
                ++i;
            }
        }
        FileModelProxy[] proxies = this.getTargetFilesProxy();
        ArrayList<IFile> filesList = new ArrayList<IFile>(0);
        if (proxies != null) {
            int i = 0;
            while (i < proxies.length) {
                IFile file;
                FileModelProxy proxy = proxies[i];
                if (proxy.isApplyTemplateFlag() && (file = proxy.getFile()) != null && file.exists()) {
                    filesList.add(file);
                }
                ++i;
            }
            IFile[] fileArray = filesList.toArray(new IFile[filesList.size()]);
            if (!ValidateEditUtil.handleValidateReadOnly((IFile[])fileArray)) {
                return true;
            }
        }
        ApplyTplComposer op = new ApplyTplComposer(this);
        this.disposeThumbnail();
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException exception) {
            Logger.log((Throwable)exception);
            return false;
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private void disposeThumbnail() {
        if (this.pageSelectSource != null) {
            this.pageSelectSource.disposeThumbnail();
        }
        if (this.pageContentMapping != null) {
            this.pageContentMapping.disposeThumbnail();
        }
        if (this.pageApplyTest != null) {
            this.pageApplyTest.disposeThumbnail();
        }
    }

    public void dispose() {
        TemplateFileManager templateFileManager;
        if (this.dataModel != null) {
            this.dataModel.releaseAllModel();
        }
        if (this.selectedSourceFileModel != null) {
            this.selectedSourceFileModel.releaseFromRead();
            this.selectedSourceFileModel = null;
        }
        if ((templateFileManager = this.getFileManager()) != null) {
            templateFileManager.initialize();
        }
        super.dispose();
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == null) {
            return false;
        }
        if (currentPage.getNextPage() != null) {
            return false;
        }
        return super.canFinish();
    }

    public TemplateFileManager getFileManager() {
        return TemplateFileManager.getInstance();
    }

    @Override
    public FileModelProxy[] getTargetFilesProxy() {
        return this.targetFilesProxyArray;
    }

    @Override
    public FileModelProxy[] getInvalidFilesProxy() {
        return this.invalidFilesProxyArray;
    }

    @Override
    public IVirtualComponent getComponent() {
        return this.component;
    }

    @Override
    public ApplyTemplateDataModel getApplyTemplateDataModel() {
        return this.dataModel;
    }

    @Override
    public TemplateWizardDataModel getTemplateDataModel() {
        return this.dataModel;
    }

    @Override
    public void setApplyErrorFiles(List errorFiles) {
        this.applyErrorFiles = errorFiles;
    }

    @Override
    public List getApplyErrorFiles() {
        return this.applyErrorFiles;
    }

    @Override
    public void setTemplate(Object template) {
        if (this.dataModel != null) {
            this.dataModel.releaseAllModel();
            this.dataModel = null;
        }
        if (template instanceof IPath) {
            this.dataModel = new StaticApplyTemplateDataModel((IPath)template);
        } else if (template instanceof TilesDefinitionElement) {
            this.dataModel = new TilesApplyTemplateDataModel((TilesDefinitionElement)template);
        }
    }

    @Override
    public IDOMModel getSourceFileModel() {
        return this.selectedSourceFileModel;
    }

    @Override
    public void setSourceFileModel(IFile sourceFile) {
        if (sourceFile == null || this.component == null) {
            return;
        }
        if (this.selectedSourceFileModel != null) {
            this.selectedSourceFileModel.releaseFromRead();
            this.selectedSourceFileModel = null;
        }
        this.selectedSourceFileModel = SelectRegionsUtil.getModelForRead(sourceFile);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == this.specifyContentFileNamePage && !(this.dataModel instanceof TilesApplyTemplateDataModel)) {
            nextPage = super.getNextPage(nextPage);
        }
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage prevPage = super.getPreviousPage(page);
        if (prevPage == this.specifyContentFileNamePage && !(this.dataModel instanceof TilesApplyTemplateDataModel)) {
            prevPage = super.getPreviousPage(prevPage);
        }
        return prevPage;
    }
}

