/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.model;

import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webpage.template.commands.ReplaceTemplateCommand;
import com.ibm.etools.webpage.template.wizards.contentareamapping.MappingUtil;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.pages.operations.IReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.pages.operations.StaticReplaceTemplateToMultipageOperation;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class StaticContentMappingTemplateDataModel
extends ContentMappingTemplateDataModel {
    private MappingUtil util = new MappingUtil();
    private IPath templateLocation;

    public StaticContentMappingTemplateDataModel(IPath templateLocation) {
        this.templateLocation = templateLocation;
        List currentAreas = this.getAreasInSourceModel(this.getSourceModel());
        for (String area : currentAreas) {
            this.setMapping(area, area);
        }
    }

    @Override
    protected IDOMModel createPreviewModel(IDOMModel sourceModel) {
        IStructuredDocument doc;
        ReplaceTemplateCommand command = new ReplaceTemplateCommand();
        String location = this.assignNewLocation(sourceModel, ".htpl");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(location));
        IStructuredDocument iStructuredDocument = doc = file != null ? TemplateURLFixup.getFixupedDocument(file, this.templateLocation) : null;
        if (file != null && doc != null) {
            command.setNewTemplateFile(new FileURL(file.getLocation()), doc);
        } else {
            command.setNewTemplateFileURL(new FileURL(this.templateLocation));
        }
        IDOMModel modelForPreview = this.createCopyModel(sourceModel);
        command.setContentsMap(this.getMappingData());
        HTMLEditDomainCommandProxy target = new HTMLEditDomainCommandProxy(modelForPreview);
        command.setCommandTarget((HTMLCommandTarget)target);
        command.execute();
        modelForPreview.setDirtyState(false);
        return modelForPreview;
    }

    @Override
    public boolean hasDefaultMap(String key) {
        return false;
    }

    @Override
    public List getAreasInSourceModel(IDOMModel sourceModel) {
        return this.util.getCurrentContentAreas(sourceModel);
    }

    @Override
    public List getAreasInTemplate() {
        return this.util.getAvailableContentAreas(this.templateLocation);
    }

    @Override
    public Object getTemplate() {
        return this.templateLocation;
    }

    @Override
    public IPath getTemplateLocation() {
        return this.templateLocation;
    }

    @Override
    public boolean replaceable(IFile sourceFile) {
        return ApplyTplUtil.hasStaticTemplate(sourceFile);
    }

    @Override
    public IReplaceTemplateToMultiPageOperation getMultiPageOperation() {
        return new StaticReplaceTemplateToMultipageOperation(this);
    }
}

