/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.model;

import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webpage.template.commands.ApplyTemplateCommand;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplGet;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.wizards.model.ApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.IApplyTemplateDataModelConstant;
import com.ibm.etools.webpage.template.wizards.pages.operations.IApplyTemplateToMultipageOperation;
import com.ibm.etools.webpage.template.wizards.pages.operations.StaticApplyTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.util.NodeListImpl;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StaticApplyTemplateDataModel
extends ApplyTemplateDataModel
implements IApplyTemplateDataModelConstant {
    private final TemplateModel templateModel;
    private final FileURL templateFileURL;

    public StaticApplyTemplateDataModel() {
        this.templateModel = null;
        this.templateFileURL = null;
    }

    public StaticApplyTemplateDataModel(IPath path) {
        TemplateModel newTemplateModel;
        IDOMModel model;
        block9: {
            block10: {
                if (path == null) {
                    this.templateModel = null;
                    this.templateFileURL = null;
                    return;
                }
                model = null;
                newTemplateModel = null;
                try {
                    model = SelectRegionsUtil.getModelForRead(path);
                    if (model != null) break block9;
                    if (model == null) break block10;
                }
                catch (Throwable throwable) {
                    if (model != null) {
                        model.releaseFromRead();
                        model = null;
                    }
                    this.templateModel = newTemplateModel;
                    this.templateFileURL = this.templateModel != null ? new FileURL(path) : null;
                    throw throwable;
                }
                model.releaseFromRead();
                model = null;
            }
            this.templateModel = newTemplateModel;
            this.templateFileURL = this.templateModel != null ? new FileURL(path) : null;
            return;
        }
        TemplateModelSession session = new TemplateModelSession();
        newTemplateModel = session.getTemplateModel((IStructuredModel)model);
        IDOMDocument doc = model.getDocument();
        this.setTemplatePageDirectives(SelectRegionsUtil.getSpecifiedNodes((Node)doc, "jsp:directive.page"));
        this.setTemplateTaglibs(SelectRegionsUtil.getSpecifiedNodes((Node)doc, "jsp:directive.taglib"));
        if (model != null) {
            model.releaseFromRead();
            model = null;
        }
        this.templateModel = newTemplateModel;
        FileURL fileURL = this.templateFileURL = this.templateModel != null ? new FileURL(path) : null;
        if (this.templateModel == null) {
            return;
        }
        List nodes = TemplateModelUtil.collectGetNode((TemplateModel)this.templateModel);
        if (nodes == null) {
            return;
        }
        Iterator it = nodes.iterator();
        int i = 0;
        while (it.hasNext()) {
            TplGet node = (TplGet)it.next();
            String key = node.getName();
            this.getKeyTurnInfo().put(key, new Integer(i));
            this.getSelectedAreaInfo().put(key, null);
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(CANCONTAIN_SELF);
            this.getCanMappingInfo().put(key, list);
            ++i;
        }
    }

    public TemplateModel getTemplateModel() {
        return this.templateModel;
    }

    @Override
    protected IDOMModel createPreviewModel(IDOMModel sourceModel, Map map) {
        IStructuredDocument doc;
        ApplyTemplateCommand command = new ApplyTemplateCommand();
        String location = this.assignNewLocation(sourceModel, null);
        if (location == null) {
            return null;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(location));
        IStructuredDocument iStructuredDocument = doc = file != null ? TemplateURLFixup.getFixupedDocument(file, this.templateFileURL.getPath()) : null;
        if (file != null && doc != null) {
            command.setNewTemplateFile(new FileURL(file.getLocation()), doc);
        } else {
            command.setNewTemplateFileURL(this.templateFileURL);
        }
        IDOMModel modelForPreview = this.createCopyModel(sourceModel);
        HashMap<String, NodeListImpl> nodeListForPreview = new HashMap<String, NodeListImpl>();
        Set keySet = map.keySet();
        for (String key : keySet) {
            NodeListImpl value = new NodeListImpl();
            List originalNodes = (List)map.get(key);
            if (originalNodes == null) {
                nodeListForPreview.put(key, null);
                continue;
            }
            Iterator itNodes = originalNodes.iterator();
            Iterator itCanContains = this.getCanMapping(key, originalNodes, modelForPreview).iterator();
            while (itNodes.hasNext()) {
                Integer mapInfo;
                Node copyNode;
                Node originalNode = (Node)itNodes.next();
                if (originalNode == null || (copyNode = StaticApplyTemplateDataModel.getSimilarNodeIn(originalNode, modelForPreview)) == null || (mapInfo = (Integer)itCanContains.next()) == null) continue;
                if (StaticApplyTemplateDataModel.isSelf(mapInfo)) {
                    value.add(copyNode);
                    continue;
                }
                if (!StaticApplyTemplateDataModel.isChildren(mapInfo)) continue;
                if (copyNode instanceof Document) {
                    Document document = (Document)copyNode;
                    EditModelQuery query = EditQueryUtil.getEditQuery((Node)document);
                    DocumentQuery.InsertionTarget target = query.getPageInsertionTarget(document);
                    Node startSibling = target.getRef();
                    while (startSibling != null) {
                        value.add(startSibling);
                        startSibling = startSibling.getNextSibling();
                    }
                    continue;
                }
                value.addAll(copyNode.getChildNodes());
            }
            nodeListForPreview.put(key, value);
        }
        HTMLEditDomainCommandProxy commandTarget = new HTMLEditDomainCommandProxy(modelForPreview);
        command.setContentsMap(nodeListForPreview);
        command.setCommandTarget((HTMLCommandTarget)commandTarget);
        command.execute();
        modelForPreview.setDirtyState(false);
        return modelForPreview;
    }

    @Override
    public Node getContentAreaNode(String key) {
        TemplateModel templateModel = this.getTemplateModel();
        TplGet contentAreaNode = TemplateModelUtil.findGetNodeOf((TemplateModel)templateModel, (String)key);
        return contentAreaNode.getRefNode().getDomNode();
    }

    @Override
    public boolean hasDefaultMap(String key) {
        return false;
    }

    @Override
    public Object getTemplate() {
        return this.getTemplateLocation();
    }

    @Override
    public IPath getTemplateLocation() {
        if (this.templateFileURL != null) {
            return this.templateFileURL.getPath();
        }
        return null;
    }

    @Override
    public IApplyTemplateToMultipageOperation getMultiPageOperation() {
        return new StaticApplyTemplateToMultiPageOperation(this);
    }
}

