/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.model;

import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import org.eclipse.core.resources.IFile;

public class FileModelProxy {
    protected IFile file = null;
    protected boolean isRealized = true;
    protected String title;
    protected String src;
    protected Object template = null;
    private boolean applyTemplateFlag = true;

    public FileModelProxy() {
    }

    public FileModelProxy(IFile file) {
        if (file != null && file.exists()) {
            this.file = file;
            this.isRealized = true;
            this.title = SelectRegionsUtil.getHtmlTitle(file);
            this.src = file.getProjectRelativePath().toString();
            this.template = ApplyTplUtil.getTemplateOfInstance(file);
        } else {
            this.file = null;
            this.isRealized = false;
            this.title = "";
            this.src = "";
        }
    }

    public IFile getFile() {
        return this.file;
    }

    public boolean isRealized() {
        return this.isRealized;
    }

    public String getSrc() {
        return this.src;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isApplyTemplateFlag() {
        return this.applyTemplateFlag;
    }

    public void setApplyTemplateFlag(boolean b) {
        this.applyTemplateFlag = b;
    }

    public Object getTemplate() {
        return this.template;
    }

    public static FileModelProxy[] createFileModelProxies(IFile[] files) {
        int nFiles = files == null ? 0 : files.length;
        FileModelProxy[] result = new FileModelProxy[nFiles];
        int i = 0;
        while (i < nFiles) {
            result[i] = new FileModelProxy(files[i]);
            ++i;
        }
        return result;
    }
}

