/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.model;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.wizards.model.ErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import com.ibm.etools.webpage.template.wizards.pages.operations.IReplaceTemplateToMultiPageOperation;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.ErrorInfoValidationUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public abstract class ContentMappingTemplateDataModel
extends TemplateWizardDataModel {
    private IDOMModel sourceModel;
    private Map map = new HashMap();

    public Map getMappingData() {
        return this.map;
    }

    public void setMapping(Object key, Object value) {
        if (key == null) {
            return;
        }
        this.map.put(key, value);
        this.updateModelForPreview = true;
    }

    public void setSourceModel(IDOMModel model) {
        this.sourceModel = model;
        this.updateModelForPreview = true;
    }

    public IDOMModel getSourceModel() {
        return this.sourceModel;
    }

    public abstract List getAreasInSourceModel(IDOMModel var1);

    public abstract List getAreasInTemplate();

    public abstract boolean replaceable(IFile var1);

    public String getDefaultMapFor(String areaName) {
        if (this.getAreasInTemplate().contains(areaName)) {
            return areaName;
        }
        return null;
    }

    @Override
    public ITemplateErrorInfo getErrorInfo(IDOMModel sourceModel) {
        boolean destinationSyntax;
        ErrorInfo info = new ErrorInfo();
        if (sourceModel == null) {
            info.setUnexpactedError(true);
        }
        IPath templateLocation = this.getTemplateLocation();
        Path destLocation = new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)sourceModel));
        boolean templateSyntax = WizardFileUtil.isXMLSyntaxJSP(templateLocation);
        if (templateSyntax != (destinationSyntax = WizardFileUtil.isXMLSyntaxJSP((IPath)destLocation))) {
            info.setSyntaxError(true);
            return info;
        }
        if (ModelManagerUtil.getBaseLocation((IStructuredModel)sourceModel).equals(this.getTemplateLocation())) {
            info.setCyclicNestingError(true);
            return info;
        }
        String destEnc = WizardFileUtil.getIANAEncoding((IPath)destLocation);
        if (!destEnc.equalsIgnoreCase(this.getMasterEncoding())) {
            info.setEncodingError(true);
            return info;
        }
        Map specifiedMapping = this.getMappingData();
        List contentAreasList = this.getAreasInSourceModel(sourceModel);
        if (contentAreasList != null && specifiedMapping != null) {
            Set keyset = specifiedMapping.keySet();
            if (keyset == null) {
                info.setUnexpactedError(true);
            } else if (!contentAreasList.containsAll(keyset)) {
                info.setMappingError(true);
            }
        }
        ErrorInfoValidationUtil.execExternalValidation((ITemplateErrorInfo)info, this, sourceModel);
        return info;
    }

    @Override
    protected IDOMModel createPreviewModel() {
        return this.createPreviewModel(this.getSourceModel());
    }

    public abstract IReplaceTemplateToMultiPageOperation getMultiPageOperation();
}

