/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.model;

import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.wizards.model.ErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.IApplyTemplateDataModelConstant;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizardDataModel;
import com.ibm.etools.webpage.template.wizards.pages.operations.IApplyTemplateToMultipageOperation;
import com.ibm.etools.webpage.template.wizards.pages.testpreview.ErrorInfoValidationUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardFileUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ApplyTemplateDataModel
extends TemplateWizardDataModel
implements IApplyTemplateDataModelConstant {
    private IDOMModel copyModel = null;
    private Map selectedAreaInfo = new HashMap();
    private Map keyTurnInfo = new HashMap();
    private Map canMappingInfo = new HashMap();
    private Set updateMappingInfo = new HashSet();
    protected final String pageDirectiveTagName = "jsp:directive.page";
    protected final String taglibNodeName = "jsp:directive.taglib";
    private Node[] pageDirectives;
    private Node[] taglibs;

    public void setSourceModel(IDOMModel originalModel) {
        if (this.copyModel != null) {
            this.copyModel.releaseFromEdit();
            this.copyModel = null;
        }
        this.copyModel = this.createCopyModel(originalModel);
        this.updateModelForPreview = true;
    }

    @Override
    public void releaseAllModel() {
        if (this.copyModel != null) {
            this.copyModel.releaseFromEdit();
            this.copyModel = null;
        }
        super.releaseAllModel();
    }

    public IDOMModel getCopyModel() {
        return this.copyModel;
    }

    protected static Node getSimilarNodeIn(Node original, IDOMModel targetModel) {
        int offset = ((IndexedRegion)original).getStartOffset();
        Node copyNode = (Node)targetModel.getIndexedRegion(offset);
        if (original.getNodeType() == 9) {
            copyNode = targetModel.getDocument();
        } else if (original.getNodeType() == 1 && ((IDOMElement)original).isImplicitTag()) {
            String orgName = original.getNodeName();
            Node implicitNode = copyNode;
            while (implicitNode != null) {
                if (implicitNode.getNodeName().equals(orgName)) {
                    return implicitNode;
                }
                implicitNode = implicitNode.getParentNode();
            }
        }
        return copyNode;
    }

    protected static boolean isUnderHeadNode(EditModelQuery query, Node node) {
        if (node == null) {
            return false;
        }
        if (query.isHeadCorrespondent(node)) {
            return true;
        }
        return ApplyTemplateDataModel.isUnderHeadNode(query, node.getParentNode());
    }

    public Set getContentAreaInfoKeys() {
        return Collections.unmodifiableSet(this.selectedAreaInfo.keySet());
    }

    public Map getSelectedAreaInfo() {
        return this.selectedAreaInfo;
    }

    public void updateContentAreaInfo(String key, List values) {
        if (!this.selectedAreaInfo.containsKey(key)) {
            return;
        }
        this.selectedAreaInfo.put(key, values);
        this.updateModelForPreview = true;
        this.updateMappingInfo.add(key);
    }

    public List getContentAreaInfo(String key) {
        if (!this.selectedAreaInfo.containsKey(key)) {
            return null;
        }
        Object valueObj = this.selectedAreaInfo.get(key);
        if (valueObj instanceof List) {
            return (List)valueObj;
        }
        return null;
    }

    protected Map getKeyTurnInfo() {
        return this.keyTurnInfo;
    }

    public int getKeyTurn(String key) {
        if (!this.keyTurnInfo.containsKey(key)) {
            return 0;
        }
        Integer n = (Integer)this.keyTurnInfo.get(key);
        return n;
    }

    protected void updateCanMappingInfo(String selectedContentArea) {
        if (selectedContentArea == null) {
            return;
        }
        List selectedNodes = this.getContentAreaInfo(selectedContentArea);
        List canContain = this.getCanMapping(selectedContentArea, selectedNodes, this.getCopyModel());
        this.getCanMappingInfo().put(selectedContentArea, canContain);
    }

    public List getCanMapping(String key, List selectedNodes, IDOMModel targetModel) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (selectedNodes == null) {
            result.add(CANCONTAIN_SELF);
        } else {
            for (Node selectedNode : selectedNodes) {
                Integer canContainFlag = null;
                try {
                    try {
                        canContainFlag = ApplyTemplateDataModel.checkCanContain(selectedNode, targetModel, this.getContentAreaNode(key));
                    }
                    catch (DOMException e) {
                        Logger.log((Throwable)e);
                        if (canContainFlag == null) {
                            canContainFlag = CANNOT_CONTAIN_CHILDREN;
                        }
                        result.add(canContainFlag);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (canContainFlag == null) {
                        canContainFlag = CANNOT_CONTAIN_CHILDREN;
                    }
                    result.add(canContainFlag);
                    throw throwable;
                }
                if (canContainFlag == null) {
                    canContainFlag = CANNOT_CONTAIN_CHILDREN;
                }
                result.add(canContainFlag);
            }
        }
        return result;
    }

    protected static Integer checkCanContain(Node selectedNode, IDOMModel targetModel, Node contentAreaNodeOfTemplate) {
        Element parentElement;
        Node currentNode = ApplyTemplateDataModel.getSimilarNodeIn(selectedNode, targetModel);
        Node contentAreaNode = contentAreaNodeOfTemplate;
        Node parentOfTemplate = null;
        if (contentAreaNode.getNodeType() == 2) {
            return CANNOT_CONTAIN_SELF;
        }
        if (contentAreaNode.getNodeType() == 3) {
            parentOfTemplate = contentAreaNode;
        } else if (contentAreaNode.getNodeType() == 1) {
            parentOfTemplate = contentAreaNode.getParentNode();
        }
        String parentTag = parentOfTemplate.getNodeName();
        Element parentNode = parentElement = targetModel.getDocument().createElement(parentTag);
        while (parentOfTemplate instanceof IDOMElement && (((IDOMElement)parentOfTemplate).isCommentTag() || !((IDOMElement)parentOfTemplate).isGlobalTag())) {
            parentOfTemplate = parentOfTemplate.getParentNode();
            parentTag = parentOfTemplate.getNodeName();
            parentNode = parentElement = targetModel.getDocument().createElement(parentTag);
        }
        return ApplyTemplateDataModel.checkCanContain((Node)parentNode, currentNode, parentOfTemplate);
    }

    private static Integer checkCanContain(Node parentNode, Node currentNode, Node parentOfTemplate) {
        EditModelQuery emq = EditQueryUtil.getEditQuery((Node)currentNode);
        NodeList currentChildrenNode = currentNode.getChildNodes();
        Integer canContainFlag = null;
        if (emq.canContain(parentNode, currentNode)) {
            canContainFlag = CANCONTAIN_SELF;
        } else {
            EditModelQuery emqTpl = EditQueryUtil.getEditQuery((Node)parentOfTemplate);
            if (emqTpl != null && (!ApplyTemplateDataModel.isUnderHeadNode(emqTpl, parentOfTemplate) || emqTpl.isHeadCorrespondent(parentOfTemplate)) && ApplyTemplateDataModel.isUnderHeadNode(emq, currentNode.getParentNode())) {
                canContainFlag = CANNOT_CONTAIN_SELF;
            } else {
                int childrenCount = currentChildrenNode.getLength();
                canContainFlag = CANCONTAIN_CHILDREN;
                int i = 0;
                while (i < childrenCount) {
                    if (!emq.canContain(parentNode, currentChildrenNode.item(i))) {
                        canContainFlag = CANNOT_CONTAIN_CHILDREN;
                        break;
                    }
                    ++i;
                }
            }
        }
        return canContainFlag;
    }

    public Integer checkCanMapping(Node selectedNode, String selectedContentArea, IDOMModel originalModel) {
        if (selectedContentArea == null || selectedNode == null || originalModel == null) {
            return CANNOT_CONTAIN_SELF;
        }
        IDOMModel model = null;
        try {
            model = this.createCopyModel(originalModel);
            Integer n = ApplyTemplateDataModel.checkCanContain(selectedNode, model, this.getContentAreaNode(selectedContentArea));
            return n;
        }
        catch (DOMException dOMException) {
            Integer n = CANNOT_CONTAIN_SELF;
            return n;
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
                model = null;
            }
        }
    }

    protected Map getCanMappingInfo() {
        return this.canMappingInfo;
    }

    public List getCanMapping(String key) {
        if (this.updateMappingInfo.contains(key)) {
            this.updateCanMappingInfo(key);
            this.updateMappingInfo.remove(key);
        }
        if (!this.canMappingInfo.containsKey(key)) {
            return null;
        }
        Object value = this.canMappingInfo.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        return null;
    }

    @Override
    protected IDOMModel createPreviewModel() {
        return this.createPreviewModel(this.getCopyModel(), this.getSelectedAreaInfo());
    }

    @Override
    protected IDOMModel createPreviewModel(IDOMModel sourceModel) {
        IApplyTemplateToMultipageOperation op = this.getMultiPageOperation();
        Map mapping = op.getContentsMap(sourceModel);
        return this.createPreviewModel(sourceModel, mapping);
    }

    protected abstract IDOMModel createPreviewModel(IDOMModel var1, Map var2);

    protected void setTemplatePageDirectives(Node[] nodes) {
        this.pageDirectives = nodes;
    }

    protected void setTemplateTaglibs(Node[] nodes) {
        this.taglibs = nodes;
    }

    public Node[] getTemplatePageDirectives() {
        return this.pageDirectives;
    }

    public Node[] getTemplateTagLibs() {
        return this.taglibs;
    }

    public abstract Node getContentAreaNode(String var1);

    public static boolean isSelf(Object mapinfo) {
        return CANCONTAIN_SELF.equals(mapinfo) || CANNOT_CONTAIN_SELF.equals(mapinfo);
    }

    public static boolean isChildren(Object mapinfo) {
        return CANCONTAIN_CHILDREN.equals(mapinfo) || CANNOT_CONTAIN_CHILDREN.equals(mapinfo);
    }

    public static boolean isValid(Object mapinfo) {
        return CANCONTAIN_SELF.equals(mapinfo) || CANCONTAIN_CHILDREN.equals(mapinfo);
    }

    @Override
    public ITemplateErrorInfo getErrorInfo(IDOMModel sourceModel) {
        String destEnc;
        boolean destinationSyntax;
        ErrorInfo info = new ErrorInfo();
        if (this.getTemplate() == null) {
            info.setCommandError(true);
            return info;
        }
        IPath templateLocation = this.getTemplateLocation();
        Path destLocation = new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)sourceModel));
        boolean templateSyntax = WizardFileUtil.isXMLSyntaxJSP(templateLocation);
        if (templateSyntax != (destinationSyntax = WizardFileUtil.isXMLSyntaxJSP((IPath)destLocation))) {
            info.setSyntaxError(true);
            return info;
        }
        if (ModelManagerUtil.getBaseLocation((IStructuredModel)sourceModel).equals(this.getTemplateLocation())) {
            info.setCyclicNestingError(true);
        }
        if (!(destEnc = WizardFileUtil.getIANAEncoding((IPath)destLocation)).equalsIgnoreCase(this.getMasterEncoding())) {
            info.setEncodingError(true);
            return info;
        }
        this.checkMapping(sourceModel, info);
        ErrorInfoValidationUtil.execExternalValidation((ITemplateErrorInfo)info, this, sourceModel);
        return info;
    }

    public void checkMapping(IDOMModel sourceModel, ITemplateErrorInfo info) {
        IApplyTemplateToMultipageOperation appTpl = this.getMultiPageOperation();
        int check = appTpl.checkMapping(sourceModel);
        if (check == 2) {
            info.setMappingError(true);
        } else if (check == 1) {
            info.setExpandMapping(true);
        }
    }

    public abstract IApplyTemplateToMultipageOperation getMultiPageOperation();
}

