/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.contentareamapping;

import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.wizards.contentareamapping.ContentAreaMappingTable;
import com.ibm.etools.webpage.template.wizards.contentareamapping.MappingUtil;
import com.ibm.etools.webpage.template.wizards.model.ContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.StaticContentMappingTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.selecttpl.ModelPreviewWidget;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ContentAreaMappingPage
extends WizardPage {
    private ContentMappingTemplateDataModel dataModel;
    protected String label1;
    protected String label2;
    protected String name1;
    protected String name2;
    protected String shortcut1;
    protected String shortcut2;
    private ContentAreaMappingTable table = new ContentAreaMappingTable(){

        @Override
        protected void notifyTableEdited() {
            ContentAreaMappingPage.this.tableEdited();
        }

        @Override
        protected void notifyTableValueChanged(String key, String value, boolean byUser) {
            ContentAreaMappingPage.this.tableValueChanged(key, value);
        }
    };
    private ModelPreviewWidget preview1;
    private ModelPreviewWidget preview2;
    protected boolean init;
    protected boolean notedited = true;
    PreviewUpdater updater;
    private final int DELAY_MSEC = 1000;

    public ContentAreaMappingPage(IDOMModel model1) {
        super(ResourceHandler._UI_Set_Content_Area_Mapping_7, ResourceHandler._UI_Set_Content_Area_Mapping_8, null);
        this.setDescription(ResourceHandler._UI_Specify_mapping_between_new_target_area_and_current_content_area__1);
        this.setDataModel(this.createDataModel(model1));
    }

    public void createControl(Composite parent) {
        parent.setLayoutData((Object)new GridData(1808));
        Composite page = ContentAreaMappingPage.createPageComposite(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)page, "com.ibm.etools.webpage.template.rpctpl0020");
        Label label = new Label(page, 0);
        label.setText(ResourceHandler._UI_Specify_target_area__name_of_each_content_areas__9);
        Table tableWidget = this.table.createTable(page);
        GridData griddata = new GridData();
        griddata.widthHint = 320;
        griddata.heightHint = 100;
        griddata.horizontalAlignment = 2;
        this.table.setLayoutData(griddata);
        tableWidget.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (ContentAreaMappingPage.this.notedited) {
                    ContentAreaMappingPage.this.tableEdited();
                }
            }
        });
        this.createPreview(page);
        this.setControl((Control)page);
    }

    private static Composite createPageComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        return composite;
    }

    private Composite createPreview(Composite parent) {
        this.initPreviewLabels();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.preview1 = new ModelPreviewWidget(this.label1, this.name1, this.shortcut1);
        this.preview1.createControls(composite, 200, 200, 1808);
        if (this.getDataModel() != null) {
            this.preview1.setModel(this.getDataModel().getSourceModel());
        }
        this.preview2 = new ModelPreviewWidget(this.label2, this.name2, this.shortcut2);
        this.preview2.createControls(composite, 200, 200, 1808);
        return composite;
    }

    protected void initPreviewLabels() {
        this.label1 = ResourceHandler._UI_Preview_of__current_file__1;
        this.label2 = ResourceHandler._UI_Preview_of_fi_xed_file__2;
        this.name1 = ResourceHandler._UI_Preview_of_current_file__3;
        this.name2 = ResourceHandler._UI_Preview_of_fixed_file__4;
        this.shortcut1 = ResourceHandler._UI_Alt_c_5;
        this.shortcut2 = ResourceHandler._UI_Alt_x_6;
    }

    protected void updatePreviewLabels() {
        this.initPreviewLabels();
        if (this.preview1 != null) {
            this.preview1.updateLabels(this.label1, this.name1, this.shortcut1);
        }
        if (this.preview2 != null) {
            this.preview2.updateLabels(this.label2, this.name2, this.shortcut2);
        }
    }

    public void setVisible(boolean visible) {
        if (!this.init) {
            this.table.setTableData(this.dataModel);
            this.init = true;
        }
        super.setVisible(visible);
    }

    protected Map getMappingData() {
        return this.getDataModel().getMappingData();
    }

    protected void tableValueChanged(String newKey, String newValue) {
        if (newKey != null) {
            this.getDataModel().setMapping(newKey, newValue);
        }
        this.setPageComplete(this.table.canComplete());
        this.updateErrorMessage();
        this.deferredUpdateFixedModel();
    }

    void tableEdited() {
        this.notedited = false;
        this.updateErrorMessage();
    }

    protected void deferredUpdateFixedModel() {
        Display dsp = Display.getCurrent();
        if (dsp != null && !dsp.isDisposed()) {
            this.updater = new PreviewUpdater();
            dsp.timerExec(1000, (Runnable)this.updater);
        }
    }

    protected void updateSourceModel(IDOMModel model) {
        this.preview1.setModel(model);
        this.setDataModel(this.createDataModel(model));
    }

    protected ContentMappingTemplateDataModel createDataModel(IDOMModel model) {
        IFile currentTemplate = new MappingUtil().getTemplateFile(model);
        StaticContentMappingTemplateDataModel newDataModel = new StaticContentMappingTemplateDataModel(currentTemplate != null ? currentTemplate.getLocation() : null);
        newDataModel.setSourceModel(model);
        return newDataModel;
    }

    protected ContentMappingTemplateDataModel createDataModel(Object template) {
        IDOMModel sourceModel = this.dataModel != null ? this.dataModel.getSourceModel() : null;
        StaticContentMappingTemplateDataModel newDataModel = new StaticContentMappingTemplateDataModel((IPath)template);
        newDataModel.setSourceModel(sourceModel);
        return newDataModel;
    }

    protected void setDataModel(ContentMappingTemplateDataModel newDataModel) {
        if (this.dataModel != null) {
            this.dataModel.releaseAllModel();
        }
        this.dataModel = newDataModel;
    }

    public ContentMappingTemplateDataModel getDataModel() {
        return this.dataModel;
    }

    protected void updateFixedModel() {
        IDOMModel newmodel = this.dataModel.getSourceModel();
        if (newmodel == null) {
            return;
        }
        this.preview2.setModel(this.dataModel.getModelForPreview());
    }

    public void dispose() {
        if (this.preview1 != null) {
            this.preview1.setModel(null);
            this.preview1.disposeThumbnail();
            this.preview1 = null;
        }
        if (this.preview2 != null) {
            this.preview2.setModel(null);
            this.preview2.disposeThumbnail();
            this.preview2 = null;
        }
        if (this.dataModel != null) {
            this.dataModel.releaseAllModel();
            this.dataModel = null;
        }
        super.dispose();
    }

    private void updateErrorMessage() {
        if (this.notedited || this.table.canComplete()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.table.getErrorMessage());
        }
    }

    public void templateChanged() {
    }

    public boolean canComplete() {
        return this.table.canComplete();
    }

    public void allowDuplicateSelection(boolean allow) {
        this.table.allowDuplicateSelection(allow);
    }

    class PreviewUpdater
    implements Runnable {
        PreviewUpdater() {
        }

        @Override
        public void run() {
            if (this != ContentAreaMappingPage.this.updater) {
                return;
            }
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed() && !ContentAreaMappingPage.this.getControl().isDisposed() && ContentAreaMappingPage.this.getControl().isVisible()) {
                BusyIndicator.showWhile((Display)dsp, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ContentAreaMappingPage.this.updateFixedModel();
                    }
                });
            }
        }
    }
}

