/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.applytpl.selectregions;

import com.ibm.etools.webedit.common.commands.utils.EditModelQuery;
import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webpage.template.commands.PageTemplateCommandUtil;
import com.ibm.etools.webpage.template.wizards.applytpl.selectregions.ISelectRegionsConstant;
import com.ibm.etools.webpage.template.wizards.applytpl.selectregions.JFaceExplicitHTMLTagContentProvider;
import com.ibm.etools.webpage.template.wizards.applytpl.selectregions.SelectRegionItem;
import com.ibm.etools.webpage.template.wizards.model.ApplyTemplateDataModel;
import com.ibm.etools.webpage.template.wizards.model.IApplyTemplateDataModelConstant;
import com.ibm.etools.webpage.template.wizards.selecttpl.ModelPreviewWidget;
import com.ibm.etools.webpage.template.wizards.util.SelectRegionsUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardsImageDescriptorUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.html.ui.internal.contentoutline.JFaceNodeAdapterFactoryForHTML;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSpecifyContentDomTreeWidget
implements ISelectRegionsConstant {
    private final String pageDirectiveTagName = "jsp:directive.page";
    private final String tagLibNodeName = "jsp:directive.taglib";
    final Image mappedIcon = WizardsImageDescriptorUtil.createImageDescriptor("full/apply_tpl/mapped.gif").createImage();
    final Image unmappedIcon = null;
    private final int SIZING_TABLE_HEIGHT = 200;
    private final int SIZING_TABLE_WIDTH = 200;
    private final int DELAY_MSEC = 1000;
    private Table selectTable;
    private TreeViewer treeViewer;
    private Tree domTree;
    private Label labelTreeTitle;
    private Button mapButton;
    private Button unmapButton;
    private ModelPreviewWidget previewSource;
    private ModelPreviewWidget previewMapping;
    private ApplyTemplateDataModel dataModel = null;
    private HashMap selectedRegionsCache = new HashMap(0);
    private HashMap checkSelectionMap = new HashMap(0);
    private MyUpdatePreview runnable;

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Text label = new Text(composite, 8);
        GridData gdLabel = new GridData(768);
        gdLabel.horizontalSpan = 3;
        label.setLayoutData((Object)gdLabel);
        label.setText(CONTENT_MAPPING_LABEL_CONTROLS);
        label.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = CONTENT_MAPPING_LABEL_CONTROLS;
                }
            }
        });
        this.createTableArea(composite);
        this.createButton(composite);
        this.createTreeArea(composite);
        Label sep = new Label(composite, 258);
        GridData gdSep = new GridData(768);
        gdSep.horizontalSpan = 3;
        sep.setLayoutData((Object)gdSep);
        this.createPreviewArea(composite);
    }

    private void createTableArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createTable(composite);
    }

    private void createTable(Composite parent) {
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(CONTENT_MAPPING_LABEL_TABLE_TITLE);
        tableLabel.setLayoutData((Object)new GridData(768));
        this.selectTable = new Table(parent, 67588);
        GridData gdTable = new GridData(1808);
        gdTable.heightHint = 200;
        gdTable.widthHint = 200;
        gdTable.verticalSpan = 3;
        this.selectTable.setLayoutData((Object)gdTable);
        this.selectTable.setHeaderVisible(true);
        this.selectTable.setLinesVisible(true);
        this.selectTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSpecifyContentDomTreeWidget.this.fireModifyContentAreaSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractSpecifyContentDomTreeWidget.this.fireModifyInsertedRegions();
            }
        });
        this.selectTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractSpecifyContentDomTreeWidget.this.unmappedIcon != null && !AbstractSpecifyContentDomTreeWidget.this.unmappedIcon.isDisposed()) {
                    AbstractSpecifyContentDomTreeWidget.this.unmappedIcon.dispose();
                }
                if (AbstractSpecifyContentDomTreeWidget.this.mappedIcon != null && !AbstractSpecifyContentDomTreeWidget.this.mappedIcon.isDisposed()) {
                    AbstractSpecifyContentDomTreeWidget.this.mappedIcon.dispose();
                }
            }
        });
        TableColumn columnContentArea = new TableColumn(this.selectTable, 16384, 0);
        columnContentArea.setText(CONTENT_AREA_COLUMN_LABEL);
        columnContentArea.setResizable(true);
        TableColumn columnRegions = new TableColumn(this.selectTable, 16384, 1);
        columnRegions.setText(REGIONS_COLUMN_LABEL);
        columnRegions.setResizable(true);
    }

    private void createButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gdComposite = new GridData(1040);
        gdComposite.verticalAlignment = 2;
        composite.setLayoutData((Object)gdComposite);
        this.mapButton = new Button(composite, 8);
        this.mapButton.setText(BUTTON_LABEL_MAP);
        this.mapButton.setLayoutData((Object)new GridData(256));
        this.unmapButton = new Button(composite, 8);
        this.unmapButton.setText(BUTTON_LABEL_UNMAP);
        this.unmapButton.setLayoutData((Object)new GridData(256));
        this.unmapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSpecifyContentDomTreeWidget.this.fireLeaveEmpty();
            }
        });
        this.mapButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSpecifyContentDomTreeWidget.this.fireModifyInsertedRegions();
            }
        });
    }

    private void createTreeArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.labelTreeTitle = new Label(composite, 0);
        this.labelTreeTitle.setText(CONTENT_MAPPING_LABEL_TREE_TITLE);
        this.labelTreeTitle.setLayoutData((Object)new GridData(768));
        this.domTree = this.createTreeViewer(composite).getTree();
        GridData gdDomTree = new GridData(1808);
        gdDomTree.heightHint = 200;
        gdDomTree.widthHint = 200;
        this.domTree.setLayoutData((Object)gdDomTree);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(new Tree(parent, 2050));
        this.treeViewer.setContentProvider((IContentProvider)new JFaceExplicitHTMLTagContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new JFaceNodeLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractSpecifyContentDomTreeWidget.this.fireModifyRegionsSelection();
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event != null) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    TreeViewer viewer = (TreeViewer)event.getViewer();
                    if (selection == null || selection.isEmpty()) {
                        return;
                    }
                    for (Object obj : selection) {
                        Node node;
                        if (!(obj instanceof Node) || !(node = (Node)obj).hasChildNodes()) continue;
                        viewer.setExpandedState((Object)node, !viewer.getExpandedState((Object)node));
                    }
                }
            }
        });
        return this.treeViewer;
    }

    private void createPreviewArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gdCompo = new GridData(1808);
        gdCompo.horizontalSpan = 3;
        composite.setLayoutData((Object)gdCompo);
        Text previewLabel = new Text(composite, 8);
        GridData gdLabel = new GridData(768);
        gdLabel.horizontalSpan = 2;
        gdLabel.verticalAlignment = 3;
        previewLabel.setLayoutData((Object)gdLabel);
        previewLabel.setText(CONTENT_MAPPING_PREVIEW_LABEL);
        previewLabel.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = CONTENT_MAPPING_PREVIEW_LABEL;
                }
            }
        });
        this.previewSource = new ModelPreviewWidget(CONTENT_MAPPING_SOURCE_PREVIEW, CONTENT_MAPPING_SOURCE_PREVIEW_NAME, CONTENT_MAPPING_SOURCE_PREVIEW_SHORTCUT);
        Composite previewSourceCompo = this.previewSource.createControls(composite, 200, 200, 32);
        GridData gdPreviewSourceCompo = (GridData)previewSourceCompo.getLayoutData();
        gdPreviewSourceCompo.verticalAlignment = 3;
        this.previewMapping = new ModelPreviewWidget(CONTENT_MAPPING_RESULT_PREVIEW, CONTENT_MAPPING_RESULT_PREVIEW_NAME, CONTENT_MAPPING_RESULT_PREVIEW_SHORTCUT);
        Composite previewResultCompo = this.previewMapping.createControls(composite, 200, 200, 32);
        GridData gdPreviewResultCompo = (GridData)previewResultCompo.getLayoutData();
        gdPreviewResultCompo.verticalAlignment = 3;
    }

    protected void fireLeaveEmpty() {
        TableItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        String contentAreaName = selectedItem.getText(0);
        this.checkSelectionMap.put(contentAreaName, new Boolean(true));
        this.updateTableItem(selectedItem, null);
        this.updateContentMap(contentAreaName, null);
        this.updateMappingPreview(contentAreaName);
        this.validate(true, selectedItem, true);
        this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.changeButtonEnable(selectedItem);
    }

    protected void fireModifyContentAreaSelection() {
        TableItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        this.updateTreeSelection();
        this.validate(false, selectedItem, true);
        this.changeButtonEnable(selectedItem);
    }

    protected void fireModifyRegionsSelection() {
        TableItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        List selectedRegions = ((IStructuredSelection)this.treeViewer.getSelection()).toList();
        if (selectedRegions != null) {
            this.previewSource.setFocusedNodes(selectedRegions);
        }
        this.changeButtonEnable(selectedItem);
    }

    protected void fireModifyInsertedRegions() {
        if (this.dataModel == null) {
            return;
        }
        TableItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        String selectedContentArea = selectedItem.getText(0);
        if (selectedContentArea == null) {
            return;
        }
        List selectedRegions = ((IStructuredSelection)this.treeViewer.getSelection()).toList();
        Collections.sort(selectedRegions, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IndexedRegion && o2 instanceof IndexedRegion) {
                    int offset1 = ((IndexedRegion)o1).getStartOffset();
                    int offset2 = ((IndexedRegion)o2).getStartOffset();
                    return offset1 - offset2;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
        if (selectedRegions == null || selectedRegions.size() <= 0) {
            this.checkSelectionMap.put(selectedContentArea, new Boolean(true));
        } else {
            this.checkSelectionMap.put(selectedContentArea, new Boolean(false));
        }
        this.updateTableItem(selectedItem, selectedRegions);
        this.updateContentMap(selectedContentArea, selectedRegions);
        this.updateMappingPreview(selectedContentArea);
        this.validate(true, selectedItem, true);
        this.changeButtonEnable(selectedItem);
    }

    private void changeButtonEnable(TableItem selectedItem) {
        boolean enableMapButton = false;
        boolean enableUnmapButton = false;
        boolean enablePageElementsTree = false;
        if (selectedItem != null) {
            String contentArea;
            enablePageElementsTree = true;
            if (!this.treeViewer.getSelection().isEmpty()) {
                enableMapButton = true;
            }
            if (!this.getCheckState(contentArea = selectedItem.getText(0))) {
                enableUnmapButton = true;
            }
        }
        this.mapButton.setEnabled(enableMapButton);
        this.unmapButton.setEnabled(enableUnmapButton);
        this.labelTreeTitle.setEnabled(enablePageElementsTree);
        this.domTree.setEnabled(enablePageElementsTree);
    }

    public void changeSourceFile(IDOMModel model) {
        Display dsp;
        NodeList nodes;
        if (this.dataModel == null || this.treeViewer == null) {
            return;
        }
        this.pageStatusValidator();
        if (model == null) {
            this.previewSource.setModel(null);
            return;
        }
        this.dataModel.setSourceModel(model);
        IDOMDocument doc = model.getDocument();
        if (doc == null) {
            return;
        }
        EditModelQuery query = EditQueryUtil.getEditQuery((Node)doc);
        Object selectedSourceRoot = null;
        selectedSourceRoot = query.isFragment((Document)doc) ? doc : doc.getDocumentElement();
        this.treeViewer.setInput(selectedSourceRoot);
        if (selectedSourceRoot != null && (nodes = selectedSourceRoot.getChildNodes()) != null) {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node != null && query.isRenderRoot(node)) {
                    this.treeViewer.setExpandedState((Object)node, true);
                }
                ++i;
            }
        }
        if ((dsp = Display.getCurrent()) != null && !dsp.isDisposed()) {
            BusyIndicator.showWhile((Display)dsp, (Runnable)new SourcePreviewUpdateRunnable(model));
        }
        this.setDefaultRegionSelect((Node)selectedSourceRoot);
    }

    private void updateTreeSelection() {
        TableItem selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        String contentAreaName = selectedItem.getText(0);
        if (contentAreaName == null) {
            return;
        }
        if (this.dataModel == null) {
            return;
        }
        if (this.labelTreeTitle != null) {
            this.labelTreeTitle.setText(CONTENT_MAPPING_LABEL_TREE_TITLE);
        }
        List defaultSelectedNodes = this.dataModel.getContentAreaInfo(contentAreaName);
        if (this.domTree != null) {
            if (defaultSelectedNodes != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(defaultSelectedNodes), true);
            } else {
                this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    protected void doUpdateSourceFile(IDOMModel model) {
        this.previewSource.setModel(model);
    }

    private boolean getCheckState(String selectedArea) {
        Object obj = this.checkSelectionMap.get(selectedArea);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            boolean ret = (Boolean)obj;
            return ret;
        }
        return false;
    }

    private void validate(boolean doUpdate, TableItem validateItem, boolean doSetMessage) {
        String msg = null;
        int state = 0;
        TableItem selectedItem = validateItem == null ? this.getSelectedItem() : validateItem;
        if (selectedItem == null) {
            msg = this.validateSelection(null);
            if (msg != null) {
                state = 3;
            }
            if (msg == null && (msg = this.validateDupPageDirective(null)) != null) {
                state = 2;
            }
            if (msg == null && (msg = this.validateDupTaglib(null)) != null) {
                state = 2;
            }
            if (msg == null && (msg = this.validateContentMapping(null)) != null) {
                state = 2;
            }
        } else {
            String contentAreaName = selectedItem.getText(0);
            SelectRegionItem validateData = (SelectRegionItem)selectedItem.getData();
            if (validateData == null) {
                validateData = new SelectRegionItem(contentAreaName);
                selectedItem.setData((Object)validateData);
                doUpdate = true;
            }
            if (doUpdate) {
                msg = this.validateSelection(contentAreaName);
                if (msg != null) {
                    state = 3;
                }
                if (msg == null && (msg = this.validateDupPageDirective(contentAreaName)) != null) {
                    state = 2;
                }
                if (msg == null && (msg = this.validateDupTaglib(contentAreaName)) != null) {
                    state = 2;
                }
                if (msg == null && (msg = this.validateContentMapping(contentAreaName)) != null) {
                    state = 2;
                }
                validateData.updateValidateData(msg, state);
            } else {
                msg = validateData.getErrorMsg();
                state = validateData.getState();
            }
            if (msg != null) {
                msg = NLS.bind((String)msg, (Object)contentAreaName);
            }
            Image image = null;
            switch (state) {
                case 3: {
                    image = JFaceResources.getImage((String)"dialog_message_error_image");
                    break;
                }
                case 2: {
                    image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                    break;
                }
                case 1: {
                    image = JFaceResources.getImage((String)"dialog_messasge_info_image");
                }
            }
            if (image != null) {
                selectedItem.setImage(0, image);
            }
        }
        if (doSetMessage) {
            this.setMessageToPage(msg, state);
        }
        this.pageStatusValidator();
    }

    private boolean pageStatusValidator() {
        if (this.selectTable == null) {
            return false;
        }
        int returnState = 0;
        TableItem[] allItems = this.selectTable.getItems();
        int i = 0;
        while (i < allItems.length) {
            TableItem item = allItems[i];
            if (item != null) {
                int state;
                SelectRegionItem validateData = (SelectRegionItem)item.getData();
                if (validateData == null) {
                    validateData = new SelectRegionItem(item.getText(0));
                    item.setData((Object)validateData);
                }
                if ((state = validateData.getState()) == 3) {
                    returnState = state;
                    break;
                }
                if (state > returnState) {
                    returnState = state;
                }
            }
            ++i;
        }
        this.setPageState(returnState);
        return returnState != 3;
    }

    private String validateSelection(String contentArea) {
        if (this.dataModel == null) {
            return null;
        }
        Map selectedAreaInfo = this.dataModel.getSelectedAreaInfo();
        if (contentArea != null) {
            if (selectedAreaInfo.get(contentArea) == null && !this.getCheckState(contentArea)) {
                String ret = ERROR_MSG_EMPTY_SELECTION;
                return ret;
            }
            return null;
        }
        String errorArea = "";
        TableItem[] tableItems = this.selectTable.getItems();
        String msg = ERROR_MSG_EMPTY_SELECTION;
        int i = 0;
        while (i < tableItems.length) {
            String key = tableItems[i].getText(0);
            SelectRegionItem validateData = (SelectRegionItem)tableItems[i].getData();
            if (validateData == null) {
                validateData = new SelectRegionItem(key);
                tableItems[i].setData((Object)validateData);
            }
            if (selectedAreaInfo.get(key) == null && !this.getCheckState(key)) {
                if (validateData.getState() < 3) {
                    validateData.updateValidateData(msg, 3);
                }
                if (errorArea.length() > 0) {
                    errorArea = String.valueOf(errorArea) + " , ";
                }
                errorArea = String.valueOf(errorArea) + key;
            }
            ++i;
        }
        if (errorArea.length() > 0) {
            String ret = NLS.bind((String)msg, (Object)errorArea);
            return ret;
        }
        return null;
    }

    private String validateContentMapping(String contentArea) {
        if (this.dataModel == null) {
            return null;
        }
        if (contentArea != null) {
            List flagList = this.dataModel.getCanMapping(contentArea);
            if (flagList != null && (flagList.contains(IApplyTemplateDataModelConstant.CANNOT_CONTAIN_CHILDREN) || flagList.contains(IApplyTemplateDataModelConstant.CANNOT_CONTAIN_SELF))) {
                String ret = ERROR_MSG_HTML_SYNTAX;
                return ret;
            }
            return null;
        }
        String errorArea = "";
        TableItem[] tableItems = this.selectTable.getItems();
        String msg = ERROR_MSG_HTML_SYNTAX;
        int i = 0;
        while (i < tableItems.length) {
            List flagList;
            String key = tableItems[i].getText(0);
            SelectRegionItem validateData = (SelectRegionItem)tableItems[i].getData();
            if (validateData == null) {
                validateData = new SelectRegionItem(key);
                tableItems[i].setData((Object)validateData);
            }
            if ((flagList = this.dataModel.getCanMapping(key)).contains(IApplyTemplateDataModelConstant.CANNOT_CONTAIN_CHILDREN) || flagList.contains(IApplyTemplateDataModelConstant.CANNOT_CONTAIN_SELF)) {
                if (validateData.getState() < 2) {
                    validateData.updateValidateData(msg, 2);
                }
                if (errorArea.length() > 0) {
                    errorArea = String.valueOf(errorArea) + " , ";
                }
                errorArea = String.valueOf(errorArea) + key;
            }
            ++i;
        }
        if (errorArea.length() > 0) {
            String ret = NLS.bind((String)msg, (Object)errorArea);
            return ret;
        }
        return null;
    }

    private String validateDupPageDirective(String contentArea) {
        if (this.dataModel == null) {
            return null;
        }
        Node[] templatePageDirectives = this.dataModel.getTemplatePageDirectives();
        if (templatePageDirectives == null || templatePageDirectives.length <= 0) {
            return null;
        }
        Map selectedAreaInfo = this.dataModel.getSelectedAreaInfo();
        if (selectedAreaInfo == null) {
            return null;
        }
        if (contentArea != null) {
            List nodes = (List)selectedAreaInfo.get(contentArea);
            if (nodes == null) {
                return null;
            }
            for (Node node : nodes) {
                Node[] pageDirectives = SelectRegionsUtil.getSpecifiedNodes(node, "jsp:directive.page");
                if (pageDirectives == null) continue;
                int i = 0;
                while (i < pageDirectives.length) {
                    Node instanceDirective = pageDirectives[i];
                    int j = 0;
                    while (j < templatePageDirectives.length) {
                        Node templateDirective = templatePageDirectives[j];
                        boolean isSame = PageTemplateCommandUtil.isSimilarElement((Node)instanceDirective, (Node)templateDirective, (boolean)false);
                        if (!isSame) {
                            return ERROR_MSG_DUP_PAGE_DIRECTIVE;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return null;
        }
        String errorArea = "";
        TableItem[] tableItems = this.selectTable.getItems();
        if (tableItems == null) {
            return null;
        }
        String msg = ERROR_MSG_DUP_PAGE_DIRECTIVE;
        int i = 0;
        while (i < tableItems.length) {
            String key = tableItems[i].getText(0);
            SelectRegionItem validateData = (SelectRegionItem)tableItems[i].getData();
            if (validateData == null) {
                validateData = new SelectRegionItem(key);
                tableItems[i].setData((Object)validateData);
            }
            boolean error = false;
            List nodes = (List)selectedAreaInfo.get(key);
            if (nodes != null) {
                for (Node node : nodes) {
                    Node[] pageDirectives = SelectRegionsUtil.getSpecifiedNodes(node, "jsp:directive.page");
                    if (pageDirectives != null) {
                        int j = 0;
                        while (j < pageDirectives.length) {
                            Node instanceDirective = pageDirectives[j];
                            int k = 0;
                            while (k < templatePageDirectives.length) {
                                Node templateDirective = templatePageDirectives[k];
                                boolean isSame = PageTemplateCommandUtil.isSimilarElement((Node)instanceDirective, (Node)templateDirective, (boolean)false);
                                if (!isSame) {
                                    error = true;
                                    break;
                                }
                                ++k;
                            }
                            ++j;
                        }
                    }
                    if (error) break;
                }
                if (error) {
                    if (validateData.getState() < 2) {
                        validateData.updateValidateData(msg, 2);
                    }
                    if (errorArea.length() > 0) {
                        errorArea = String.valueOf(errorArea) + " , ";
                    }
                    errorArea = String.valueOf(errorArea) + key;
                }
            }
            ++i;
        }
        if (errorArea.length() > 0) {
            String ret = NLS.bind((String)msg, (Object)errorArea);
            return ret;
        }
        return null;
    }

    private String validateDupTaglib(String contentArea) {
        if (this.dataModel == null) {
            return null;
        }
        Node[] templateTagLibs = this.dataModel.getTemplateTagLibs();
        if (templateTagLibs == null || templateTagLibs.length <= 0) {
            return null;
        }
        Map selectedAreaInfo = this.dataModel.getSelectedAreaInfo();
        if (selectedAreaInfo == null) {
            return null;
        }
        if (contentArea != null) {
            List nodes = (List)selectedAreaInfo.get(contentArea);
            if (nodes == null) {
                return null;
            }
            for (Node node : nodes) {
                Node[] taglibs = SelectRegionsUtil.getSpecifiedNodes(node, "jsp:directive.taglib");
                if (taglibs == null) continue;
                int i = 0;
                while (i < taglibs.length) {
                    Node taglib = taglibs[i];
                    if (taglib instanceof Element) {
                        boolean isSame;
                        String prefix = ((Element)taglib).getAttribute("prefix");
                        Element comparePrefixResult = PageTemplateCommandUtil.findTaglibDirectiveWithSpecifiedPrefix(Arrays.asList(templateTagLibs), (String)prefix);
                        if (comparePrefixResult != null && !(isSame = PageTemplateCommandUtil.isSimilarElement((Node)taglib, (Node)comparePrefixResult, (boolean)false))) {
                            return ERROR_MSG_DUP_PAGE_DIRECTIVE;
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        String errorArea = "";
        TableItem[] tableItems = this.selectTable.getItems();
        if (tableItems == null) {
            return null;
        }
        String msg = ERROR_MSG_DUP_PAGE_DIRECTIVE;
        int i = 0;
        while (i < tableItems.length) {
            String key = tableItems[i].getText(0);
            SelectRegionItem validateData = (SelectRegionItem)tableItems[i].getData();
            if (validateData == null) {
                validateData = new SelectRegionItem(key);
                tableItems[i].setData((Object)validateData);
            }
            boolean error = false;
            List nodes = (List)selectedAreaInfo.get(key);
            if (nodes != null) {
                for (Node node : nodes) {
                    Node[] taglibs = SelectRegionsUtil.getSpecifiedNodes(node, "jsp:directive.taglib");
                    if (taglibs == null) continue;
                    int j = 0;
                    while (j < taglibs.length) {
                        Node taglib = taglibs[j];
                        if (taglib instanceof Element) {
                            boolean isSame;
                            String prefix = ((Element)taglib).getAttribute("prefix");
                            Element comparePrefixResult = PageTemplateCommandUtil.findTaglibDirectiveWithSpecifiedPrefix(Arrays.asList(templateTagLibs), (String)prefix);
                            if (comparePrefixResult != null && !(isSame = PageTemplateCommandUtil.isSimilarElement((Node)taglib, (Node)comparePrefixResult, (boolean)false))) {
                                error = true;
                                break;
                            }
                        }
                        ++j;
                    }
                    if (error) break;
                }
                if (error) {
                    if (validateData.getState() < 2) {
                        validateData.updateValidateData(msg, 2);
                    }
                    if (errorArea.length() > 0) {
                        errorArea = String.valueOf(errorArea) + " , ";
                    }
                    errorArea = String.valueOf(errorArea) + key;
                }
            }
            ++i;
        }
        if (errorArea.length() > 0) {
            String ret = NLS.bind((String)msg, (Object)errorArea);
            return ret;
        }
        return null;
    }

    private TableItem getSelectedItem() {
        TableItem[] selectedItems = this.selectTable.getSelection();
        if (selectedItems.length == 1) {
            return selectedItems[0];
        }
        return null;
    }

    public void setTemplateProxy(ApplyTemplateDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void initContentAreaInfo(boolean doUpdateSource) {
        if (this.dataModel == null) {
            return;
        }
        Set contentAreaIdSet = this.dataModel.getContentAreaInfoKeys();
        HashMap checkSelectionMapCache = new HashMap(this.checkSelectionMap);
        this.checkSelectionMap.clear();
        String[] items = new String[contentAreaIdSet.size()];
        Iterator it = contentAreaIdSet.iterator();
        while (it.hasNext()) {
            String key;
            items[this.dataModel.getKeyTurn((String)key)] = key = it.next().toString();
            if (checkSelectionMapCache.get(key) != null) {
                this.checkSelectionMap.put(key, checkSelectionMapCache.get(key));
                continue;
            }
            this.checkSelectionMap.put(key, new Boolean(true));
        }
        this.selectTable.removeAll();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = new TableItem(this.selectTable, 16384);
            tableItem.setText(0, items[i]);
            SelectRegionItem item = new SelectRegionItem(items[i]);
            tableItem.setData((Object)item);
            if (!doUpdateSource && this.selectedRegionsCache != null) {
                if (this.selectedRegionsCache.containsKey(items[i])) {
                    List nodes = (List)this.selectedRegionsCache.get(items[i]);
                    this.updateTableItem(tableItem, nodes);
                    this.updateContentMap(items[i], nodes);
                    this.updateMappingPreview(items[i]);
                    this.validate(true, tableItem, false);
                } else {
                    this.validate(true, tableItem, false);
                }
            }
            ++i;
        }
        TableColumn[] columns = this.selectTable.getColumns();
        int i2 = 0;
        while (i2 < this.selectTable.getColumnCount()) {
            if (!columns[i2].isDisposed()) {
                columns[i2].pack();
            }
            ++i2;
        }
    }

    private void setDefaultRegionSelect(Node selectedSourceRoot) {
        if (this.dataModel == null || this.selectTable == null) {
            return;
        }
        TableItem[] items = this.selectTable.getItems();
        boolean initHeadArea = true;
        boolean initBodyArea = true;
        boolean initTitleArea = true;
        int i = 0;
        while (i < items.length) {
            String contentAreaName = items[i].getText(0);
            Node contentAreaNode = this.dataModel.getContentAreaNode(contentAreaName);
            Node parentOfTemplate = null;
            if (contentAreaNode.getNodeType() == 2) {
                parentOfTemplate = ((Attr)contentAreaNode).getOwnerElement();
            } else if (contentAreaNode.getNodeType() == 3) {
                parentOfTemplate = contentAreaNode;
            } else if (contentAreaNode.getNodeType() == 1) {
                parentOfTemplate = contentAreaNode.getParentNode();
            }
            EditModelQuery query = EditQueryUtil.getEditQuery((Node)parentOfTemplate);
            Node headNode = this.getAncestorHead(query, parentOfTemplate);
            Node bodyNode = this.getAncestorBody(query, parentOfTemplate);
            Node titleNode = this.getAncestorTitle(query, parentOfTemplate);
            boolean doSet = false;
            query = EditQueryUtil.getEditQuery((Node)selectedSourceRoot);
            Node node = null;
            if (titleNode != null && initTitleArea) {
                NodeList list;
                doSet = true;
                Document doc = selectedSourceRoot.getOwnerDocument();
                if (doc == null) {
                    doc = (Document)selectedSourceRoot;
                }
                if ((list = doc.getElementsByTagName("TITLE")).getLength() > 0) {
                    node = list.item(0);
                }
            } else if (headNode != null && initHeadArea) {
                doSet = true;
                node = query.getHeadCorrespondentNode(selectedSourceRoot, false);
            } else if (bodyNode != null && initBodyArea) {
                doSet = true;
                node = query.getRenderRootNode(selectedSourceRoot, false);
            }
            if (this.dataModel.hasDefaultMap(contentAreaName)) {
                doSet = false;
            }
            if (doSet) {
                if (node == null) {
                    this.checkSelectionMap.put(contentAreaName, new Boolean(true));
                    this.updateTableItem(items[i], null);
                    this.updateContentMap(contentAreaName, null);
                    this.updateMappingPreview(contentAreaName);
                    this.validate(true, items[i], false);
                } else {
                    this.checkSelectionMap.put(contentAreaName, new Boolean(false));
                    List<Object> nodes = Arrays.asList(node);
                    this.updateTableItem(items[i], nodes);
                    this.updateContentMap(contentAreaName, nodes);
                    this.updateMappingPreview(contentAreaName);
                    this.validate(true, items[i], false);
                }
                if (titleNode != null) {
                    initTitleArea = false;
                } else if (headNode != null) {
                    initHeadArea = false;
                } else if (bodyNode != null) {
                    initBodyArea = false;
                }
            } else {
                this.checkSelectionMap.put(contentAreaName, new Boolean(true));
                this.updateTableItem(items[i], null);
                this.updateContentMap(contentAreaName, null);
                this.updateMappingPreview(contentAreaName);
                this.validate(true, items[i], false);
            }
            ++i;
        }
        this.fireModifyContentAreaSelection();
        this.changeButtonEnable(this.getSelectedItem());
    }

    private Node getAncestorHead(EditModelQuery query, Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        if (query.isHeadCorrespondent(parentNode)) {
            return parentNode;
        }
        return this.getAncestorHead(query, parentNode.getParentNode());
    }

    private Node getAncestorBody(EditModelQuery query, Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        if (query.isRenderRoot(parentNode)) {
            return parentNode;
        }
        return this.getAncestorBody(query, parentNode.getParentNode());
    }

    private Node getAncestorTitle(EditModelQuery query, Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        if (parentNode.getNodeType() == 1 && parentNode.getNodeName().equalsIgnoreCase("TITLE")) {
            return parentNode;
        }
        return null;
    }

    private void updateTableItem(TableItem item, List nodes) {
        String text = "";
        if (item == null) {
            return;
        }
        if (nodes != null) {
            for (Node node : nodes) {
                if (node == null) continue;
                String nodeName = node.getNodeName();
                if (text.length() > 0) {
                    text = String.valueOf(text) + " , ";
                }
                text = String.valueOf(text) + nodeName;
            }
        }
        if (text.length() == 0 && this.getCheckState(item.getText(0))) {
            if (text.length() == 0 && this.dataModel.hasDefaultMap(item.getText(0))) {
                text = "(predefined file)";
            }
            item.setText(1, text);
            item.setImage(0, this.unmappedIcon);
        } else {
            item.setText(1, text);
            item.setImage(0, this.mappedIcon);
        }
    }

    protected void updateContentMap(String selectedContentAteaKey, List selectedNodes) {
        if (selectedContentAteaKey == null) {
            return;
        }
        if (this.dataModel != null) {
            this.dataModel.updateContentAreaInfo(selectedContentAteaKey, selectedNodes);
        }
        this.selectedRegionsCache.put(selectedContentAteaKey, selectedNodes);
    }

    private void updateMappingPreview(String selectedContentArea) {
        if (this.runnable != null) {
            this.runnable.kill();
            this.runnable = null;
        }
        if (this.dataModel == null) {
            return;
        }
        if (selectedContentArea != null) {
            if (!this.pageStatusValidator()) {
                this.previewMapping.setModel(null);
                return;
            }
        } else {
            this.previewMapping.setModel(null);
            return;
        }
        this.runnable = new MyUpdatePreview(1000);
        this.runnable.init(this.dataModel, this.previewMapping);
    }

    public void disposeThumbnail() {
        if (this.previewSource != null) {
            this.previewSource.disposeThumbnail();
        }
        if (this.previewMapping != null) {
            this.previewMapping.disposeThumbnail();
        }
    }

    protected abstract void setPageState(int var1);

    protected abstract void setMessageToPage(String var1, int var2);

    static void installJFaceFactory(IDOMModel model) {
        INodeAdapterFactory factory = model.getFactoryRegistry().getFactoryFor(AbstractSpecifyContentDomTreeWidget.class);
        if (factory == null) {
            factory = new JFaceNodeAdapterFactoryForHTML(AbstractSpecifyContentDomTreeWidget.class, false);
            model.getFactoryRegistry().addFactory(factory);
        }
    }

    static void uninstallJFaceFactory(IDOMModel model) {
        INodeAdapterFactory factory = model.getFactoryRegistry().getFactoryFor(AbstractSpecifyContentDomTreeWidget.class);
        if (factory != null) {
            model.getFactoryRegistry().removeFactoriesFor((Object)factory);
            factory.release();
        }
    }

    private class MyUpdatePreview
    implements Runnable {
        private int delayMSec = 0;
        private ModelPreviewWidget previewWid;
        private ApplyTemplateDataModel tplModelProxy;
        private boolean killFrag;

        public MyUpdatePreview(int delayMSec) {
            this.delayMSec = delayMSec;
        }

        public void kill() {
            this.killFrag = true;
        }

        public void init(ApplyTemplateDataModel tplModelProxy, ModelPreviewWidget previewWid) {
            this.tplModelProxy = tplModelProxy;
            this.previewWid = previewWid;
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                dsp.timerExec(this.delayMSec, (Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.killFrag) {
                return;
            }
            Display dsp = Display.getCurrent();
            if (dsp != null && !dsp.isDisposed()) {
                BusyIndicator.showWhile((Display)dsp, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MyUpdatePreview.this.doUpdate();
                    }
                });
            }
        }

        protected void doUpdate() {
            this.previewWid.setModel(this.tplModelProxy.getModelForPreview());
        }
    }

    private class SourcePreviewUpdateRunnable
    implements Runnable {
        private IDOMModel model;

        public SourcePreviewUpdateRunnable(IDOMModel model) {
            this.model = model;
        }

        @Override
        public void run() {
            AbstractSpecifyContentDomTreeWidget.this.doUpdateSourceFile(this.model);
        }
    }
}

