/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.wizards.applytpl;

import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.wizards.applytpl.ApplyMappingPage;
import com.ibm.etools.webpage.template.wizards.applytpl.SelectTemplatePage;
import com.ibm.etools.webpage.template.wizards.model.TemplateWizard;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateLastSelectionUtil;
import com.ibm.etools.webpage.template.wizards.util.TemplateURLFixup;
import com.ibm.etools.webpage.template.wizards.util.WizardsImageDescriptorUtil;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class ApplyTemplateWizard
extends Wizard
implements TemplateWizard {
    private SelectTemplatePage selectTemplatePage;
    private ApplyMappingPage applyMappingPage;
    private IDOMModel model;
    private Object template;
    private IRunnableWithProgress finishOp;

    public ApplyTemplateWizard(IDOMModel model) {
        this.model = model;
        this.setWindowTitle(ResourceHandler._UI_Apply_page_template_1);
    }

    public void addPages() {
        if (this.template == null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)this.model)));
            if (file != null) {
                String fType = FileTypeHandler.getFileType((IFile)file);
                boolean isHTMLWiz = "html".equals(fType) || "htpl".equals(fType);
                IFile tplFile = TemplateLastSelectionUtil.getLastSelection(WebComponent.getComponent((IResource)file), isHTMLWiz ? "htpl" : "jtpl");
                if (tplFile != null) {
                    this.setTemplate(tplFile.getLocation());
                }
            }
            this.selectTemplatePage = new SelectTemplatePage(this.model);
            this.selectTemplatePage.setImageDescriptor(WizardsImageDescriptorUtil.createWizbanImageDescriptor("apply_template_wizban.gif"));
            this.addPage((IWizardPage)this.selectTemplatePage);
        }
        this.applyMappingPage = new ApplyMappingPage(this.model);
        this.applyMappingPage.setImageDescriptor(WizardsImageDescriptorUtil.createWizbanImageDescriptor("apply_template_wizban.gif"));
        this.addPage((IWizardPage)this.applyMappingPage);
    }

    @Override
    public IDOMModel getModel() {
        return this.model;
    }

    protected void setApplyPage(ApplyMappingPage page) {
        this.applyMappingPage = page;
    }

    protected ApplyMappingPage getApplyPage() {
        return this.applyMappingPage;
    }

    public boolean performFinish() {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)this.model)));
        String ianaEncoding = ApplyTplUtil.getIANAEncoding((IStructuredModel)this.model);
        this.setTemplate(TemplateURLFixup.performLinkFixup(WebComponent.getComponent((IResource)file), this.getTemplateLocation(), ianaEncoding, this.getShell()));
        FileURL fileURLPT = new FileURL(this.getTemplateLocation());
        if (fileURLPT.getIFile() != null && file != null && fileURLPT.getIFile().getProject().equals((Object)file.getProject())) {
            String fType = FileTypeHandler.getFileType((IFile)file);
            TemplateLastSelectionUtil.setLastSelection(fileURLPT.getIFile(), "jsp".equals(fType) || "jtpl".equals(fType) ? "jtpl" : "htpl");
        }
        return true;
    }

    public Map getContentsMap() {
        if (this.applyMappingPage == null) {
            return null;
        }
        return this.applyMappingPage.getContentsMap();
    }

    protected IPath getTemplateLocation() {
        return this.template instanceof IPath ? (IPath)this.template : null;
    }

    @Override
    public Object getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(Object target) {
        this.template = target;
    }

    @Override
    public IRunnableWithProgress getPerformFinishOperation() {
        return this.finishOp;
    }

    protected void setPerformFinishOperation(IRunnableWithProgress op) {
        this.finishOp = op;
    }
}

