/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.wizards.parts;

import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.internal.wizards.parts.HTMLThumbnailRenderer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

public class HTMLPreviewControl
extends Canvas {
    public static final int DEFAULT_HEIGHT = 200;
    public static final int DEFAULT_WIDTH = 200;
    private String name;
    private String shortcut;
    private HTMLThumbnailRenderer renderer = new HTMLThumbnailRenderer();
    private Image image;
    private ImageData imagedata;
    private List focusedNodes;
    private Color frameColor;

    public HTMLPreviewControl(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                HTMLPreviewControl.this.paintControl(e);
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 16: {
                        e.doit = true;
                        break;
                    }
                    case 8: {
                        e.doit = true;
                        break;
                    }
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Accessible accessible = HTMLPreviewControl.this.getAccessible();
                if (accessible != null) {
                    accessible.setFocus(-1);
                }
                HTMLPreviewControl.this.redrawFocus();
            }

            public void focusLost(FocusEvent e) {
                HTMLPreviewControl.this.redrawFocus();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                HTMLPreviewControl.this.onDispose();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                HTMLPreviewControl.this.onResized();
            }
        });
        this.initAccessible();
    }

    public ImageData getImageData() {
        if (this.renderer != null) {
            return this.renderer.getPageImageData();
        }
        return null;
    }

    public void setModel(IDOMModel model) {
        this.renderer.clear();
        this.renderer.setModel(model);
        this.disposeImage();
        this.prepareImage(null);
        this.redraw();
        this.update();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortCut(String shortcut) {
        this.shortcut = shortcut;
    }

    private boolean prepareImage(org.eclipse.swt.graphics.Rectangle size) {
        if (this.imagedata == null) {
            if (size == null && !this.isDisposed()) {
                size = this.getClientArea();
            }
            if (size == null) {
                return false;
            }
            this.imagedata = this.renderer.getImageData(size.width, size.height);
            if (this.imagedata == null) {
                return false;
            }
        }
        if (this.image == null) {
            this.image = new Image(null, this.imagedata);
        }
        return true;
    }

    void paintControl(PaintEvent e) {
        org.eclipse.swt.graphics.Rectangle rec = this.getClientArea();
        if (!this.prepareImage(rec)) {
            return;
        }
        GC gc = e.gc;
        gc.getClipping();
        gc.setClipping(0, 0, rec.width, rec.height);
        gc.setBackground(this.getDisplay().getSystemColor(25));
        gc.drawImage(this.image, 0, 0, this.imagedata.width, this.imagedata.height, 0, 0, this.imagedata.width, this.imagedata.height);
        if (this.isFocusControl()) {
            gc.drawFocus(1, 1, rec.width, rec.height);
        }
        this.drawFocusedNodeForTarget(gc);
    }

    public void drawFocusedNode(GC gc) {
        this.drawFocusedNode(gc);
    }

    private void drawFocusedNodeForTarget(GC gc) {
        if (this.focusedNodes == null || this.focusedNodes.size() == 0) {
            return;
        }
        if (this.renderer == null) {
            return;
        }
        gc.setForeground(this.getFrameColor());
        gc.setLineWidth(2);
        int i = this.focusedNodes.size() - 1;
        while (i >= 0) {
            List rects = this.renderer.getTargetNodeRects((Node)this.focusedNodes.get(i));
            if (rects != null) {
                if (rects.size() > 1) {
                    Iterator it = rects.iterator();
                    Rectangle rUnion = null;
                    while (it.hasNext()) {
                        Rectangle r = (Rectangle)it.next();
                        rUnion = rUnion == null ? r : rUnion.union(r);
                    }
                    rects.clear();
                    rects.add(rUnion);
                }
                int j = rects.size() - 1;
                while (j >= 0) {
                    Rectangle r = (Rectangle)rects.get(j);
                    gc.drawRectangle(r.x, r.y, r.width, r.height);
                    --j;
                }
            }
            --i;
        }
    }

    public void drawFocusedNodeForPage(Graphics graphics) {
        if (this.focusedNodes == null || this.focusedNodes.size() == 0) {
            return;
        }
        if (this.renderer == null) {
            return;
        }
        graphics.setForegroundColor(this.getFrameColor());
        graphics.setLineWidth(2);
        int i = this.focusedNodes.size() - 1;
        while (i >= 0) {
            List rects = this.renderer.getNodeRects((Node)this.focusedNodes.get(i));
            if (rects != null) {
                Rectangle rUnion = null;
                for (Rectangle r : rects) {
                    if (rUnion == null) {
                        rUnion = r.getCopy();
                        continue;
                    }
                    rUnion.union(r);
                }
                if (rUnion != null) {
                    graphics.drawRectangle(rUnion.x, rUnion.y, rUnion.width, rUnion.height);
                }
            }
            --i;
        }
    }

    private void drawFocus(GC gc) {
        org.eclipse.swt.graphics.Rectangle rec = this.getClientArea();
        gc.drawFocus(1, 1, rec.width, rec.height);
    }

    private Color getFrameColor() {
        if (this.frameColor == null) {
            this.frameColor = new Color((Device)Display.getCurrent(), TemplatePlugin.getDefault().getFrameColorPreference());
        }
        return this.frameColor;
    }

    private void redrawFocus() {
        GC gc = new GC((Drawable)this);
        try {
            this.drawFocus(gc);
        }
        finally {
            gc.dispose();
        }
    }

    private void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = HTMLPreviewControl.this.name;
            }

            public void getHelp(AccessibleEvent e) {
                this.getName(e);
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = HTMLPreviewControl.this.shortcut;
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getSelection(AccessibleControlEvent e) {
                e.childID = -2;
            }

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                org.eclipse.swt.graphics.Rectangle rec = HTMLPreviewControl.this.getClientArea();
                if (rec != null) {
                    Point pt = HTMLPreviewControl.this.toDisplay(new Point(0, 0));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = rec.width;
                    e.height = rec.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 10;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 64;
                if (HTMLPreviewControl.this.isFocusControl()) {
                    e.detail |= 4;
                }
            }
        });
    }

    public void disposeThumbnail() {
        if (this.renderer != null) {
            this.renderer.clear();
        }
    }

    private void onDispose() {
        this.renderer.dispose();
        this.disposeImage();
    }

    private void onResized() {
        this.disposeImage();
    }

    private void disposeImage() {
        if (this.imagedata != null) {
            this.imagedata = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.frameColor != null) {
            this.frameColor.dispose();
            this.frameColor = null;
        }
    }

    public void setFocusedNodes(List nodes) {
        this.focusedNodes = nodes;
        this.redraw();
    }
}

