/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation.props;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.model.util.TemplateEncodingUtil;
import com.ibm.etools.webpage.template.validation.IPropertyResolverContributor;
import com.ibm.etools.webpage.template.validation.IPropertyResolverForContributor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class ContentDescriptionBasedPagePropRslvContributor
implements IPropertyResolverContributor {
    private IContentDescription contentDescr;
    private IContentType contentType;

    public Set getPropertySet() {
        HashSet<String> result = new HashSet<String>();
        result.add("page.content-type");
        result.add("page.encoding");
        return result;
    }

    public boolean hasProperty(String propertyName, IPropertyResolverForContributor parent) {
        if ("page.content-type".equals(propertyName)) {
            return this.contentType != null;
        }
        if ("page.encoding".equals(propertyName)) {
            return this.contentDescr != null;
        }
        return false;
    }

    public Object getProperty(String propertyName, IPropertyResolverForContributor parent) {
        if ("page.content-type".equals(propertyName)) {
            return this.contentType.getId();
        }
        if ("page.encoding".equals(propertyName)) {
            return TemplateEncodingUtil.getIANAEncoding((IContentDescription)this.contentDescr);
        }
        throw new IllegalArgumentException(propertyName);
    }

    public boolean init(String type, IPropertyResolverForContributor parent) {
        this.contentDescr = this.getContentDescription(parent);
        if (this.contentDescr != null) {
            this.contentType = this.contentDescr.getContentType();
        }
        if (this.contentType == null) {
            this.contentType = this.getContentTypeFromName(parent);
        }
        return this.contentDescr != null || this.contentType != null;
    }

    public void clear() {
        this.contentDescr = null;
        this.contentType = null;
    }

    private IContentDescription getContentDescription(IPropertyResolverForContributor parent) {
        IPath path;
        if (parent.hasProperty("page.file")) {
            IFile file = (IFile)parent.getProperty("page.file");
            if (file != null && file.exists()) {
                try {
                    return file.getContentDescription();
                }
                catch (CoreException e) {
                    Logger.log((Throwable)e);
                }
            }
        } else if (parent.hasProperty("page.path") && (path = (IPath)parent.getProperty("page.path")) != null && path.toFile().exists()) {
            IContentDescription iContentDescription;
            String filename = path.lastSegment();
            FileInputStream is = new FileInputStream(path.toFile());
            try {
                iContentDescription = Platform.getContentTypeManager().getDescriptionFor((InputStream)is, filename, IContentDescription.ALL);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.log((Throwable)e);
                }
            }
            ((InputStream)is).close();
            return iContentDescription;
        }
        return null;
    }

    private IContentType getContentTypeFromName(IPropertyResolverForContributor parent) {
        if (parent.hasProperty("page.file")) {
            IFile file = (IFile)parent.getProperty("page.file");
            return file == null ? null : Platform.getContentTypeManager().findContentTypeFor(file.getName());
        }
        if (parent.hasProperty("page.path")) {
            IPath path = (IPath)parent.getProperty("page.path");
            return path == null ? null : Platform.getContentTypeManager().findContentTypeFor(path.lastSegment());
        }
        return null;
    }
}

