/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.actions.navigator;

import com.ibm.etools.tiles.util.TilesUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.proxy.HTMLEditDomainCommandProxy;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.extension.override.CommandExtensionContext;
import com.ibm.etools.webedit.extension.override.DefaultCommandExtensionContext;
import com.ibm.etools.webedit.internal.extension.OverrideActionRegistry;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.commands.DetachTemplateCommand;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import com.ibm.etools.webpage.template.model.util.TemplateTypeUtil;
import com.ibm.etools.webpage.template.tiles.commands.TilesDetachTemplateCommand;
import com.ibm.etools.webpage.template.util.TemplateFacetUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.exceptions.CharConversionErrorWithDetail;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedOutputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class MergeTemplateFromNavigatorActionDelegate
implements IActionDelegate {
    IStructuredSelection fSelection = null;

    public void selectionChanged(IAction action, ISelection selection) {
        boolean bEnable = false;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            bEnable = this.validateSelected((ISelection)this.fSelection);
        }
        ((Action)action).setEnabled(bEnable);
    }

    private boolean validateSelected(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        this.fSelection = (IStructuredSelection)selection;
        for (Object obj : this.fSelection) {
            if (!(obj instanceof IFile)) {
                return false;
            }
            IFile file = (IFile)obj;
            if (TemplateFacetUtil.isInPortletProject((IProject)file.getProject()) && !TemplateFacetUtil.hasHtmlTagInFile((IFile)file)) {
                return false;
            }
            if (FileTypeHandler.getFileType((IFile)file) != null) continue;
            return false;
        }
        return true;
    }

    public void run(IAction action) {
        final IFile[] selectedFiles = this.fSelection.toList().toArray(new IFile[this.fSelection.size()]);
        if (!this.canMerge(selectedFiles)) {
            if (selectedFiles.length == 1) {
                String msg = NLS.bind((String)ResourceHandler._UI__0__does_not_have_a_page_template__1, (Object)selectedFiles[0].getName());
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Merge_Template_into_Page_1, (String)msg);
            } else {
                Integer int_l = new Integer(selectedFiles.length);
                String msg_2 = NLS.bind((String)ResourceHandler._UI_These__0__files_do_not_have_page_templates__2, (Object)int_l);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Merge_Template_into_Page_1, (String)msg_2);
            }
            return;
        }
        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Merge_Template_into_Page_1, (String)ResourceHandler._UI_The_contents_of_the_page_template_will_be_merged_into_this_page___nThis_page_will_no_longer_be_updated_when_the_page_template_is_changed__4)) {
            final boolean[] ret = new boolean[1];
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ret[0] = MergeTemplateFromNavigatorActionDelegate.this.merge(selectedFiles);
                }
            });
            if (!ret[0]) {
                return;
            }
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)ResourceHandler._UI_Merge_Template_into_Page_1, (String)ResourceHandler._UI_Merging_succeded__6);
        }
    }

    private boolean canMerge(IFile[] files) {
        int templateAppliedFiles = 0;
        int i = 0;
        while (i < files.length) {
            IDOMModel model = this.getModelForEdit(files[i]);
            if (model != null) {
                TemplateModelSession session = new TemplateModelSession();
                TemplateModel tplModel = session.getTemplateModel((IStructuredModel)model);
                if (TemplateModelUtil.canRebuild((TemplateModel)tplModel)) {
                    ++templateAppliedFiles;
                } else if (TilesUtil.getTilesType((IDOMModel)model).equals("TilesInstance")) {
                    ++templateAppliedFiles;
                }
                model.releaseFromEdit();
            }
            ++i;
        }
        return templateAppliedFiles != 0;
    }

    private boolean merge(IFile[] files) {
        boolean ret = true;
        int i = 0;
        while (i < files.length) {
            block14: {
                if (files[i] == null || files[i].isReadOnly()) {
                    return false;
                }
                IDOMModel model = this.getModelForEdit(files[i]);
                try {
                    Object command = null;
                    if (TemplateTypeUtil.isInstance((IStructuredModel)model)) {
                        command = new DetachTemplateCommand();
                    } else if (TilesUtil.getTilesType((IDOMModel)model).equals("TilesInstance")) {
                        command = new TilesDetachTemplateCommand(ResourceHandler._UI_Merge_Template_From_Navigator_Action_Delegate_0);
                    }
                    if (command == null) break block14;
                    HTMLEditDomainCommandProxy commandTarget = new HTMLEditDomainCommandProxy(model);
                    command = OverrideActionRegistry.generateExtendedCommand((HTMLCommand)command, (CommandExtensionContext)new DefaultCommandExtensionContext((HTMLCommandTarget)commandTarget, (HTMLCommand)command, "pagetemplate.detachtemplate"), (String)"pagetemplate.detachtemplate");
                    command.setCommandTarget((HTMLCommandTarget)commandTarget);
                    if (!command.canExecute()) {
                        return false;
                    }
                    try {
                        command.execute();
                    }
                    catch (Exception e) {
                        Logger.log((Throwable)e);
                        ret = false;
                    }
                    if (ret && model.getReferenceCountForEdit() == 1) {
                        this.saveModel(files[i], model);
                    }
                }
                finally {
                    if (model != null) {
                        model.releaseFromEdit();
                        model = null;
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    public boolean saveModel(IFile file, IDOMModel model) {
        try {
            try {
                try {
                    try {
                        model.save(file);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        model.save(file, EncodingRule.FORCE_DEFAULT);
                    }
                }
                catch (MalformedOutputExceptionWithDetail malformedOutputExceptionWithDetail) {
                }
                catch (CharConversionErrorWithDetail charConversionErrorWithDetail) {
                    model.save(file, EncodingRule.IGNORE_CONVERSION_ERROR);
                }
            }
            catch (CoreException exception3) {
                Logger.log((Throwable)exception3);
            }
        }
        catch (IOException exception4) {
            Logger.log((Throwable)exception4);
        }
        return true;
    }

    private IDOMModel getModelForEdit(IFile file) {
        ModelManagerUtil mmu = new ModelManagerUtil(null, null);
        IStructuredModel structuredModel = mmu.getModelForEdit(file);
        if (!ModelManagerUtil.isHTMLFamily((IStructuredModel)structuredModel) && structuredModel != null) {
            structuredModel.releaseFromEdit();
            return null;
        }
        return (IDOMModel)structuredModel;
    }
}

