/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableMessageDialog
extends MessageDialog {
    private Table table;
    String tableName;
    private int tableStyle = 68352;
    private int tableHeight = 60;
    private int tableWidth = 200;

    public TableMessageDialog(Shell parent, String dialogTitle, Image titleImage, String dialogMsg, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parent, dialogTitle, titleImage, dialogMsg, dialogImageType, dialogButtonLabels, defaultIndex);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    public void setTableHeight(int height) {
        this.tableHeight = height;
    }

    public void setTableWidth(int width) {
        this.tableWidth = width;
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.table = new Table(composite, this.tableStyle);
        GridData data = new GridData(1808);
        data.heightHint = this.convertVerticalDLUsToPixels(this.tableHeight);
        data.widthHint = this.convertHorizontalDLUsToPixels(this.tableWidth);
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.result == null) {
                    e.result = TableMessageDialog.this.tableName;
                }
            }
        });
        return composite;
    }

    public void createColumn(String name, Image image, boolean resizable, int style, int width, int id) {
        if (this.table == null) {
            return;
        }
        TableColumn column = new TableColumn(this.table, id);
        column.setText(name);
        column.setImage(image);
        column.setResizable(resizable);
        column.setAlignment(style);
        column.setWidth(width);
    }

    public TableItem createNewTableItem() {
        return new TableItem(this.table, 0);
    }

    public Table getTable() {
        return this.table;
    }

    public static TableMessageDialog getInformationDialog(Shell parent, String title, String msg, String tableName) {
        TableMessageDialog dialog = new TableMessageDialog(parent, title, null, msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setTableName(tableName);
        return dialog;
    }

    public static TableMessageDialog getWarningDialog(Shell parent, String title, String msg, String tableName) {
        TableMessageDialog dialog = new TableMessageDialog(parent, title, null, msg, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setTableName(tableName);
        return dialog;
    }

    public static TableMessageDialog getErrorDialog(Shell parent, String title, String msg, String tableName) {
        TableMessageDialog dialog = new TableMessageDialog(parent, title, null, msg, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.setTableName(tableName);
        return dialog;
    }

    public static TableMessageDialog getQuestionDialog(Shell parent, String title, String msg, String tableName) {
        TableMessageDialog dialog = new TableMessageDialog(parent, title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        dialog.setTableName(tableName);
        return dialog;
    }

    public void setColumnWidth(int[] columnsWidth) {
        if (columnsWidth == null || this.table == null) {
            return;
        }
        if (columnsWidth.length == this.table.getColumnCount()) {
            TableColumn[] tableColumns = this.table.getColumns();
            if (tableColumns == null) {
                return;
            }
            int i = 0;
            while (i < tableColumns.length) {
                tableColumns[i].setWidth(columnsWidth[i]);
                ++i;
            }
        }
    }
}

