/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.dialog;

import com.ibm.etools.webpage.template.dialog.IMsgReplaceTemplateErrorInfo;
import com.ibm.etools.webpage.template.dialog.TableMessageDialog;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.model.ITemplateErrorInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class TPLErrorDialog
extends TableMessageDialog
implements IMsgReplaceTemplateErrorInfo {
    protected static final int ERROR_TYPE_FILE_TEMPLATE = 0;
    protected static final int ERROR_TYPE_SYNTAX = 1;
    protected static final int ERROR_TYPE_ENCODING = 2;
    protected static final int ERROR_TYPE_MAPPING = 3;
    protected static final int ERROR_TYPE_COMMAND = 4;
    protected static final int ERROR_TYPE_UNEXPECTED = 5;
    protected static final int ERROR_TYPE_CYCLIC = 6;

    public TPLErrorDialog(Shell parent, String dialogTitle, Image titleImage, String dialogMsg, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parent, dialogTitle, titleImage, dialogMsg, dialogImageType, dialogButtonLabels, defaultIndex);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    public void initialize(ITemplateErrorInfo[] infoArray) {
        String[] columnsName = new String[]{FILE_PATH, FILE_NAME, DESCRIPTION};
        int i = 0;
        while (i < columnsName.length) {
            this.createColumn(columnsName[i], null, true, 0, 20, i);
            ++i;
        }
        Table table = this.getTable();
        if (table == null) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        while (i2 < table.getColumnCount()) {
            if (!columns[i2].isDisposed()) {
                columns[i2].pack();
            }
            ++i2;
        }
        if (infoArray == null || infoArray.length == 0) {
            return;
        }
        i2 = 0;
        while (i2 < infoArray.length) {
            IFile errorFile;
            String filePath = "";
            String fileName = "";
            ITemplateErrorInfo info = infoArray[i2];
            FileModelProxy proxy = info.getErrorFileModelProxy();
            if (proxy != null && (errorFile = proxy.getFile()) != null && errorFile.exists()) {
                String[] str;
                fileName = errorFile.getName();
                filePath = errorFile.getProjectRelativePath().removeLastSegments(1).addTrailingSeparator().toString();
                if (info.isSyntaxError()) {
                    str = new String[]{filePath, fileName, this.getMessage(1)};
                    this.createNewTableItem().setText(str);
                }
                if (info.isEncodingError()) {
                    str = new String[]{filePath, fileName, this.getMessage(2)};
                    this.createNewTableItem().setText(str);
                }
                if (info.isMappingError()) {
                    str = new String[]{filePath, fileName, this.getMessage(3)};
                    this.createNewTableItem().setText(str);
                }
                if (info.isCommandError()) {
                    str = new String[]{filePath, fileName, this.getMessage(4)};
                    this.createNewTableItem().setText(str);
                }
                if (info.isUnexpactedError()) {
                    str = new String[]{filePath, fileName, this.getMessage(5)};
                    this.createNewTableItem().setText(str);
                }
                if (info.isCyclicNestingError()) {
                    str = new String[]{filePath, fileName, this.getMessage(6)};
                    this.createNewTableItem().setText(str);
                }
            }
            ++i2;
        }
    }

    protected abstract String getMessage(int var1);
}

