/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.dialog;

import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.dialog.IReplaceTPLTargetSelectionDialog;
import com.ibm.etools.webpage.template.wizards.TemplateWizardsPlugin;
import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ReplaceTPLTargetSelectionDialog
extends SelectionStatusDialog
implements IReplaceTPLTargetSelectionDialog {
    private final int SIZING_VIEWER_HEIGHT = 100;
    private final String EMPTY_SELECTION_MSG = ResourceHandler._UI_A_page_template_you_want_to_replace_must_be_selected__1;
    private TableViewer viewer;

    public ReplaceTPLTargetSelectionDialog(Shell parent, String title, String message) {
        super(parent);
        this.setTitle(title);
        this.setMessage(message);
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        GridData gdMsg = new GridData(768);
        gdMsg.widthHint = 400;
        label.setLayoutData((Object)gdMsg);
        this.createTableViewer(composite);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.setContentProvider((IContentProvider)new IReplaceTPLTargetSelectionDialog.MyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new IReplaceTPLTargetSelectionDialog.MyLabelProvider());
        GridData gdViewer = new GridData(1808);
        gdViewer.heightHint = 100;
        this.viewer.getControl().setLayoutData((Object)gdViewer);
        new TableColumn(this.viewer.getTable(), 0);
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){
            List selectionCache = new ArrayList(0);

            public void selectionChanged(SelectionChangedEvent event) {
                int lastSelection;
                TableViewer viewer;
                Object selectedObj;
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                List selection = ss.toList();
                if (!selection.equals(this.selectionCache) && (selectedObj = (viewer = (TableViewer)event.getSource()).getElementAt(lastSelection = viewer.getTable().getSelectionIndex())) instanceof IReplaceTPLTargetSelectionDialog.MyTreeElement) {
                    ArrayList<IReplaceTPLTargetSelectionDialog.MyTreeElement> newSelection = new ArrayList<IReplaceTPLTargetSelectionDialog.MyTreeElement>(0);
                    IReplaceTPLTargetSelectionDialog.MyTreeElement selectedElem = (IReplaceTPLTargetSelectionDialog.MyTreeElement)selectedObj;
                    IReplaceTPLTargetSelectionDialog.MyTreeElement[] children = selectedElem.getChildren();
                    if (children == null || children.length == 0) {
                        IReplaceTPLTargetSelectionDialog.MyTreeElement parent = selectedElem.getParent();
                        newSelection.add(parent);
                        newSelection.addAll(Arrays.asList(parent.getChildren()));
                    } else {
                        newSelection.add(selectedElem);
                        newSelection.addAll(Arrays.asList(children));
                    }
                    this.selectionCache = new ArrayList(0);
                    this.selectionCache.addAll(newSelection);
                    ((TableViewer)event.getSource()).setSelection((ISelection)new StructuredSelection(newSelection));
                }
                ReplaceTPLTargetSelectionDialog.this.validate();
            }
        });
    }

    public void setInput(FileModelProxy[] items) {
        if (items == null) {
            return;
        }
        IReplaceTPLTargetSelectionDialog.MyTreeElement root = new IReplaceTPLTargetSelectionDialog.MyTreeElement();
        int i = 0;
        while (i < items.length) {
            new IReplaceTPLTargetSelectionDialog.MyTreeElement(root, items[i]);
            ++i;
        }
        if (this.viewer != null) {
            TableColumn[] columns;
            this.viewer.setInput((Object)root);
            TableItem[] tableItems = this.viewer.getTable().getItems();
            if (tableItems != null) {
                int i2 = 0;
                while (i2 < tableItems.length) {
                    int indentSize = -1;
                    IReplaceTPLTargetSelectionDialog.MyTreeElement element = (IReplaceTPLTargetSelectionDialog.MyTreeElement)this.viewer.getElementAt(i2);
                    while (element.getParent() != null) {
                        ++indentSize;
                        element = element.getParent();
                    }
                    tableItems[i2].setImageIndent(indentSize);
                    ++i2;
                }
            }
            if ((columns = this.viewer.getTable().getColumns()) != null) {
                int i3 = 0;
                while (i3 < columns.length) {
                    TableColumn column = columns[i3];
                    column.pack();
                    ++i3;
                }
                int areaWidth = this.viewer.getTable().getClientArea().width;
                int i4 = 0;
                while (i4 < columns.length) {
                    TableColumn column = columns[i4];
                    if (column.getWidth() < areaWidth) {
                        column.setWidth(areaWidth);
                    }
                    ++i4;
                }
            }
        }
    }

    void validate() {
        Status currentStatus = null;
        Status emptyStatus = new Status(4, TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), 4, this.EMPTY_SELECTION_MSG, null);
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            currentStatus = emptyStatus;
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List selectList = ss.toList();
            for (Object obj : selectList) {
                Object template;
                IReplaceTPLTargetSelectionDialog.MyTreeElement elem;
                if (!(obj instanceof IReplaceTPLTargetSelectionDialog.MyTreeElement) || !(elem = (IReplaceTPLTargetSelectionDialog.MyTreeElement)obj).isTPLElement() || (template = elem.getTemplate()) == null || !ApplyTplUtil.isValidTemplate(template)) continue;
                currentStatus = new Status(0, TemplateWizardsPlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
                break;
            }
            if (currentStatus == null) {
                currentStatus = emptyStatus;
            }
        } else {
            currentStatus = emptyStatus;
        }
        this.updateStatus((IStatus)currentStatus);
    }

    public void create() {
        super.create();
        this.validate();
    }

    protected void computeResult() {
        ArrayList<FileModelProxy> selectedFileModelProxy = new ArrayList<FileModelProxy>(0);
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List selectList = ss.toList();
            for (Object obj : selectList) {
                FileModelProxy proxy;
                IReplaceTPLTargetSelectionDialog.MyTreeElement elem;
                if (!(obj instanceof IReplaceTPLTargetSelectionDialog.MyTreeElement) || (elem = (IReplaceTPLTargetSelectionDialog.MyTreeElement)obj).isTPLElement() || (proxy = elem.getFileModelProxy()) == null) continue;
                selectedFileModelProxy.add(proxy);
            }
        }
        this.setResult(selectedFileModelProxy);
    }

    public static Object[] openDialog(Shell parent, String title, String message, FileModelProxy[] items) {
        ReplaceTPLTargetSelectionDialog dialog = new ReplaceTPLTargetSelectionDialog(parent, title, message);
        dialog.create();
        dialog.setInput(items);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }
}

