/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.dialog;

import com.ibm.etools.webpage.template.wizards.model.FileModelProxy;
import com.ibm.etools.webpage.template.wizards.util.ApplyTplUtil;
import com.ibm.etools.webpage.template.wizards.util.WizardIconUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public interface IReplaceTPLTargetSelectionDialog {

    public static class MyContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MyTreeElement) {
                MyTreeElement root = (MyTreeElement)inputElement;
                List elements = this.createList(root);
                return elements.toArray();
            }
            return null;
        }

        private List createList(MyTreeElement parent) {
            ArrayList<MyTreeElement> ret = new ArrayList<MyTreeElement>(0);
            if (parent == null) {
                return ret;
            }
            MyTreeElement[] children = parent.getChildren();
            if (children == null || children.length == 0) {
                return ret;
            }
            int i = 0;
            while (i < children.length) {
                ret.add(children[i]);
                ret.addAll(this.createList(children[i]));
                ++i;
            }
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class MyLabelProvider
    implements ITableLabelProvider {
        private final WizardIconUtil iconUtil = new WizardIconUtil();

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof MyTreeElement) {
                MyTreeElement elem = (MyTreeElement)element;
                if (elem.isTPLElement()) {
                    Object template = elem.getTemplate();
                    if (template != null) {
                        return this.iconUtil.getTemplateIcon();
                    }
                    return null;
                }
                FileModelProxy proxy = elem.getFileModelProxy();
                if (proxy == null) {
                    return null;
                }
                if (proxy.isRealized()) {
                    return this.iconUtil.getRealizeIcon();
                }
                return this.iconUtil.getUnRealizeIcon();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MyTreeElement) {
                MyTreeElement elem = (MyTreeElement)element;
                if (elem.isTPLElement()) {
                    Object template = elem.getTemplate();
                    if (template != null) {
                        String name = ApplyTplUtil.getTemplateLabel(template);
                        return name;
                    }
                    return "";
                }
                FileModelProxy proxy = elem.getFileModelProxy();
                if (proxy != null) {
                    String title = proxy.getTitle();
                    String src = proxy.getSrc();
                    return String.valueOf(title) + "(" + src + ")";
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.iconUtil != null) {
                this.iconUtil.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static class MyTreeElement {
        private List children = null;
        private MyTreeElement parent = null;
        private Object templateFile;
        private boolean isTPLElement = false;
        private FileModelProxy proxy;

        MyTreeElement() {
            this.children = new ArrayList(0);
        }

        private MyTreeElement(Object templateFile) {
            this.children = new ArrayList(0);
            this.templateFile = templateFile;
            this.isTPLElement = true;
        }

        MyTreeElement(MyTreeElement root, FileModelProxy proxy) {
            if (root == null || proxy == null) {
                return;
            }
            Object parentTemplate = proxy.getTemplate();
            if (parentTemplate == null) {
                return;
            }
            MyTreeElement parent = this.getSpecifiedTPLElement(root, parentTemplate);
            if (parent == null) {
                parent = new MyTreeElement(parentTemplate);
                root.addChild(parent);
            }
            this.proxy = proxy;
            parent.addChild(this);
        }

        private MyTreeElement getSpecifiedTPLElement(MyTreeElement root, Object tpl) {
            if (root.children == null) {
                return null;
            }
            for (MyTreeElement elem : root.children) {
                if (tpl == null && elem.templateFile == null) {
                    return elem;
                }
                if (tpl == null && elem.templateFile != null || !tpl.equals(elem.templateFile)) continue;
                return elem;
            }
            return null;
        }

        MyTreeElement[] getChildren() {
            if (this.children == null) {
                return null;
            }
            MyTreeElement[] ret = this.children.toArray(new MyTreeElement[this.children.size()]);
            return ret;
        }

        private void addChild(MyTreeElement child) {
            if (child == null) {
                return;
            }
            child.parent = this;
            this.children.add(child);
        }

        MyTreeElement getParent() {
            return this.parent;
        }

        Object getTemplate() {
            return this.templateFile;
        }

        FileModelProxy getFileModelProxy() {
            return this.proxy;
        }

        public boolean isTPLElement() {
            return this.isTPLElement;
        }
    }
}

