/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import java.util.Enumeration;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.contentproperties.HTMLContentProperties;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.ResourceUtil;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HeaderModifier {
    private static final String MIME_TYPE_HTML = "text/html";
    private static final String MIME_TYPE_CSS = "text/css";
    private static final String META_TAG = "META";
    private static final String XMLNS_ATTR = "xmlns";
    private static final String CONTENT_ATTR = "content";
    private static final String HTTPEQUIV_ATTR = "http-equiv";
    private static final String NAME_ATTR = "name";
    private static final String CHARSET_VALUE = "charset";
    private static final String CHARSET_VALUE_WITHEQUAL = "charset=";
    private static final String CONTENTTYPE_VALUE = "Content-Type";
    private static final String CONTENTTYPE_VALUE_WITHDQUOTE = "\"Content-Type\"";
    private static final String CONTENTSTYLETYPE_VALUE = "Content-Style-Type";
    private static final String NAME_VALUE = "GENERATOR";
    private static final String PD_DEV_NAME_VALUE = "IBM:DeviceType";
    private static final String BASE_TAG = "BASE";
    private static final String HREF_ATTR = "href";
    private static final String HTML_TAG = "HTML";
    private static final String HEAD_TAG = "HEAD";
    private static final String TITLE_TAG = "TITLE";
    private static final String SCRIPT_TAG = "SCRIPT";
    private static final String SCRIPT_SRC_ATTR = "src";
    private static final char SEMICOLON_CHAR = ';';
    private static final char SPACE_CHAR = ' ';
    private static final char EQUAL_CHAR = '=';
    private static final char DQUOTE_CHAR = '\"';
    private static final char SQUOTE_CHAR = '\'';
    private static final char LEFTBRACKET_CHAR = '<';
    private static final char RIGHTBRACKET_CHAR = '>';
    private static final char TAB_CHAR = '\t';
    private static final char SLASH_CHAR = '/';

    public static boolean addCharset(IStructuredModel structuredModel, String encodingLabel, boolean overwrite) {
        String workbenchEncoding;
        if ((encodingLabel == null || encodingLabel.trim().length() == 0) && (encodingLabel = CommonCharsetNames.getIanaPreferredCharsetName((String)(workbenchEncoding = ResourcesPlugin.getEncoding()))) == null) {
            encodingLabel = workbenchEncoding;
        }
        if (encodingLabel == null || encodingLabel.trim().length() == 0) {
            return false;
        }
        if (ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return HeaderModifier.addCharsetToHTML(structuredModel, encodingLabel, overwrite);
        }
        if (ContentTypeIdForCSS.ContentTypeID_CSS.equals(structuredModel.getContentTypeIdentifier())) {
            return HeaderModifier.addCharsetToCSS(structuredModel, encodingLabel, overwrite);
        }
        return false;
    }

    public void addCharsetAndBase(IStructuredDocument flatModel, IPath orgDocPath, String encodingLabel, boolean needChangeEncoding, boolean needChangeBase, boolean isXHTML) {
        String _RIGHTBRACKET;
        IStructuredDocumentRegion[] nodes = flatModel.getStructuredDocumentRegions();
        IStructuredDocumentRegion charsetNode = null;
        String charsetString = null;
        int charsetStringPos = -1;
        boolean charsetNodeIsDone = false;
        IStructuredDocumentRegion htmlNode = null;
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion baseNode = null;
        String baseHrefString = null;
        int baseHrefPos = -1;
        boolean baseNodeIsDone = false;
        IStructuredDocumentRegion endBaseNode = null;
        boolean endBaseTagPresent = false;
        IStructuredDocumentRegion scriptNode = null;
        int index = 0;
        while (index < nodes.length) {
            IStructuredDocumentRegion node = nodes[index];
            if ("XML_TAG_NAME" == node.getType()) {
                ITextRegionList regions = node.getRegions();
                boolean startTag = false;
                boolean metaTag = false;
                boolean httpequivAttr = false;
                boolean contentAttr = false;
                String contentValue = null;
                int contentValuePos = -1;
                boolean baseTag = false;
                boolean hrefAttr = false;
                String hrefValue = null;
                int hrefValuePos = -1;
                boolean scriptTag = false;
                boolean srcAttr = false;
                int srcValuePos = -1;
                int srcValueLength = -1;
                boolean endTag = false;
                int i = 0;
                while (i < regions.size()) {
                    String tagName;
                    ITextRegion region = regions.get(i);
                    if ("XML_TAG_OPEN" == region.getType()) {
                        startTag = true;
                    }
                    if ("XML_END_TAG_OPEN" == region.getType()) {
                        startTag = false;
                        endTag = true;
                    }
                    if (startTag && "XML_TAG_NAME" == region.getType()) {
                        tagName = node.getText(region);
                        metaTag = tagName.compareToIgnoreCase(META_TAG) == 0;
                        httpequivAttr = false;
                        contentAttr = false;
                        contentValue = null;
                        contentValuePos = -1;
                        if (tagName.compareToIgnoreCase(HTML_TAG) == 0 && htmlNode == null) {
                            htmlNode = node;
                        }
                        if (tagName.compareToIgnoreCase(HEAD_TAG) == 0 && headNode == null) {
                            headNode = node;
                        }
                        if (tagName.compareToIgnoreCase(SCRIPT_TAG) == 0) {
                            scriptTag = true;
                            if (scriptNode == null) {
                                scriptNode = node;
                            }
                        } else {
                            scriptTag = false;
                        }
                        srcAttr = false;
                        srcValuePos = -1;
                        if (tagName.compareToIgnoreCase(BASE_TAG) == 0) {
                            baseTag = true;
                            if (baseNode == null) {
                                baseNode = node;
                            }
                        } else {
                            baseTag = false;
                        }
                        hrefAttr = false;
                        hrefValue = null;
                        hrefValuePos = -1;
                    }
                    if (endTag && "XML_TAG_NAME" == region.getType() && (tagName = node.getText(region)).compareToIgnoreCase(BASE_TAG) == 0) {
                        endBaseNode = node;
                        endBaseTagPresent = true;
                    }
                    if (startTag && "XML_TAG_ATTRIBUTE_NAME" == region.getType()) {
                        String attributeName = node.getText(region);
                        if (metaTag) {
                            httpequivAttr = false;
                            contentAttr = false;
                            if (attributeName.compareToIgnoreCase(HTTPEQUIV_ATTR) == 0) {
                                httpequivAttr = true;
                            } else if (attributeName.compareToIgnoreCase(CONTENT_ATTR) == 0) {
                                contentAttr = true;
                            }
                        } else if (baseTag) {
                            hrefAttr = false;
                            if (attributeName.compareToIgnoreCase(HREF_ATTR) == 0) {
                                hrefAttr = true;
                            }
                        } else if (scriptTag) {
                            srcAttr = false;
                            if (attributeName.compareToIgnoreCase(SCRIPT_SRC_ATTR) == 0) {
                                srcAttr = true;
                            }
                        }
                    }
                    if (startTag && "XML_TAG_ATTRIBUTE_VALUE" == region.getType()) {
                        String attributeValue = node.getText(region);
                        if (metaTag) {
                            if (httpequivAttr) {
                                if ((attributeValue.compareToIgnoreCase(CONTENTTYPE_VALUE) == 0 || attributeValue.compareToIgnoreCase(CONTENTTYPE_VALUE_WITHDQUOTE) == 0) && charsetNode == null) {
                                    charsetNode = node;
                                }
                            } else if (contentAttr) {
                                contentValue = attributeValue;
                                contentValuePos = region.getStart();
                            }
                        } else if (baseTag) {
                            if (hrefAttr) {
                                hrefValue = attributeValue;
                                hrefValuePos = region.getStart();
                            }
                        } else if (scriptTag && srcAttr) {
                            String[] dojoJSlibs = new String[]{"dojo.js", "dojo.js.uncompressed.js"};
                            boolean foundDojo = false;
                            if (!attributeValue.contains("http:")) {
                                String[] stringArray = dojoJSlibs;
                                int n = dojoJSlibs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String dojoJS = stringArray[n2];
                                    if (attributeValue.contains(dojoJS)) {
                                        foundDojo = true;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if (foundDojo) {
                                srcValuePos = node.getStart();
                                srcValueLength = region.getStart() + 1;
                                String strInsertAbsoluteWebContentFolder = new FileURL(orgDocPath.removeLastSegments(1).addTrailingSeparator()).getURL();
                                flatModel.replaceText((Object)this, srcValuePos + srcValueLength, 0, strInsertAbsoluteWebContentFolder);
                            }
                        }
                    }
                    ++i;
                }
                if (charsetNode != null && !charsetNodeIsDone) {
                    charsetString = contentValue;
                    charsetStringPos = contentValuePos;
                    charsetNodeIsDone = true;
                }
                if (baseNode != null && !baseNodeIsDone) {
                    baseHrefString = hrefValue;
                    baseHrefPos = hrefValuePos;
                    baseNodeIsDone = true;
                }
            }
            if (charsetNode != null && htmlNode != null && headNode != null && baseNode != null) break;
            ++index;
        }
        String defDelimiter = HeaderModifier.determineLineDelimiter(new StringBuffer(flatModel.getText()), flatModel.getLegalLineDelimiters(), System.getProperty("line.separator"));
        String headString = null;
        String _META_TAG = isXHTML ? META_TAG.toLowerCase(Locale.US) : META_TAG;
        String string = _RIGHTBRACKET = isXHTML ? String.valueOf(String.valueOf('/')) + '>' : String.valueOf('>');
        if (needChangeEncoding) {
            if (encodingLabel == null) {
                if (charsetNode != null) {
                    flatModel.replaceText((Object)this, charsetNode.getStart(), charsetNode.getLength(), null);
                }
            } else if (charsetNode != null) {
                int orgPos = charsetNode.getStart();
                int orgLength = charsetNode.getLength();
                if (charsetString != null && charsetStringPos != -1) {
                    int charsetPos = charsetString.indexOf(CHARSET_VALUE_WITHEQUAL);
                    if (charsetPos != -1) {
                        int spacepos = charsetString.indexOf(32, charsetPos += CHARSET_VALUE_WITHEQUAL.length());
                        int tabpos = charsetString.indexOf(9, charsetPos);
                        int endpos = charsetString.indexOf(62, charsetPos);
                        int dquotepos = charsetString.indexOf(34, charsetPos);
                        int squotepos = charsetString.indexOf(39, charsetPos);
                        if (spacepos == -1 && tabpos == -1 && endpos == -1 && dquotepos == -1 && squotepos == -1) {
                            String metaWithCharset = String.valueOf('<') + _META_TAG + ' ' + CONTENT_ATTR + '=' + '\"' + MIME_TYPE_HTML + ';' + ' ' + CHARSET_VALUE_WITHEQUAL + encodingLabel + '\"' + ' ' + HTTPEQUIV_ATTR + '=' + CONTENTTYPE_VALUE_WITHDQUOTE + _RIGHTBRACKET;
                            flatModel.replaceText((Object)this, orgPos, orgLength, metaWithCharset);
                        } else {
                            int endcharPos = spacepos;
                            if (endcharPos < tabpos) {
                                endcharPos = tabpos;
                            }
                            if (endcharPos < endpos) {
                                endcharPos = endpos;
                            }
                            if (endcharPos < dquotepos) {
                                endcharPos = dquotepos;
                            }
                            if (endcharPos < squotepos) {
                                endcharPos = squotepos;
                            }
                            flatModel.replaceText((Object)this, orgPos + charsetStringPos + charsetPos, endcharPos - charsetPos, encodingLabel);
                        }
                    } else {
                        charsetPos = charsetString.charAt(charsetString.length() - 1) == '\"' || charsetString.charAt(charsetString.length() - 1) == '\'' ? charsetString.length() - 1 : charsetString.length();
                        String targetString = ";";
                        if (charsetString.indexOf(MIME_TYPE_HTML) == -1) {
                            targetString = String.valueOf(targetString) + "text/html; ";
                        }
                        String onlyCharsetString = CHARSET_VALUE_WITHEQUAL + encodingLabel;
                        targetString = String.valueOf(targetString) + onlyCharsetString;
                        flatModel.replaceText((Object)this, orgPos + charsetStringPos + charsetPos, 0, targetString);
                    }
                } else {
                    String targetString = " content=\"text/html; charset=" + encodingLabel + '\"';
                    flatModel.replaceText((Object)this, orgPos + orgLength - 1, 0, targetString);
                }
            } else {
                String metaWithCharset = String.valueOf(defDelimiter) + '<' + _META_TAG + ' ' + CONTENT_ATTR + '=' + '\"' + MIME_TYPE_HTML + ';' + ' ' + CHARSET_VALUE_WITHEQUAL + encodingLabel + '\"' + ' ' + HTTPEQUIV_ATTR + '=' + CONTENTTYPE_VALUE_WITHDQUOTE + _RIGHTBRACKET;
                headString = headString != null ? String.valueOf(headString) + metaWithCharset : metaWithCharset;
            }
        }
        if (needChangeBase) {
            FileURL orgFileURL = new FileURL(orgDocPath);
            String baseURL = orgFileURL.getURL();
            if (baseNode != null) {
                int orgPos = baseNode.getStart();
                int orgLength = baseNode.getLength();
                if (baseHrefString != null && baseHrefPos != -1) {
                    int endPos;
                    int startPos;
                    char sepChar = baseHrefString.charAt(0);
                    if (sepChar == '\'' || sepChar == '\"') {
                        startPos = 1;
                        endPos = baseHrefString.indexOf(sepChar, startPos);
                    } else {
                        startPos = 0;
                        endPos = -1;
                        int spacepos = baseHrefString.indexOf(32, startPos);
                        int tabpos = baseHrefString.indexOf(9, startPos);
                        if (spacepos != -1) {
                            endPos = spacepos;
                        }
                        if (tabpos != -1 && tabpos < endPos) {
                            endPos = tabpos;
                        }
                    }
                    if (endPos == -1) {
                        endPos = baseHrefString.length();
                    }
                    flatModel.replaceText((Object)this, orgPos + baseHrefPos + startPos, endPos - startPos, baseURL);
                } else {
                    String targetString = " href=\"" + baseURL + '\"';
                    flatModel.replaceText((Object)this, orgPos + orgLength - 1, 0, targetString);
                }
            } else {
                String _BASE_TAG = isXHTML ? BASE_TAG.toLowerCase(Locale.US) : BASE_TAG;
                String base = String.valueOf(defDelimiter) + '<' + _BASE_TAG + ' ' + HREF_ATTR + '=' + '\"' + baseURL + '\"' + _RIGHTBRACKET + '<' + '/' + _BASE_TAG + '>';
                headString = headString != null ? String.valueOf(headString) + base : base;
                endBaseTagPresent = true;
            }
        }
        if (!(baseNode == null || endBaseNode != null && endBaseTagPresent)) {
            String _BASE_TAG = isXHTML ? BASE_TAG.toLowerCase(Locale.US) : BASE_TAG;
            int orgPos = baseNode.getStart();
            int orgLength = baseNode.getLength();
            String endBaseTag = String.valueOf(Character.toString('<')) + Character.toString('/') + _BASE_TAG + '>';
            flatModel.replaceText((Object)this, orgPos + orgLength, 0, endBaseTag);
        }
        if (headString != null) {
            String targetString;
            int insertPos = 0;
            int orgTargetLength = 0;
            boolean needCreateHead = false;
            if (headNode == null) {
                insertPos = htmlNode != null ? htmlNode.getStart() + htmlNode.getLength() : 0;
                orgTargetLength = 0;
                needCreateHead = true;
            } else {
                insertPos = headNode.getStart() + headNode.getLength();
                orgTargetLength = 0;
            }
            if (needCreateHead) {
                String _HEAD_TAG = isXHTML ? HEAD_TAG.toLowerCase(Locale.US) : HEAD_TAG;
                targetString = String.valueOf(defDelimiter) + '<' + _HEAD_TAG + '>' + ' ' + headString + defDelimiter + '<' + '/' + _HEAD_TAG + '>';
            } else {
                targetString = headString;
            }
            flatModel.replaceText((Object)this, insertPos, orgTargetLength, targetString);
        }
    }

    private static String determineLineDelimiter(StringBuffer textBuffer, String[] possibles, String hint) {
        try {
            String text = textBuffer.toString();
            int[] info = TextUtilities.indexOf((String[])possibles, (String)text, (int)0);
            return possibles[info[1]];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return hint;
        }
    }

    private static boolean addCharsetToCSS(IStructuredModel structuredModel, String encodingLabel, boolean overwrite) {
        return false;
    }

    private static boolean addCharsetToHTML(IStructuredModel structuredModel, String encodingLabel, boolean overwrite) {
        Element metaTag;
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        Node headNode = HeaderModifier.findHeadNode(structuredModel);
        if (headNode == null) {
            return false;
        }
        boolean ret = false;
        boolean found = false;
        NodeList nl = doc.getElementsByTagName(META_TAG);
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                int offset;
                String attrValue;
                Node attrNode;
                NamedNodeMap attrNodes;
                Node metaNode = nl.item(i);
                if (metaNode != null && (attrNodes = metaNode.getAttributes()) != null && (attrNode = attrNodes.getNamedItem(HTTPEQUIV_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && attrValue.compareToIgnoreCase(CONTENTTYPE_VALUE) == 0 && (attrNode = attrNodes.getNamedItem(CONTENT_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && (offset = attrValue.toLowerCase(Locale.US).indexOf(MIME_TYPE_HTML)) != -1) {
                    offset += MIME_TYPE_HTML.length();
                    String STRING_SEMICOLON = new String(new char[]{';'});
                    if ((offset = attrValue.indexOf(STRING_SEMICOLON, offset)) != -1) {
                        offset += STRING_SEMICOLON.length();
                        String STRING_SPACE = new String(new char[]{' '});
                        if ((offset = attrValue.indexOf(STRING_SPACE, offset)) != -1) {
                            offset += STRING_SPACE.length();
                            offset = attrValue.toLowerCase(Locale.US).indexOf(CHARSET_VALUE_WITHEQUAL);
                            if (offset != -1) {
                                found = true;
                                String former = attrValue.substring(0, offset += CHARSET_VALUE_WITHEQUAL.length());
                                if (!overwrite) break;
                                ret = true;
                                attrNode.setNodeValue(String.valueOf(former) + encodingLabel);
                                break;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if (!found && (metaTag = doc.createElement(META_TAG)) != null) {
            metaTag.setAttribute(HTTPEQUIV_ATTR, CONTENTTYPE_VALUE);
            String contentValue = "text/html; charset=" + encodingLabel;
            metaTag.setAttribute(CONTENT_ATTR, contentValue);
            HeaderModifier.insertTagInHead(structuredModel, doc, headNode, metaTag);
            ret = true;
        }
        return ret;
    }

    public static boolean addContentStyleType(IStructuredModel structuredModel, boolean overwrite) {
        Element metaTag;
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return false;
        }
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        Node headNode = HeaderModifier.findHeadNode(structuredModel);
        if (headNode == null) {
            return false;
        }
        boolean ret = false;
        boolean found = false;
        NodeList nl = doc.getElementsByTagName(META_TAG);
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                String attrValue;
                Node attrNode;
                NamedNodeMap attrNodes;
                Node metaNode = nl.item(i);
                if (metaNode != null && (attrNodes = metaNode.getAttributes()) != null && (attrNode = attrNodes.getNamedItem(HTTPEQUIV_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && attrValue.compareToIgnoreCase(CONTENTSTYLETYPE_VALUE) == 0 && (attrNode = attrNodes.getNamedItem(CONTENT_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && attrValue.compareToIgnoreCase(MIME_TYPE_CSS) == 0) {
                    found = true;
                }
                ++i;
            }
        }
        if (!found && (metaTag = doc.createElement(META_TAG)) != null) {
            metaTag.setAttribute(HTTPEQUIV_ATTR, CONTENTSTYLETYPE_VALUE);
            metaTag.setAttribute(CONTENT_ATTR, MIME_TYPE_CSS);
            HeaderModifier.insertTagInHead(structuredModel, doc, headNode, metaTag);
            ret = true;
        }
        return ret;
    }

    public static boolean addDeviceType(IStructuredModel structuredModel, String deviceContent, boolean overwrite) {
        Element metaTag;
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return false;
        }
        if (deviceContent == null || deviceContent.length() == 0) {
            return false;
        }
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        Node headNode = HeaderModifier.findHeadNode(structuredModel);
        if (headNode == null) {
            return false;
        }
        boolean ret = false;
        boolean found = false;
        NodeList nl = doc.getElementsByTagName(META_TAG);
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                String attrValue;
                Node attrNode;
                NamedNodeMap attrNodes;
                Node metaNode = nl.item(i);
                if (metaNode != null && (attrNodes = metaNode.getAttributes()) != null && (attrNode = attrNodes.getNamedItem(NAME_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && attrValue.compareToIgnoreCase(PD_DEV_NAME_VALUE) == 0) {
                    Attr attr;
                    attrNode = attrNodes.getNamedItem(CONTENT_ATTR);
                    if (attrNode != null) {
                        attrValue = attrNode.getNodeValue();
                        if (attrValue != null) {
                            found = true;
                            if (overwrite) {
                                ret = true;
                                attrNode.setNodeValue(deviceContent);
                            }
                        }
                    } else if (overwrite && (attr = doc.createAttribute(CONTENT_ATTR)) != null) {
                        ret = true;
                        found = true;
                        attr.setValue(deviceContent);
                        attrNodes.setNamedItem(attr);
                    }
                }
                ++i;
            }
        }
        if (!found && (metaTag = doc.createElement(META_TAG)) != null) {
            metaTag.setAttribute(NAME_ATTR, PD_DEV_NAME_VALUE);
            metaTag.setAttribute(CONTENT_ATTR, deviceContent);
            HeaderModifier.insertTagInHead(structuredModel, doc, headNode, metaTag);
            ret = true;
        }
        return ret;
    }

    public static boolean addDoctype(IStructuredModel structuredModel, DocumentType documentType, boolean overwrite) {
        Node first;
        if (structuredModel == null || documentType == null) {
            return false;
        }
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return false;
        }
        IDOMModel model = (IDOMModel)structuredModel;
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return false;
        }
        if (document.isJSPDocument()) {
            HeaderModifier.addImplicitDocumentType(model, documentType);
            return false;
        }
        DocumentType currentDocumentType = document.getDoctype();
        if (currentDocumentType != null) {
            if (!overwrite) {
                return false;
            }
            if (currentDocumentType == documentType) {
                return false;
            }
            Node parent = currentDocumentType.getParentNode();
            if (parent != null) {
                parent.removeChild(currentDocumentType);
            }
        }
        if ((first = document.getFirstChild()) == null || first.getNodeType() != 3) {
            String newLine = structuredModel.getStructuredDocument().getLineDelimiter();
            if (newLine == null || newLine.length() == 0) {
                newLine = System.getProperty("line.separator");
            }
            Text text = document.createTextNode(newLine);
            first = document.insertBefore((Node)text, first);
        }
        document.insertBefore((Node)documentType, first);
        return true;
    }

    private static void addImplicitDocumentType(IDOMModel model, DocumentType documentType) {
        if (model == null || documentType == null) {
            return;
        }
        String publicId = documentType.getPublicId();
        if (publicId == null) {
            return;
        }
        IFile file = ResourceUtil.getFileFor((IStructuredModel)model);
        if (file == null) {
            return;
        }
        try {
            HTMLContentProperties.setProperty((String)"document-type", (IResource)file, (String)publicId);
        }
        catch (CoreException coreException) {}
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return;
        }
    }

    public static boolean addGenerator(IStructuredModel structuredModel, boolean overwrite) {
        Element metaTag;
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return false;
        }
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        Node headNode = HeaderModifier.findHeadNode(structuredModel);
        if (headNode == null) {
            return false;
        }
        boolean ret = false;
        boolean found = false;
        NodeList nl = doc.getElementsByTagName(META_TAG);
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                String attrValue;
                Node attrNode;
                NamedNodeMap attrNodes;
                Node metaNode = nl.item(i);
                if (metaNode != null && (attrNodes = metaNode.getAttributes()) != null && (attrNode = attrNodes.getNamedItem(NAME_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && attrValue.compareToIgnoreCase(NAME_VALUE) == 0) {
                    Attr attr;
                    attrNode = attrNodes.getNamedItem(CONTENT_ATTR);
                    if (attrNode != null) {
                        attrValue = attrNode.getNodeValue();
                        if (attrValue != null) {
                            found = true;
                            if (overwrite) {
                                ret = true;
                                attrNode.setNodeValue("IBM Software Development Platform");
                            }
                        }
                    } else if (overwrite && (attr = doc.createAttribute(CONTENT_ATTR)) != null) {
                        ret = true;
                        found = true;
                        attr.setValue("IBM Software Development Platform");
                        attrNodes.setNamedItem(attr);
                    }
                }
                ++i;
            }
        }
        if (!found && (metaTag = doc.createElement(META_TAG)) != null) {
            metaTag.setAttribute(NAME_ATTR, NAME_VALUE);
            metaTag.setAttribute(CONTENT_ATTR, "IBM Software Development Platform");
            HeaderModifier.insertTagInHead(structuredModel, doc, headNode, metaTag);
            ret = true;
        }
        return ret;
    }

    public static boolean addTitle(IStructuredModel structuredModel, String title, boolean overwrite) {
        Element titleTag;
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return false;
        }
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        Node headNode = HeaderModifier.findHeadNode(structuredModel);
        if (headNode == null) {
            return false;
        }
        boolean ret = false;
        NodeList nl = doc.getElementsByTagName(TITLE_TAG);
        if ((nl == null || nl.getLength() == 0) && (titleTag = doc.createElement(TITLE_TAG)) != null) {
            HeaderModifier.insertTagInHead(structuredModel, doc, headNode, titleTag);
            if (title != null) {
                Text text = doc.createTextNode(title);
                titleTag.appendChild(text);
            }
            ret = true;
        }
        return ret;
    }

    public static Node findHeadNode(IStructuredModel structuredModel) {
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return null;
        }
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        Element htmlNode = doc.getDocumentElement();
        if (htmlNode == null) {
            Element htmlTag = doc.createElement(HTML_TAG);
            String namespaceURI = HeaderModifier.getNamespaceURI(doc);
            if (namespaceURI != null) {
                htmlTag.setAttribute(XMLNS_ATTR, namespaceURI);
            }
            doc.appendChild((Node)htmlTag);
            htmlNode = htmlTag;
            if (htmlNode == null) {
                return null;
            }
        }
        NodeList nl = doc.getElementsByTagName(HEAD_TAG);
        Node headNode = null;
        if (nl == null || nl.getLength() <= 0) {
            String newLine = structuredModel.getStructuredDocument().getLineDelimiter();
            if (newLine == null || newLine.length() == 0) {
                newLine = System.getProperty("line.separator");
            }
            Text text1 = doc.createTextNode(newLine);
            Text text2 = doc.createTextNode(newLine);
            Element headTag = doc.createElement(HEAD_TAG);
            Node topNode = htmlNode.getFirstChild();
            if (topNode == null) {
                htmlNode.appendChild(text1);
                htmlNode.appendChild(headTag);
                htmlNode.appendChild(text2);
            } else {
                boolean needText = true;
                if (topNode.getNodeType() == 3) {
                    String topString;
                    Text text = (Text)topNode;
                    String content = text.getData();
                    int newLineLength = newLine.length();
                    if (content != null && content.length() >= newLineLength && (topString = content.substring(0, newLineLength)).compareTo(newLine) == 0) {
                        needText = false;
                    }
                }
                Node nextTop = null;
                nextTop = needText ? htmlNode.insertBefore(text2, topNode) : topNode;
                htmlNode.insertBefore(headTag, nextTop);
                htmlNode.insertBefore(text1, headTag);
            }
            headNode = headTag;
        } else {
            headNode = nl.item(0);
        }
        return headNode;
    }

    public static DocumentType getDocumentType(IDOMModel model, IDOMModel refModel, boolean hasFrameset) {
        String systemId;
        IDOMDocumentType documentType;
        String name;
        if (model == null) {
            return null;
        }
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        if (refModel == null) {
            String systemId2;
            DocumentTypeAdapter adapter = (DocumentTypeAdapter)document.getAdapterFor(DocumentTypeAdapter.class);
            if (adapter == null) {
                return null;
            }
            DocumentType targetDocumentType = adapter.getDocumentType();
            if (targetDocumentType == null) {
                return null;
            }
            if (targetDocumentType.getParentNode() != null) {
                return targetDocumentType;
            }
            String name2 = targetDocumentType.getName();
            IDOMDocumentType documentType2 = (IDOMDocumentType)document.createDoctype(name2);
            if (documentType2 == null) {
                return null;
            }
            String publicId = targetDocumentType.getPublicId();
            if (publicId != null) {
                documentType2.setPublicId(publicId);
            }
            if ((systemId2 = targetDocumentType.getSystemId()) != null) {
                documentType2.setSystemId(systemId2);
            }
            return documentType2;
        }
        IDOMDocument refDocument = refModel.getDocument();
        if (refDocument == null) {
            return null;
        }
        HTMLDocumentTypeRegistry reg = HTMLDocumentTypeRegistry.getInstance();
        HTMLDocumentTypeEntry refEntry = null;
        String refId = refDocument.getDocumentTypeId();
        if (refId != null) {
            refEntry = reg.getEntry(refId);
        }
        if (refEntry == null) {
            refEntry = reg.getDefaultEntry();
        }
        boolean isXMLType = refEntry.isXMLType();
        HTMLDocumentTypeEntry targetEntry = refEntry;
        if (hasFrameset) {
            if (!refEntry.hasFrameset()) {
                Enumeration e = reg.getEntries();
                while (e.hasMoreElements()) {
                    HTMLDocumentTypeEntry entry = (HTMLDocumentTypeEntry)e.nextElement();
                    if (!entry.hasFrameset() || entry.isXMLType() != isXMLType) continue;
                    targetEntry = entry;
                    break;
                }
            }
        } else if (refEntry.hasFrameset()) {
            String key = "Transitional";
            Enumeration e = reg.getEntries();
            while (e.hasMoreElements()) {
                String id;
                HTMLDocumentTypeEntry entry = (HTMLDocumentTypeEntry)e.nextElement();
                if (entry.isXMLType() != isXMLType || (id = entry.getPublicId()) == null || id.indexOf(key) < 0) continue;
                targetEntry = entry;
                break;
            }
        }
        if ((name = targetEntry.getName()) == null) {
            name = HTML_TAG;
        }
        if ((documentType = (IDOMDocumentType)document.createDoctype(name)) == null) {
            return null;
        }
        String publicId = targetEntry.getPublicId();
        if (publicId != null) {
            documentType.setPublicId(publicId);
        }
        if ((systemId = targetEntry.getSystemId()) != null) {
            documentType.setSystemId(systemId);
        }
        return documentType;
    }

    public static String getNamespaceURI(IDOMDocument document) {
        if (document == null) {
            return null;
        }
        String id = document.getDocumentTypeId();
        if (id == null) {
            return null;
        }
        HTMLDocumentTypeRegistry reg = HTMLDocumentTypeRegistry.getInstance();
        HTMLDocumentTypeEntry entry = reg.getEntry(id);
        if (entry == null) {
            return null;
        }
        return entry.getNamespaceURI();
    }

    private static void insertTagInHead(IStructuredModel structuredModel, IDOMDocument doc, Node headNode, Node metaNode) {
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return;
        }
        String newLine = structuredModel.getStructuredDocument().getLineDelimiter();
        if (newLine == null || newLine.length() == 0) {
            newLine = System.getProperty("line.separator");
        }
        Text text1 = doc.createTextNode(newLine);
        Text text2 = doc.createTextNode(newLine);
        Node lastMeta = null;
        Node node = headNode.getFirstChild();
        while (node != null) {
            String tagName;
            if (node.getNodeType() == 1 && (tagName = node.getNodeName()) != null && tagName.compareToIgnoreCase(META_TAG) == 0) {
                lastMeta = node;
            }
            node = node.getNextSibling();
        }
        Node lastNode = null;
        if (lastMeta == null) {
            lastNode = headNode.getLastChild();
        } else {
            lastNode = lastMeta.getNextSibling();
            if (lastNode == null) {
                lastNode = headNode.getLastChild();
            }
        }
        if (lastNode == null) {
            headNode.appendChild(text1);
            headNode.appendChild(metaNode);
            headNode.appendChild(text2);
        } else {
            Node nextToLastNode;
            boolean needText = true;
            if (lastNode.getNodeType() == 3) {
                String topString;
                Text text = (Text)lastNode;
                String content = text.getData();
                int newLineLength = newLine.length();
                if (content != null && content.length() >= newLineLength && (topString = content.substring(0, newLineLength)).compareTo(newLine) == 0) {
                    needText = false;
                }
            }
            if ((nextToLastNode = lastNode.getNextSibling()) == null) {
                if (needText) {
                    headNode.appendChild(text2);
                }
                headNode.appendChild(metaNode);
                headNode.appendChild(text1);
            } else {
                nextToLastNode = headNode.insertBefore(text2, nextToLastNode);
                nextToLastNode = headNode.insertBefore(metaNode, nextToLastNode);
                if (needText) {
                    nextToLastNode = headNode.insertBefore(text1, nextToLastNode);
                }
            }
        }
    }

    public static boolean removeDeviceType(IStructuredModel structuredModel) {
        if (!ModelManagerUtil.isHTMLFamily(structuredModel)) {
            return false;
        }
        IDOMModel xmlmodel = (IDOMModel)structuredModel;
        IDOMDocument doc = xmlmodel.getDocument();
        boolean ret = false;
        NodeList nl = doc.getElementsByTagName(META_TAG);
        if (nl != null) {
            int i = 0;
            while (i < nl.getLength()) {
                Node parentNode;
                String attrValue;
                Node attrNode;
                NamedNodeMap attrNodes;
                Node metaNode = nl.item(i);
                if (metaNode != null && (attrNodes = metaNode.getAttributes()) != null && (attrNode = attrNodes.getNamedItem(NAME_ATTR)) != null && (attrValue = attrNode.getNodeValue()) != null && attrValue.compareToIgnoreCase(PD_DEV_NAME_VALUE) == 0 && (parentNode = metaNode.getParentNode()) != null) {
                    Node prevNode = metaNode.getPreviousSibling();
                    Node nextNode = metaNode.getNextSibling();
                    String newLine = structuredModel.getStructuredDocument().getLineDelimiter();
                    if (newLine == null || newLine.length() == 0) {
                        newLine = System.getProperty("line.separator");
                    }
                    if (prevNode.getNodeType() == 3 && nextNode.getNodeType() == 3) {
                        int newLineLength = newLine.length();
                        Text prevText = (Text)prevNode;
                        String prevContent = prevText.getData();
                        Text nextText = (Text)nextNode;
                        String nextContent = nextText.getData();
                        if (prevContent != null && prevContent.length() == newLineLength && prevContent.compareTo(newLine) == 0 && nextContent != null && nextContent.length() == newLineLength && nextContent.compareTo(newLine) == 0) {
                            parentNode.removeChild(nextNode);
                        }
                    }
                    parentNode.removeChild(metaNode);
                    ret = true;
                }
                ++i;
            }
        }
        return ret;
    }

    public static String getHTMLBaseHref(IStructuredModel model) {
        Element e;
        String href;
        Node node;
        NodeList nl;
        IDOMModel xmlmodel;
        IDOMDocument xmldoc;
        if (model != null && model instanceof IDOMModel && (xmldoc = (xmlmodel = (IDOMModel)model).getDocument()) != null && (nl = xmldoc.getElementsByTagName(BASE_TAG)) != null && nl.getLength() > 0 && (node = nl.item(0)) instanceof Element && (href = (e = (Element)node).getAttribute(HREF_ATTR)) != null && href.trim().length() > 0) {
            return href.trim();
        }
        return null;
    }
}

