/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import com.ibm.etools.webedit.viewer.utils.HTMLModelChangeAdapter;
import com.ibm.etools.webedit.viewer.utils.IHTMLModelChangeListener;
import com.ibm.etools.webedit.viewer.utils.ITagLibChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

class HTMLModelChangeAdapterImpl
implements HTMLModelChangeAdapter {
    private static Class adapterCass = HTMLModelChangeAdapter.class;
    private static final String NODENAME_JSPROOT = "jsp:root";
    private static final String NODENAME_TAGLIB = "jsp:directive.taglib";
    private ListenerList taglibChangeListeners = null;
    private ListenerList modelChangeListeners = null;

    private void addAdapter(Node node) {
        INodeAdapter adapter = ((INodeNotifier)node).getExistingAdapter(HTMLModelChangeAdapter.class);
        if (adapter != null && adapter.equals(this)) {
            return;
        }
        ((INodeNotifier)node).addAdapter((INodeAdapter)this);
    }

    @Override
    public void addListener(IHTMLModelChangeListener listener) {
        if (this.modelChangeListeners == null) {
            this.modelChangeListeners = new ListenerList();
        }
        this.modelChangeListeners.add((Object)listener);
    }

    @Override
    public void addListener(ITagLibChangeListener listener) {
        if (this.taglibChangeListeners == null) {
            this.taglibChangeListeners = new ListenerList();
        }
        this.taglibChangeListeners.add((Object)listener);
    }

    private void attributeChanged(Node node, String attr) {
        if (this.modelChangeListeners != null) {
            Object[] listeners = this.modelChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IHTMLModelChangeListener)listeners[i]).attributeChanged(node, attr);
                ++i;
            }
        }
    }

    private void attributeRemoved(Node node, String attr) {
        if (this.modelChangeListeners != null) {
            Object[] listeners = this.modelChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IHTMLModelChangeListener)listeners[i]).attributeRemoved(node, attr);
                ++i;
            }
        }
    }

    private static boolean canContainElement(Node node) {
        if (node.getNodeType() == 9 || node.getNodeType() == 11 || node.getNodeType() == 5) {
            return true;
        }
        return node.getNodeType() == 1;
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(adapterCass);
    }

    static boolean isNodeToAdapt(Node node) {
        return HTMLModelChangeAdapterImpl.canContainElement(node);
    }

    private static Document getDocument(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    private void structureChanged(Node node) {
        DocumentTraversal tdoc = (DocumentTraversal)((Object)HTMLModelChangeAdapterImpl.getDocument(node));
        NodeIterator enm = tdoc.createNodeIterator(node, 1, null, false);
        do {
            if (!HTMLModelChangeAdapterImpl.isNodeToAdapt(node)) continue;
            this.addAdapter(node);
        } while ((node = enm.nextNode()) != null);
    }

    private void nodeAdded(Node node) {
        DocumentTraversal tdoc = (DocumentTraversal)((Object)HTMLModelChangeAdapterImpl.getDocument(node));
        NodeIterator enm = tdoc.createNodeIterator(node, 1, null, false);
        do {
            if (HTMLModelChangeAdapterImpl.isNodeToAdapt(node)) {
                this.addAdapter(node);
            }
            if (this.modelChangeListeners != null) {
                Object[] listeners = this.modelChangeListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((IHTMLModelChangeListener)listeners[i]).nodeAdded(node);
                    ++i;
                }
            }
            if (!node.getNodeName().equalsIgnoreCase(NODENAME_TAGLIB) && !node.getNodeName().equalsIgnoreCase(NODENAME_JSPROOT)) continue;
            this.taglibDirectiveChanged();
        } while ((node = enm.nextNode()) != null);
    }

    private void nodeRemoved(Node node) {
        DocumentTraversal tdoc = (DocumentTraversal)((Object)HTMLModelChangeAdapterImpl.getDocument(node));
        NodeIterator enm = tdoc.createNodeIterator(node, 1, null, false);
        if (node != null) {
            do {
                if (HTMLModelChangeAdapterImpl.isNodeToAdapt(node)) {
                    this.removeAdapter(node);
                }
                if (this.modelChangeListeners != null) {
                    Object[] listeners = this.modelChangeListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        ((IHTMLModelChangeListener)listeners[i]).nodeRemoved(node);
                        ++i;
                    }
                }
                if (!node.getNodeName().equalsIgnoreCase(NODENAME_TAGLIB) && !node.getNodeName().equalsIgnoreCase(NODENAME_JSPROOT)) continue;
                this.taglibDirectiveChanged();
            } while ((node = enm.nextNode()) != null);
        }
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Object[] listeners;
        if (notifier == null) {
            return;
        }
        if (this.modelChangeListeners != null) {
            listeners = this.modelChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IHTMLModelChangeListener)listeners[i]).beginNotification();
                ++i;
            }
        }
        switch (eventType) {
            case 2: {
                Node node;
                if (!(newValue instanceof Node) || (node = (Node)newValue).getNodeType() == 3) break;
                this.nodeAdded(node);
                break;
            }
            case 3: {
                Node node;
                if (!(oldValue instanceof Node) || (node = (Node)oldValue).getNodeType() == 3) break;
                this.nodeRemoved(node);
                break;
            }
            case 1: {
                Node node;
                if (changedFeature == null || !(changedFeature instanceof Attr)) break;
                String attr = ((Attr)changedFeature).getName();
                if (!(notifier instanceof Node) || (node = (Node)notifier).getNodeType() == 3) break;
                if (oldValue != null && newValue == null) {
                    this.attributeRemoved(node, attr);
                } else {
                    this.attributeChanged(node, attr);
                }
                if (!node.getNodeName().equalsIgnoreCase(NODENAME_TAGLIB) && !node.getNodeName().equalsIgnoreCase(NODENAME_JSPROOT)) break;
                this.taglibDirectiveChanged();
                break;
            }
            case 4: {
                Node node;
                if (!(notifier instanceof Node) || (node = (Node)notifier).getNodeType() == 3) break;
                this.structureChanged(node);
                break;
            }
        }
        if (this.modelChangeListeners != null) {
            listeners = this.modelChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IHTMLModelChangeListener)listeners[i]).endNotification();
                ++i;
            }
        }
    }

    private void removeAdapter(Node node) {
        INodeAdapter adapter = ((INodeNotifier)node).getExistingAdapter(HTMLModelChangeAdapter.class);
        if (adapter != null && adapter.equals(this)) {
            ((INodeNotifier)node).removeAdapter((INodeAdapter)this);
        }
    }

    @Override
    public void removeListener(IHTMLModelChangeListener listener) {
        if (this.modelChangeListeners != null && listener != null) {
            this.modelChangeListeners.remove((Object)listener);
            if (this.modelChangeListeners.size() == 0) {
                this.modelChangeListeners = null;
            }
        }
    }

    @Override
    public void removeListener(ITagLibChangeListener listener) {
        if (this.taglibChangeListeners != null && listener != null) {
            this.taglibChangeListeners.remove((Object)listener);
            if (this.taglibChangeListeners.size() == 0) {
                this.taglibChangeListeners = null;
            }
        }
    }

    private void taglibDirectiveChanged() {
        if (this.taglibChangeListeners != null) {
            Object[] listeners = this.taglibChangeListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITagLibChangeListener)listeners[i]).taglibDirectiveChanged();
                ++i;
            }
        }
    }
}

