/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.render.internal.figures.CssScrollingFigure;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;

public class FindPartUtil {
    public static EditPart findEditPartAt(Point point, EditPart root) {
        if (root == null) {
            return null;
        }
        point = new Point(point);
        ((GraphicalEditPart)root).getContentPane().translateToRelative((Translatable)point);
        return FindPartUtil.findEditPartWithRootRelative(point, root);
    }

    private static EditPart findEditPartWithRootRelative(Point point, EditPart root) {
        IFigure figure = ((GraphicalEditPart)root).getFigure();
        if (figure instanceof CssScrollingFigure) {
            if (!figure.containsPoint(point)) {
                return null;
            }
            if (!((CssScrollingFigure)figure).containsPointInContentArea(point)) {
                return root;
            }
        }
        if (PartAnalyzer.getDisplayType(root) == 10 || PartAnalyzer.getDisplayType(root) == 11) {
            return null;
        }
        Iterator itr = root.getChildren().iterator();
        while (itr.hasNext()) {
            EditPart found = FindPartUtil.findEditPartWithRootRelative(point, (EditPart)itr.next());
            if (found == null) continue;
            return found;
        }
        return figure.containsPoint(point) ? root : null;
    }
}

