/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.utils;

import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.links.util.URI;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamespace;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomTagUtil {
    public static InputStream getSmallIconImage(Element element) {
        if (element == null) {
            return null;
        }
        String uri = CustomTagUtil.getURI(element);
        if (uri == null) {
            return null;
        }
        String smallIcon = CustomTagUtil.getSmallIcon(element);
        if (smallIcon == null) {
            return null;
        }
        IDOMNode node = (IDOMNode)element;
        IDOMModel model = node.getModel();
        return CustomTagUtil.getIconInputStream(ModelManagerUtil.getBaseLocation((IStructuredModel)model), uri, smallIcon);
    }

    public static Image getIconImage(String baseLocation, String uri, String icon, Device device) {
        if (uri == null || icon == null || device == null) {
            return null;
        }
        InputStream is = CustomTagUtil.getIconInputStream(baseLocation, uri, icon);
        if (is == null) {
            return null;
        }
        Image image = new Image(device, is);
        return image;
    }

    private static String getURI(Element element) {
        ModelQuery query = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (query == null) {
            return null;
        }
        CMDocument cmdoc = query.getCorrespondingCMDocument((Node)element);
        if (cmdoc == null) {
            return null;
        }
        CMNamespace cmns = cmdoc.getNamespace();
        if (cmns == null) {
            return null;
        }
        return cmns.getURI();
    }

    private static String getSmallIcon(Element element) {
        ModelQuery query = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (query == null) {
            return null;
        }
        CMElementDeclaration decl = query.getCMElementDeclaration(element);
        if (decl != null && decl instanceof CMNodeWrapper) {
            TLDElementDeclaration d;
            CMNode n = ((CMNodeWrapper)decl).getOriginNode();
            try {
                d = (TLDElementDeclaration)n;
            }
            catch (ClassCastException classCastException) {
                d = null;
            }
            if (d != null) {
                return d.getSmallIcon();
            }
        }
        return null;
    }

    private static InputStream getIconInputStream(String baseLocation, String uri, String icon) {
        if (baseLocation == null || uri == null || icon == null) {
            return null;
        }
        ITaglibRecord record = TaglibIndex.resolve((String)baseLocation, (String)uri, (boolean)false);
        if (record == null) {
            return null;
        }
        if (record.getRecordType() == 4) {
            Path jarPath = new Path(((IURLRecord)record).getBaseLocation());
            File jarFile = jarPath.toFile();
            if (!jarFile.exists()) {
                return null;
            }
            try {
                IPath jarRoot = jarPath.removeLastSegments(1);
                class TaglibJarURLConnection
                extends JarURLConnection {
                    TaglibJarURLConnection(URL url) throws MalformedURLException {
                        super(url);
                    }

                    @Override
                    public JarFile getJarFile() throws IOException {
                        return null;
                    }

                    @Override
                    public void connect() throws IOException {
                    }
                }
                TaglibJarURLConnection conn = new TaglibJarURLConnection(((IURLRecord)record).getURL());
                IPath absTldPath = jarRoot.append(conn.getEntryName());
                String absIconPath = LinkUtil.getAbsURL(absTldPath, absTldPath, icon, false);
                String iconPath = CustomTagUtil.makeDocRootRelative(absIconPath, jarRoot.toString(), null);
                return iconPath != null ? JarUtilities.getInputStream((String)jarPath.toString(), (String)iconPath) : null;
            }
            catch (MalformedURLException e) {
                Logger.log(e);
            }
        } else if (record.getRecordType() == 1) {
            IPath tldPath = ((ITLDRecord)record).getPath();
            IFile tldFile = ResourcesPlugin.getWorkspace().getRoot().getFile(tldPath);
            if (!tldFile.exists()) {
                return null;
            }
            String iconPath = LinkUtil.getAbsURL(tldPath, tldPath, icon, false);
            if (iconPath == null) {
                return null;
            }
            File file = new Path(iconPath).toFile();
            if (file.exists()) {
                try {
                    FileInputStream is = new FileInputStream(file);
                    return is;
                }
                catch (FileNotFoundException e) {
                    Logger.log(e);
                }
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sameDevices(IPath path1, IPath path2) {
        device1 = path1.getDevice();
        device2 = path2.getDevice();
        if (device1 == null && device2 == null) {
            return true;
        }
        if (device1 != null && device2 != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            device1 = device1.substring(1);
lbl8:
            // 2 sources

            ** while (device1.length() > 0 && device1.charAt((int)0) == '/')
        }
lbl9:
        // 2 sources

        while (device2.length() > 0 && device2.charAt(0) == '/') {
            device2 = device2.substring(1);
        }
        return device1.toLowerCase().equals(device2.toLowerCase());
    }

    public static String makeDocRootRelative(String absoluteLink, String docRoot, String serverContextRoot) {
        if (absoluteLink == null || absoluteLink.length() == 0) {
            if (absoluteLink != null) {
                return absoluteLink;
            }
            return "";
        }
        String protocol = URI.getOnlyScheme((String)absoluteLink).toLowerCase();
        if (!"".equals(protocol) && !"file".equals(protocol)) {
            return null;
        }
        IPath filePath = null;
        FileURL fileURL = null;
        try {
            fileURL = new FileURL(absoluteLink);
        }
        catch (InvalidURLException invalidURLException) {
            fileURL = new FileURL((IPath)new Path(absoluteLink));
        }
        filePath = fileURL.getPath().makeRelative();
        IPath docRootPath = new Path(docRoot).makeRelative();
        if (!CustomTagUtil.sameDevices(filePath, docRootPath)) {
            return null;
        }
        int docRootSegments = docRootPath.matchingFirstSegments(filePath);
        if (docRootSegments == docRootPath.segmentCount()) {
            filePath = filePath.removeFirstSegments(docRootSegments);
            if (serverContextRoot != null && serverContextRoot.length() > 0) {
                Path serverContextRootIPath = new Path(serverContextRoot);
                IPath webAppPath = serverContextRootIPath.makeAbsolute();
                filePath = filePath.setDevice(null);
                filePath = webAppPath.append(filePath);
            }
            return filePath.setDevice(null).makeAbsolute().toString();
        }
        return null;
    }
}

