/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.thumbnails;

import com.ibm.etools.webedit.editparts.DocumentEditPart;
import com.ibm.etools.webedit.editparts.HTMLGraphicalViewerImpl;
import com.ibm.etools.webedit.editparts.PartAnalyzer;
import com.ibm.etools.webedit.editparts.design.DesignTimeTagManager;
import com.ibm.etools.webedit.imagetool.internal.filter.ResizeOp;
import com.ibm.etools.webedit.imagetool.internal.filter.TransformOp;
import com.ibm.etools.webedit.imagetool.internal.image.HandyImage;
import com.ibm.etools.webedit.imagetool.internal.image.RasterImage;
import com.ibm.etools.webedit.render.internal.style.extended.HTMLStyleFactoryImpl;
import com.ibm.etools.webedit.render.internal.style.extended.WMLStyleFactoryImpl;
import com.ibm.etools.webedit.render.style.ViewOption;
import com.ibm.etools.webedit.viewer.DefaultViewOption;
import com.ibm.etools.webedit.viewer.internal.HTMLViewPartFactory;
import com.ibm.etools.webedit.viewer.internal.ThumbnailUpdateManager;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.xve.renderer.style.ImageObjectFactory;
import com.ibm.etools.xve.renderer.style.XMLStyleFactory;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLThumbnail
extends HTMLGraphicalViewerImpl {
    private HTMLViewPartFactory viewFactory = new HTMLViewPartFactory();
    private int DEFAULT_WIDTH = 500;
    private int DEFAULT_HEIGHT = 500;
    private Image image;
    private GC imageGC;
    private int width = 500;
    private int height = 500;
    private int targetWidth = 100;
    private int targetHeight = 100;
    private int clipWidth = this.width;
    private int clipHeight = this.height;
    private boolean clip = true;
    private DefaultViewOption option = new DefaultViewOption();
    private Shell dummyShell;
    private Canvas dummyCanvas;

    static {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ColorConstants.buttonLightest.getBlue();
            }
        });
    }

    public HTMLThumbnail() {
        super("PageDesigner");
    }

    @Override
    protected LightweightSystem createLightweightSystem() {
        return new LightweightSystem(){

            protected void init() {
                this.setUpdateManager((UpdateManager)new ThumbnailUpdateManager());
                super.init();
            }
        };
    }

    protected void disposeImages() {
        if (this.imageGC != null) {
            this.imageGC.dispose();
            this.imageGC = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void dispose() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (HTMLThumbnail.this.dummyShell != null && !HTMLThumbnail.this.dummyShell.isDisposed()) {
                    HTMLThumbnail.this.dummyShell.dispose();
                }
            }
        };
        this.syncExec(runnable);
    }

    @Override
    protected void handleDispose(DisposeEvent e) {
        this.viewFactory.dispose();
        this.disposeImages();
        super.handleDispose(e);
    }

    private int getTargetWidth() {
        return this.targetWidth > 0 ? this.targetWidth : this.clipWidth;
    }

    private int getTargetHeight() {
        return this.targetHeight > 0 ? this.targetHeight : this.clipHeight;
    }

    public void setModel(IDOMModel newModel) {
        this.viewFactory.setModel(newModel);
        this.setupViewPart();
    }

    public void setFile(String filename) {
        this.viewFactory.setFile(filename);
        this.setupViewPart();
    }

    public void setURL(URL url) {
        this.viewFactory.setURL(url);
        this.setupViewPart();
    }

    protected void replaceModel(IDOMModel newModel) {
        this.viewFactory.replaceModel(newModel);
        this.setupViewPart();
    }

    private void setupViewPart() {
        final EditPart editPart = this.viewFactory.getViewPart();
        if (editPart != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (HTMLThumbnail.this.dummyCanvas == null) {
                        HTMLThumbnail.this.dummyShell = new Shell(Display.getDefault());
                        HTMLThumbnail.this.dummyCanvas = (Canvas)HTMLThumbnail.this.createControl((Composite)HTMLThumbnail.this.dummyShell);
                    }
                    HTMLThumbnail.this.option.setNeedsEncoding(HTMLThumbnail.this.calculateNeedsEncoding(HTMLThumbnail.this.viewFactory.getModel()));
                    HTMLThumbnail.this.setContents(editPart);
                }
            };
            this.syncExec(runnable);
        }
    }

    public IDOMModel getModel() {
        return this.viewFactory.getModel();
    }

    protected DocumentEditPart getDocumentEditPart() {
        EditPart editPart = this.viewFactory.getViewPart();
        if (editPart != null && editPart instanceof DocumentEditPart) {
            return (DocumentEditPart)editPart;
        }
        return null;
    }

    public void draw(Graphics graphics, int x, int y) {
        this.refreshThumbnailImage();
        if (this.image != null) {
            Image targetimage = this.image;
            if (this.getTargetWidth() != this.clipWidth || this.getTargetHeight() != this.clipHeight) {
                targetimage = this.resizeImage(this.image);
            }
            org.eclipse.swt.graphics.Rectangle imageRect = targetimage.getBounds();
            graphics.drawImage(targetimage, 0, 0, imageRect.width, imageRect.height, x, y, this.getTargetWidth(), this.getTargetHeight());
            if (targetimage != this.image) {
                targetimage.dispose();
            }
        }
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, true);
    }

    private void draw(GC gc, int x, int y, boolean refresh) {
        if (refresh) {
            this.refreshThumbnailImage();
        }
        if (this.image != null) {
            Image targetimage = this.image;
            if (this.getTargetWidth() != this.clipWidth || this.getTargetHeight() != this.clipHeight) {
                targetimage = this.resizeImage(this.image);
            }
            org.eclipse.swt.graphics.Rectangle imageRect = targetimage.getBounds();
            gc.drawImage(targetimage, 0, 0, imageRect.width, imageRect.height, x, y, this.getTargetWidth(), this.getTargetHeight());
            if (targetimage != this.image) {
                targetimage.dispose();
            }
        }
    }

    private Image getImage(int imageWidth, int imageHeight) {
        if (this.image == null || imageWidth != this.clipWidth || imageHeight != this.clipHeight) {
            block4: {
                try {
                    this.image = new Image((Device)Display.getCurrent(), imageWidth, imageHeight);
                }
                catch (SWTError e) {
                    if (e.code != 2) break block4;
                    imageWidth = this.DEFAULT_WIDTH;
                    imageHeight = this.DEFAULT_HEIGHT;
                    this.image = new Image((Device)Display.getCurrent(), imageWidth, imageHeight);
                }
            }
            this.clipWidth = imageWidth;
            this.clipHeight = imageHeight;
            if (this.imageGC != null) {
                this.imageGC.dispose();
                this.imageGC = null;
            }
        }
        return this.image;
    }

    private GC getImageGC(int imageWidth, int imageHeight) {
        Image img;
        if (this.imageGC != null) {
            this.imageGC.dispose();
            this.imageGC = null;
        }
        if ((this.imageGC == null || imageWidth != this.clipWidth || imageHeight != this.clipHeight) && (img = this.getImage(imageWidth, imageHeight)) != null) {
            this.imageGC = new GC((Drawable)img);
        }
        if (this.imageGC != null) {
            Color org = this.imageGC.getBackground();
            this.imageGC.setBackground(Display.getCurrent().getSystemColor(25));
            this.imageGC.setClipping(0, 0, imageWidth, imageHeight);
            this.imageGC.fillRectangle(0, 0, imageWidth, imageHeight);
            this.imageGC.setBackground(org);
        }
        return this.imageGC;
    }

    @Override
    public ImageObjectFactory getImageObjectFactory() {
        return this;
    }

    public ImageData getPageImageData() {
        this.refreshThumbnailImage();
        if (this.image == null) {
            return null;
        }
        return this.image.getImageData();
    }

    public Image getTargetImage() {
        ImageData imagedata = this.getTargetImageData();
        if (imagedata == null) {
            return null;
        }
        Image img = new Image(null, imagedata);
        return img;
    }

    public ImageData getTargetImageData() {
        this.refreshThumbnailImage();
        Image target = new Image((Device)Display.getCurrent(), this.getTargetWidth(), this.getTargetHeight());
        GC gc = new GC((Drawable)target);
        this.draw(gc, 0, 0, false);
        ImageData data = target.getImageData();
        gc.dispose();
        target.dispose();
        return data;
    }

    @Override
    public ViewOption getViewOption() {
        return this.option;
    }

    private void refreshThumbnailImage() {
        EditPart ep = this.viewFactory.getViewPart();
        if (ep == null || !(ep instanceof DocumentEditPart)) {
            return;
        }
        DocumentEditPart viewPart = (DocumentEditPart)ep;
        viewPart.setFigureSize(this.width, this.height);
        final IFigure fig = viewPart.getFigure();
        fig.revalidate();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int h;
                int w;
                fig.validate();
                Rectangle bounds = fig.getBounds();
                if (HTMLThumbnail.this.clip) {
                    w = HTMLThumbnail.this.width > 0 ? HTMLThumbnail.this.width : bounds.width;
                    h = HTMLThumbnail.this.height > 0 ? HTMLThumbnail.this.height : bounds.height;
                } else {
                    w = bounds.width;
                    h = bounds.height;
                    if (w >= h) {
                        h = HTMLThumbnail.this.width > 0 && HTMLThumbnail.this.height > 0 ? w * HTMLThumbnail.this.height / HTMLThumbnail.this.width : w;
                    } else {
                        w = HTMLThumbnail.this.width > 0 && HTMLThumbnail.this.height > 0 ? h * HTMLThumbnail.this.width / HTMLThumbnail.this.height : h;
                    }
                }
                GC imgGC = HTMLThumbnail.this.getImageGC(w, h);
                if (imgGC == null) {
                    return;
                }
                SWTGraphics g = new SWTGraphics(imgGC);
                g.setClip(new Rectangle(0, 0, HTMLThumbnail.this.clipWidth, HTMLThumbnail.this.clipHeight));
                fig.paint((Graphics)g);
            }
        };
        this.syncExec(runnable);
    }

    private Image resizeImage(Image pageimage) {
        double zx = (double)this.getTargetWidth() / (double)this.clipWidth;
        double zy = (double)this.getTargetHeight() / (double)this.clipHeight;
        RasterImage frameimage = new RasterImage(this.image.getImageData());
        ResizeOp resizeop = TransformOp.createResizeOp(zx, zy, 2);
        HandyImage handyimage = frameimage.create(resizeop);
        ImageData imagedata = handyimage.getFrame().createImageData();
        Image targetimage = new Image(null, imagedata);
        return targetimage;
    }

    public void setPageSize(int width, int height, boolean clip) {
        this.clip = clip;
        this.width = width;
        this.height = height;
        if (this.imageGC != null) {
            this.imageGC.dispose();
            this.imageGC = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void setPageSize(int width, int height) {
        this.setPageSize(width, height, true);
    }

    public void setTargetSize(int width, int height) {
        this.targetWidth = width;
        this.targetHeight = height;
    }

    protected void initEditDomain() {
    }

    private void syncExec(Runnable runnable) {
        if (Display.getCurrent() != Display.getDefault()) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    protected XMLStyleFactory createStyleFactory(Canvas canvas) {
        if (ModelManagerUtil.isWML(this.viewFactory.getModel().getDocument())) {
            return new WMLStyleFactoryImpl((Scrollable)canvas);
        }
        return new HTMLStyleFactoryImpl((Scrollable)canvas);
    }

    public List getTargetNodeRects(Object node) {
        List orgList;
        List targets = this.getEditPartsFor(node);
        if (targets != null && targets.size() > 0) {
            EditPart part = (EditPart)targets.get(0);
            this.setActiveDocumentEditPart(PartAnalyzer.getDocumentEditPart(part));
        }
        if ((orgList = super.getNodeRects(node)) == null) {
            return null;
        }
        double zx = (double)this.getTargetWidth() / (double)this.clipWidth;
        double zy = (double)this.getTargetHeight() / (double)this.clipHeight;
        if (zx == 1.0 && zy == 1.0) {
            return orgList;
        }
        Vector<Rectangle> newList = new Vector<Rectangle>(orgList.size());
        int i = orgList.size() - 1;
        while (i >= 0) {
            Rectangle r = (Rectangle)orgList.get(i);
            newList.add(new Rectangle((int)((double)r.x * zx), (int)((double)r.y * zy), (int)((double)r.width * zx), (int)((double)r.height * zy)));
            --i;
        }
        return newList;
    }

    @Override
    public void setDesignTimeTagManager(DesignTimeTagManager designTimeTagManager) {
        super.setDesignTimeTagManager(designTimeTagManager);
        this.viewFactory.setDesignTimeTagManager(designTimeTagManager);
    }
}

