/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.utils;

import com.ibm.etools.webedit.links.util.ProjectUtil;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class WebComponent {
    private WebArtifactEdit edit;
    private final IVirtualComponent component;
    private final IProject project;

    public static IFile getFileForLocation(IPath location) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
    }

    public static IProject getProjectForLocation(IPath location) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
        if (file != null) {
            return file.getProject();
        }
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(location);
        if (container != null) {
            return container.getProject();
        }
        return null;
    }

    public WebComponent(IResource resourceInComponent) {
        IVirtualComponent comp = WebComponent.getComponent(resourceInComponent);
        if (comp == null && resourceInComponent != null) {
            IContainer container = resourceInComponent.getParent();
            comp = container != null ? WebComponent.getComponent((IResource)container) : null;
        }
        this.component = comp;
        this.project = resourceInComponent != null ? resourceInComponent.getProject() : null;
    }

    public WebComponent(IVirtualComponent component) {
        this.component = component;
        this.project = component != null ? component.getProject() : null;
    }

    public WebComponent(IStructuredModel model) {
        this(WebComponent.getFileForModel(model));
    }

    public WebComponent(IPath path) {
        this(WebComponent.getResourceFromPath(path));
    }

    public IProject getProject() {
        return this.project;
    }

    public static IVirtualComponent getComponent(IResource resourceInComponent) {
        if (resourceInComponent == null) {
            return null;
        }
        return ComponentCore.createComponent((IProject)resourceInComponent.getProject());
    }

    public static IVirtualResource getVirtualResource(IResource resource) {
        if (resource == null) {
            return null;
        }
        IVirtualResource[] resources = ComponentCore.createResources((IResource)resource);
        return resources != null && resources.length > 0 ? resources[0] : null;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public IPath getDocumentRoot() {
        if (this.project == null) {
            return null;
        }
        IContainer docRoot = this.getRootPublishableFolder();
        return docRoot != null ? docRoot.getLocation().addTrailingSeparator() : null;
    }

    public IContainer getRootPublishableFolder() {
        if (this.component != null) {
            return this.component.getRootFolder().getUnderlyingFolder();
        }
        if (this.project != null) {
            return this.project;
        }
        return null;
    }

    public String getServerContextRoot() {
        if (this.edit == null && this.component != null) {
            this.edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component);
        }
        return this.edit != null ? this.edit.getServerContextRoot() : null;
    }

    public IContainer getCSSFolder() {
        IFolder folder;
        IContainer theme = this.getRootPublishableFolder();
        if (theme != null && (folder = theme.getFolder((IPath)new Path("theme"))) != null) {
            theme = folder;
        }
        return theme;
    }

    public IContainer getLibraryFolder() {
        IContainer lib = this.getRootPublishableFolder();
        if (lib != null) {
            return lib.getFolder(WebArtifactEdit.WEBLIB);
        }
        return null;
    }

    public WebApp getWebApp() {
        if (this.edit == null && this.component != null) {
            this.edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component);
        }
        return this.edit != null ? this.edit.getWebApp() : null;
    }

    public int getJSPVersion() {
        if (this.edit == null && this.component != null) {
            this.edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component);
        }
        return this.edit != null ? this.edit.getJSPVersion() : 0;
    }

    public int getJ2EEVersion() {
        if (this.edit == null && this.component != null) {
            this.edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component);
        }
        return this.edit != null ? this.edit.getJ2EEVersion() : 0;
    }

    public void grabWebXml() {
        if (this.edit == null && this.component != null) {
            this.edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)this.component);
        }
    }

    public void releaseWebXml() {
        if (this.edit != null) {
            this.edit.dispose();
            this.edit = null;
        }
    }

    public void dispose() {
        if (this.edit != null) {
            this.edit.dispose();
            this.edit = null;
        }
    }

    public IPath getRealLocationOfIPath(IPath location, boolean[] types) {
        IPath relPath;
        if (types != null) {
            types[0] = false;
            types[1] = false;
        }
        if (this.component != null && (relPath = this.getComponentRelativePath(location)) != null) {
            boolean[] myTypes = new boolean[2];
            IPath locPath = null;
            if (locPath != null) {
                types[0] = myTypes[0];
                types[1] = myTypes[1];
                return locPath;
            }
        }
        return location;
    }

    protected IPath getComponentRelativePath(IPath location) {
        if (this.component == null) {
            return null;
        }
        IFile file = WebComponent.getFileForLocation(location);
        IVirtualResource resource = WebComponent.getVirtualResource((IResource)file);
        if (resource != null) {
            if (resource.getComponent().equals(this.component)) {
                return resource.getRuntimePath();
            }
        } else if (file != null && file.getProject().equals((Object)this.getProject())) {
            return file.getProjectRelativePath();
        }
        return null;
    }

    private static IResource getFileForModel(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String path = ModelManagerUtil.getBaseLocation(model);
        if (path == null || path.length() == 0) {
            return null;
        }
        return WebComponent.getResourceFromPath((IPath)new Path(path));
    }

    private static IResource getResourceFromPath(IPath path) {
        if (path == null) {
            return null;
        }
        IFile resource = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.toFile().exists()) {
            resource = root.getFileForLocation(path);
        } else {
            IProject project = ProjectUtil.getProjectForIPath((IPath)path);
            resource = project;
        }
        return resource;
    }

    public boolean isInComponent(IResource resource) {
        if (resource == null) {
            return false;
        }
        IVirtualComponent component = WebComponent.getComponent(resource);
        if (component != null) {
            return component.equals(this.getComponent());
        }
        return false;
    }
}

