/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.utils;

import com.ibm.etools.webedit.viewer.WebEditViewerPlugin;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerEncodingHelperForSave;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.encoding.EncodingRule;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;

public class ModelManagerEncodingHelper {
    private static final boolean USE_STRICT_ERROR_DETECTION = true;
    static final String CONTENTTYPE_ID_JSPFRAGMENT = "org.eclipse.jst.jsp.core.jspfragmentsource";
    static final String FILE_BUFFER_BUNDLE_ID = "org.eclipse.core.filebuffers";

    public static IStructuredModel getModelForRead(IModelManager mm, IFile file) throws UnsupportedCharsetException, IOException, CoreException {
        return ModelManagerEncodingHelper.getModelForRead(mm, file, null);
    }

    public static IStructuredModel getModelForEdit(IModelManager mm, IFile file) throws UnsupportedCharsetException, IOException, CoreException {
        return ModelManagerEncodingHelper.getModelForEdit(mm, file, null);
    }

    public static IStructuredModel getNewModelForEdit(final IModelManager mm, final IFile file, final boolean force) throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
        return ModelManagerEncodingHelper.getModelFor(mm, file, null, new ModelHandler(){

            @Override
            public IStructuredModel get() throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
                return mm.getNewModelForEdit(file, force);
            }

            @Override
            public void release(IStructuredModel model) {
                model.releaseFromEdit();
            }
        });
    }

    public static IStructuredModel getNewModelForRead(final IModelManager mm, final IFile file, final boolean force) throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
        return ModelManagerEncodingHelper.getModelFor(mm, file, null, new ModelHandler(){

            @Override
            public IStructuredModel get() throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
                return mm.getNewModelForRead(file, force);
            }

            @Override
            public void release(IStructuredModel model) {
                model.releaseFromRead();
            }
        });
    }

    public static IStructuredModel getModelForRead(final IModelManager mm, final IFile file, EncodingRule rule) throws UnsupportedCharsetException, IOException, CoreException {
        try {
            return ModelManagerEncodingHelper.getModelFor(mm, file, rule, new ModelHandler(){

                @Override
                public IStructuredModel get() throws UnsupportedCharsetException, IOException, CoreException {
                    return mm.getModelForRead(file);
                }

                @Override
                public void release(IStructuredModel model) {
                    model.releaseFromRead();
                }
            });
        }
        catch (ResourceAlreadyExists resourceAlreadyExists) {
        }
        catch (ResourceInUse resourceInUse) {}
        throw new RuntimeException("Program Error.");
    }

    public static IStructuredModel getModelForEdit(final IModelManager mm, final IFile file, EncodingRule rule) throws UnsupportedCharsetException, IOException, CoreException {
        try {
            return ModelManagerEncodingHelper.getModelFor(mm, file, rule, new ModelHandler(){

                @Override
                public IStructuredModel get() throws UnsupportedCharsetException, IOException, CoreException {
                    return mm.getModelForEdit(file);
                }

                @Override
                public void release(IStructuredModel model) {
                    model.releaseFromEdit();
                }
            });
        }
        catch (ResourceAlreadyExists resourceAlreadyExists) {
        }
        catch (ResourceInUse resourceInUse) {}
        throw new RuntimeException("Program Error.");
    }

    private static IStructuredModel getModelFor(IModelManager mm, IFile file, EncodingRule rule, ModelHandler handler) throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
        ModelHolder holder = new ModelHolder(handler);
        try {
            if (rule == null || rule == EncodingRule.CONTENT_BASED) {
                holder.loadModel(file, file.getCharset());
                ModelManagerEncodingHelper.checkModelEncodingError(holder.getModel(), file, rule);
            } else if (rule == EncodingRule.FORCE_DEFAULT) {
                holder.loadModel(file, ModelManagerEncodingHelper.getDefaultEncoding((IFile)file).java);
                ModelManagerEncodingHelper.refreshContentByEncoding(file, rule);
                ModelManagerEncodingHelper.checkModelEncodingError(holder.getModel(), file, rule);
            } else if (rule == EncodingRule.IGNORE_CONVERSION_ERROR) {
                holder.loadModel(file, file.getCharset());
                ModelManagerEncodingHelper.refreshContentByEncoding(file, rule);
            }
            IStructuredModel iStructuredModel = holder.delegateOwner();
            return iStructuredModel;
        }
        finally {
            holder.release();
        }
    }

    private static void checkModelEncodingError(IStructuredModel model, IFile file, EncodingRule rule) throws IOException, UnsupportedCharsetException {
        if (model == null) {
            return;
        }
        if (model.isDirty()) {
            return;
        }
        if (file == null || !file.isAccessible()) {
            return;
        }
        ITextFileBuffer buf = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buf != null && !buf.isDirty()) {
            ModelManagerEncodingHelper.throwEncodingExceptionForLoadFromStatus(buf.getStatus(), file, buf.getEncoding());
            if (buf.isShared()) {
                return;
            }
            int badChar = ModelManagerEncodingHelperForSave.findCharcterCodingExceptionPosition(buf.getDocument().get(), buf.getEncoding());
            if (badChar != -1) {
                if (rule == EncodingRule.FORCE_DEFAULT) {
                    return;
                }
                throw new CharacterCodingException();
            }
        }
    }

    private static void throwEncodingExceptionForLoadFromStatus(IStatus status, IFile file, String javaEncoding) throws UnsupportedCharsetException, CharacterCodingException {
        if (status == null || status.isOK()) {
            return;
        }
        if (status.getException() instanceof UnsupportedCharsetException) {
            throw (UnsupportedCharsetException)status.getException();
        }
        CharacterCodingException ce = null;
        if (status.getException() instanceof CharacterCodingException) {
            ce = (CharacterCodingException)status.getException();
        }
        if (status.getException() instanceof CharConversionException) {
            ce = new CharacterCodingException();
        }
        if (FILE_BUFFER_BUNDLE_ID.equals(status.getPlugin()) && status.getCode() == 3) {
            ce = new CharacterCodingException();
        }
        if (ce != null) {
            if (ce instanceof MalformedInputExceptionWithDetail) {
                throw ce;
            }
            int pos = ModelManagerEncodingHelper.findCharcterCodingExceptionPosition(file, javaEncoding);
            throw new MalformedInputExceptionWithDetail(javaEncoding, javaEncoding, pos);
        }
    }

    private static void refreshContentByEncoding(IFile file, EncodingRule rule) throws UnsupportedCharsetException, CharacterCodingException, CoreException {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer == null) {
            return;
        }
        if (buffer.isDirty()) {
            return;
        }
        if (buffer.isShared()) {
            return;
        }
        CodingErrorAction malform = CodingErrorAction.REPORT;
        CodingErrorAction unmap = CodingErrorAction.REPORT;
        if (rule == EncodingRule.FORCE_DEFAULT) {
            String encoding = buffer.getContentType().getDefaultCharset();
            if (encoding == null) {
                encoding = file.getParent().getDefaultCharset();
            }
            buffer.setEncoding(encoding);
            buffer.revert((IProgressMonitor)new NullProgressMonitor());
            return;
        }
        if (rule == EncodingRule.IGNORE_CONVERSION_ERROR) {
            String encoding = buffer.getEncoding();
            malform = CodingErrorAction.IGNORE;
            unmap = CodingErrorAction.IGNORE;
            String content = ModelManagerEncodingHelper.readFileWithEncoding(file, encoding, malform, unmap);
            buffer.getDocument().set(content);
            buffer.setDirty(false);
        } else {
            String encoding = buffer.getEncoding();
        }
    }

    private static String readFileWithEncoding(IFile file, String encoding, CodingErrorAction malform, CodingErrorAction unmap) throws UnsupportedCharsetException, CharacterCodingException, CoreException {
        Charset charset = Charset.forName(encoding);
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        byte[] content = ModelManagerEncodingHelper.getContent(file);
        CharBuffer result = decoder.decode(ByteBuffer.wrap(content));
        CharsetEncoder encoder = charset.newEncoder();
        if (!encoder.canEncode(result.toString())) {
            throw new UnmappableCharacterException(1);
        }
        return result.toString();
    }

    private static byte[] getContent(IFile file) throws CoreException {
        byte[] byArray;
        int skip = 0;
        try {
            IContentDescription desc = file.getContentDescription();
            Object bom = desc.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (bom instanceof byte[]) {
                skip = ((byte[])bom).length;
            }
        }
        catch (CoreException coreException) {}
        BufferedInputStream is = new BufferedInputStream(file.getContents());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int nRead;
                if (skip > 0) {
                    ((InputStream)is).skip(skip);
                }
                byte[] buf = new byte[2048];
                while ((nRead = ((InputStream)is).read(buf)) != -1) {
                    baos.write(buf, 0, nRead);
                }
                baos.close();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, WebEditViewerPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static int findCharcterCodingExceptionPosition(IFile file, String encoding) {
        try {
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            String replacement = "\uffef";
            decoder.replaceWith(replacement);
            byte[] content = ModelManagerEncodingHelper.getContent(file);
            String result = decoder.decode(ByteBuffer.wrap(content)).toString();
            int pos = result.indexOf(replacement);
            if (pos >= 0) {
                return pos;
            }
            return ModelManagerEncodingHelperForSave.findCharcterCodingExceptionPosition(result, encoding);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static EncodingHolder getDetectedEncoding(IFile file) {
        String java = null;
        String iana = null;
        try {
            IContentDescription desc = file.getContentDescription();
            java = desc.getCharset();
            iana = (String)desc.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
        }
        catch (CoreException coreException) {}
        if (java == null) {
            return ModelManagerEncodingHelper.getDefault(null, file);
        }
        if (iana == null) {
            iana = java;
        }
        return new EncodingHolder(java, iana);
    }

    public static EncodingHolder getDefaultEncoding(IFile file) {
        return ModelManagerEncodingHelper.getDefault(null, file);
    }

    static EncodingHolder getDefault(IStructuredModel model, IFile file) {
        String java = null;
        String iana = null;
        IContentType type = null;
        if (model != null) {
            type = Platform.getContentTypeManager().getContentType(model.getContentTypeIdentifier());
        } else {
            try {
                type = file.getContentDescription().getContentType();
            }
            catch (CoreException coreException) {}
        }
        if (type != null) {
            java = type.getDefaultCharset();
            iana = (String)type.getDefaultDescription().getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
        }
        if (java == null) {
            try {
                java = file.getParent().getDefaultCharset();
            }
            catch (CoreException coreException) {}
        }
        if (java == null) {
            java = ResourcesPlugin.getEncoding();
        }
        if (iana == null) {
            iana = java;
        }
        return new EncodingHolder(java, iana);
    }

    public static class EncodingHolder {
        public final String java;
        public final String canonicalJava;
        public final String iana;

        EncodingHolder(String java, String iana) {
            this.java = java;
            this.canonicalJava = this.getCanonical(java);
            this.iana = iana;
        }

        private String getCanonical(String java) {
            try {
                return Charset.forName(java).name();
            }
            catch (Exception exception) {
                return java;
            }
        }

        public int hashCode() {
            return this.canonicalJava.hashCode() + this.iana.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncodingHolder)) {
                return false;
            }
            EncodingHolder b = (EncodingHolder)o;
            return this.canonicalJava.equals(b.canonicalJava) && this.iana.equals(b.iana);
        }

        public boolean equalsJavaEncoding(EncodingHolder detectedEncoding) {
            return this.canonicalJava.equals(detectedEncoding.canonicalJava);
        }
    }

    private static interface ModelHandler {
        public IStructuredModel get() throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse;

        public void release(IStructuredModel var1);
    }

    private static class ModelHolder {
        private final ModelHandler handler;
        private boolean hasOwnership;
        private IStructuredModel model;

        public ModelHolder(ModelHandler handler) {
            this.handler = handler;
        }

        public void loadModel(IFile file, String encoding) throws UnsupportedCharsetException, IOException, CoreException, ResourceAlreadyExists, ResourceInUse {
            this.release();
            this.hasOwnership = true;
            try {
                this.model = this.handler.get();
            }
            catch (CoreException e) {
                ModelManagerEncodingHelper.throwEncodingExceptionForLoadFromStatus(e.getStatus(), file, encoding);
                throw e;
            }
        }

        public IStructuredModel getModel() {
            return this.model;
        }

        public IStructuredModel delegateOwner() {
            this.hasOwnership = false;
            return this.model;
        }

        public void release() {
            if (this.hasOwnership && this.model != null) {
                this.handler.release(this.model);
            }
            this.model = null;
            this.hasOwnership = false;
        }
    }
}

