/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.thumbnails;

import com.ibm.etools.webedit.frame.FrameLayoutNode;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameView;
import com.ibm.etools.webedit.viewer.thumbnails.FrameViewInitializer;
import com.ibm.etools.webedit.viewer.thumbnails.HTMLThumbnail;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FrameViewImpl
implements FrameView {
    GC gc;
    Rectangle rect;
    FrameLayoutNode frameNode;
    HTMLThumbnail thumbnail = new HTMLThumbnail();
    FrameViewInitializer initializer;
    Rectangle[] rows;
    Rectangle[] cols;
    private int mh;
    private boolean mhs;
    private int mv;
    private boolean mvs;

    FrameViewImpl(GC gc, FrameViewInitializer initializer) {
        this.gc = gc;
        this.initializer = initializer;
    }

    @Override
    public void dispose() {
        this.thumbnail.dispose();
    }

    @Override
    public Rectangle getClientArea() {
        return this.rect;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        if (bounds != null) {
            this.rect = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    @Override
    public void setMargins(int h, boolean hs, int v, boolean vs) {
        this.mh = h;
        this.mhs = hs;
        this.mv = v;
        this.mvs = vs;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FrameViewImpl.this.thumbnail != null) {
                    FrameViewImpl.this.thumbnail.updateMargins(FrameViewImpl.this.mh, FrameViewImpl.this.mhs, FrameViewImpl.this.mv, FrameViewImpl.this.mvs);
                }
            }
        };
        this.syncExec(runnable);
    }

    private void syncExec(Runnable runnable) {
        if (Display.getCurrent() != Display.getDefault()) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void setFrameLayoutNode(FrameLayoutNode node) {
        IDOMModel model;
        this.frameNode = node;
        FrameNode fn = node.getFrameNode();
        if (fn != null && fn.getType() == 2 && (model = ((FramePageNode)fn).getModel()) != null) {
            if (this.initializer != null) {
                this.initializer.initialize(this.thumbnail);
            }
            this.thumbnail.setModel(model);
        }
    }

    @Override
    public void setSashes(Rectangle[] rowSashes, Rectangle[] colSashes) {
        this.rows = rowSashes;
        this.cols = colSashes;
    }

    public void draw(GC gContext) {
        FrameLayoutNode[] children;
        int i;
        if (this.rows != null || this.cols != null) {
            Color org = gContext.getBackground();
            gContext.setBackground(gContext.getForeground());
            if (this.rows != null) {
                i = 0;
                while (i < this.rows.length) {
                    gContext.fillRectangle(this.rows[i].x, this.rows[i].y, this.rows[i].width, this.rows[i].height);
                    ++i;
                }
            }
            if (this.cols != null) {
                i = 0;
                while (i < this.cols.length) {
                    gContext.fillRectangle(this.cols[i].x, this.cols[i].y, this.cols[i].width, this.cols[i].height);
                    ++i;
                }
            }
            gContext.setBackground(org);
        }
        if (this.thumbnail.getModel() != null) {
            int orgx = this.rect == null ? 0 : this.rect.x;
            int orgy = this.rect == null ? 0 : this.rect.y;
            this.thumbnail.setPageSize(this.rect.width, this.rect.height);
            this.thumbnail.setTargetSize(this.rect.width, this.rect.height);
            this.thumbnail.draw(gContext, orgx, orgy);
        }
        if ((children = this.frameNode.getChildPanes()) != null) {
            i = 0;
            while (i < children.length) {
                ((FrameViewImpl)children[i].getView()).draw(gContext);
                ++i;
            }
        }
    }
}

