/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.frame;

import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameSetNode;
import com.ibm.etools.webedit.frame.Length;
import com.ibm.etools.webedit.viewer.internal.frame.FrameManagerImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FrameNodeImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FramePageNodeImpl;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FrameSetNodeImpl
extends FrameNodeImpl
implements FrameSetNode {
    private static final Length[] defFrames = new Length[]{new Length()};
    private static final int defBorder = 6;
    private Length[] cols;
    private Length[] rows;
    private FrameNodeImpl[] childFrames;
    private int border = 6;

    FrameSetNodeImpl(FrameNodeImpl parent, FrameManagerImpl manager) {
        super(parent, manager);
    }

    @Override
    int attrRemoved(String attrName) {
        if (attrName == null) {
            return 0;
        }
        if (attrName.equalsIgnoreCase("rows")) {
            this.rows = defFrames;
        } else if (attrName.equalsIgnoreCase("cols")) {
            this.cols = defFrames;
        } else if (attrName.equalsIgnoreCase("border")) {
            this.border = 6;
        } else if (attrName.equalsIgnoreCase("frameborder")) {
            this.frameBorder = null;
        } else {
            return 0;
        }
        return 2;
    }

    @Override
    public void dispose() {
        if (this.childFrames != null) {
            int i = this.childFrames.length - 1;
            while (i >= 0) {
                this.childFrames[i].dispose();
                --i;
            }
            this.childFrames = null;
        }
    }

    @Override
    public int getBorder() {
        if (!this.getFrameBorder()) {
            return 0;
        }
        if (this.border < 0) {
            FrameNode p = this.parent;
            while (p != null) {
                if (p.getType() == 1) {
                    return ((FrameSetNode)p).getBorder();
                }
                p = p.getParentFrameNode();
            }
            return 6;
        }
        return this.border;
    }

    @Override
    public int getChildCol(FrameNode child) {
        if (this.cols == null || this.cols.length == 0) {
            return -1;
        }
        int index = this.getChildIndex(child);
        if (index < 0) {
            return -1;
        }
        return index % this.cols.length;
    }

    @Override
    public int getChildIndex(FrameNode child) {
        int i = -1;
        i = this.childFrames.length - 1;
        while (i >= 0) {
            if (this.childFrames[i] == child) break;
            --i;
        }
        return i;
    }

    @Override
    public FrameNode[] getChildren() {
        return this.childFrames;
    }

    @Override
    public int getChildRow(FrameNode child) {
        if (this.cols == null || this.cols.length == 0) {
            return -1;
        }
        int index = this.getChildIndex(child);
        if (index < 0) {
            return -1;
        }
        return index / this.cols.length;
    }

    @Override
    public Length[] getCols() {
        return this.cols;
    }

    @Override
    public boolean getFrameBorder() {
        return this.getFrameBorder(false);
    }

    boolean getFrameBorder(boolean fromChild) {
        if (this.frameBorder != null) {
            return this.frameBorder;
        }
        if (!fromChild && this.childFrames != null && this.childFrames.length > 0) {
            int i = 0;
            while (i < this.childFrames.length) {
                if (this.childFrames[i].getFrameBorder()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.parent != null && this.parent instanceof FrameSetNodeImpl) {
            return ((FrameSetNodeImpl)this.parent).getFrameBorder(true);
        }
        return true;
    }

    @Override
    public Length[] getRows() {
        return this.rows;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    private int parseBorder(String borderWidth) {
        if (borderWidth == null) {
            return 6;
        }
        try {
            int i = Integer.parseInt(borderWidth);
            if (i < 0) {
                i = 0;
            }
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return 6;
        }
    }

    private Length[] parseFrames(String attr) {
        if (attr == null) {
            return defFrames;
        }
        Vector<Length> fs = new Vector<Length>();
        int pre = 0;
        int post = 0;
        while ((post = attr.indexOf(",", pre)) > pre) {
            fs.add(new Length(attr.substring(pre, post)));
            pre = post + 1;
        }
        fs.add(new Length(attr.substring(pre)));
        Length[] frames = new Length[fs.size()];
        fs.toArray(frames);
        return frames;
    }

    @Override
    void setElement(Element element) {
        this.element = element;
        this.updateAttrs();
        this.updateFrames();
    }

    @Override
    int updateAttr(String attrName) {
        if (attrName.equalsIgnoreCase("cols") || attrName.equalsIgnoreCase("rows") || attrName.equalsIgnoreCase("border") || attrName.equalsIgnoreCase("frameborder")) {
            int numRows = this.rows.length;
            int numColumns = this.cols.length;
            this.updateAttrs();
            if (numRows != this.rows.length || numColumns != this.cols.length) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private void updateAttrs() {
        this.rows = defFrames;
        this.cols = defFrames;
        this.border = 6;
        this.frameBorder = null;
        if (this.element != null) {
            this.rows = this.parseFrames(this.element.getAttribute("rows"));
            this.cols = this.parseFrames(this.element.getAttribute("cols"));
            this.border = this.parseBorder(this.element.getAttribute("border"));
            this.frameBorder = this.parseFrameBorder(this.element.getAttribute("frameborder"));
        }
    }

    private void updateFrames() {
        if (this.element == null) {
            return;
        }
        Vector<FramePageNodeImpl> c = new Vector<FramePageNodeImpl>();
        NodeList children = this.element.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        int currentNumChildren = this.childFrames != null ? this.childFrames.length : 0;
        int j = 0;
        while (i < numChildren) {
            String nodeName;
            Node n = children.item(i);
            if (n.getNodeType() == 1 && (nodeName = n.getNodeName()) != null) {
                FrameNodeImpl fn = null;
                if (nodeName.equalsIgnoreCase("FRAME")) {
                    fn = j < currentNumChildren && this.childFrames[j] instanceof FramePageNode ? this.childFrames[j++] : new FramePageNodeImpl(this, this.manager);
                } else if (nodeName.equalsIgnoreCase("FRAMESET")) {
                    fn = j < currentNumChildren && this.childFrames[j] instanceof FrameSetNode ? this.childFrames[j++] : new FrameSetNodeImpl(this, this.manager);
                }
                if (fn != null) {
                    ((FrameNodeImpl)fn).setElement((Element)n);
                    c.add((FramePageNodeImpl)fn);
                }
            }
            ++i;
        }
        while (j < currentNumChildren) {
            this.childFrames[j].dispose();
            ++j;
        }
        this.childFrames = null;
        if (c.size() > 0) {
            this.childFrames = new FrameNodeImpl[c.size()];
            c.toArray(this.childFrames);
        }
    }
}

