/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webedit.viewer.internal.frame;

import com.ibm.etools.webedit.frame.FrameManagerListener;
import com.ibm.etools.webedit.frame.FrameNode;
import com.ibm.etools.webedit.frame.FramePageNode;
import com.ibm.etools.webedit.frame.FrameSetNode;
import com.ibm.etools.webedit.viewer.internal.frame.FrameManagerImpl;
import com.ibm.etools.webedit.viewer.internal.frame.FrameNodeImpl;
import com.ibm.etools.webedit.viewer.internal.utils.Logger;
import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webedit.viewer.utils.LinkUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class FramePageNodeImpl
extends FrameNodeImpl
implements FramePageNode,
FrameManagerListener {
    private IDOMModel model;
    private FrameManagerImpl containingManager = new FrameManagerImpl(this);
    private FrameSetNode nestFrame;
    private int error = 0;
    private boolean specified_hmargin = false;
    private boolean specified_vmargin = false;
    private int hmargin = 0;
    private int vmargin = 0;

    FramePageNodeImpl(FrameNodeImpl parent, FrameManagerImpl manager) {
        super(parent, manager);
    }

    @Override
    int attrRemoved(String attrName) {
        if (attrName == null) {
            return 0;
        }
        if (attrName.equalsIgnoreCase("src")) {
            this.updateSrc(null, false);
            return 2;
        }
        if (attrName.equalsIgnoreCase("frameborder")) {
            this.updateFrameBorder(null);
            return 1;
        }
        if (attrName.equalsIgnoreCase("marginwidth")) {
            this.updateMarginWidth(null);
            return 3;
        }
        if (attrName.equalsIgnoreCase("marginheight")) {
            this.updateMarginHeight(null);
            return 3;
        }
        return 0;
    }

    @Override
    public void boundsChanged() {
        if (this.manager != null) {
            this.manager.boundsChanged(false);
        }
    }

    @Override
    public void marginsChanged() {
        if (this.manager != null) {
            this.manager.marginsChanged(false);
        }
    }

    @Override
    public void dispose() {
        if (this.containingManager != null) {
            this.containingManager.dispose();
        }
        if (this.model != null) {
            LinkUtil.releaseModel((IStructuredModel)this.model, false);
            this.model = null;
        }
    }

    @Override
    public int getError() {
        return this.error;
    }

    @Override
    public boolean getFrameBorder() {
        if (this.frameBorder == null) {
            return true;
        }
        return this.frameBorder;
    }

    @Override
    public int getHorizontalMargin() {
        return this.hmargin;
    }

    @Override
    public int getVerticalMargin() {
        return this.vmargin;
    }

    @Override
    public boolean isHorizontalMargin() {
        return this.specified_hmargin;
    }

    @Override
    public boolean isVerticalMargin() {
        return this.specified_vmargin;
    }

    @Override
    public IDOMModel getModel() {
        return this.model;
    }

    @Override
    public FrameSetNode getNestedFrameSet() {
        return this.nestFrame;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean hasChildren() {
        return this.getNestedFrameSet() != null;
    }

    private boolean isLoop(Document doc) {
        FrameNode p = this.getParentFrameNode();
        while (p != null) {
            Element elm;
            if (p.getType() == 1 && (elm = p.getElement()).getOwnerDocument() == doc) {
                return true;
            }
            p = p.getParentFrameNode();
        }
        return false;
    }

    @Override
    public void newModel() {
        String a = this.element.getAttribute("src");
        this.updateSrc(a, true);
        this.manager.structureChanged(false);
    }

    @Override
    void setElement(Element element) {
        this.element = element;
        this.updateAttrs();
    }

    @Override
    public void structureChanged() {
        if (this.manager != null) {
            this.manager.structureChanged(false);
        }
    }

    @Override
    int updateAttr(String attrName) {
        if (attrName.equalsIgnoreCase("src")) {
            this.updateAttrs();
            return 2;
        }
        if (attrName.equalsIgnoreCase("frameborder")) {
            this.updateAttrs();
            return 1;
        }
        if (attrName.equalsIgnoreCase("marginwidth")) {
            this.updateAttrs();
            return 3;
        }
        if (attrName.equalsIgnoreCase("marginheight")) {
            this.updateAttrs();
            return 3;
        }
        return 0;
    }

    private void updateAttrs() {
        if (this.element != null) {
            String a = this.element.getAttribute("frameborder");
            this.updateFrameBorder(a);
            a = this.element.getAttribute("src");
            this.updateSrc(a, false);
            a = this.element.getAttribute("marginwidth");
            this.updateMarginWidth(a);
            a = this.element.getAttribute("marginheight");
            this.updateMarginHeight(a);
        }
    }

    private void updateFrameBorder(String v) {
        this.frameBorder = this.parseFrameBorder(v);
    }

    private void updateMarginWidth(String v) {
        if (v == null) {
            this.specified_hmargin = false;
            this.hmargin = 0;
        } else {
            this.specified_hmargin = true;
            try {
                this.hmargin = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                this.hmargin = 0;
            }
        }
    }

    private void updateMarginHeight(String v) {
        if (v == null) {
            this.specified_vmargin = false;
            this.vmargin = 0;
        } else {
            this.specified_vmargin = true;
            try {
                this.vmargin = Integer.parseInt(v);
            }
            catch (NumberFormatException numberFormatException) {
                this.vmargin = 0;
            }
        }
    }

    private void updateSrc(String src, boolean newModelIfNoExisting) {
        IDOMModel newModel = null;
        if (this.model != null && !this.model.isNew()) {
            LinkUtil.releaseModel((IStructuredModel)this.model, false);
            this.model = null;
        }
        this.containingManager.removeListener(this);
        this.containingManager.setModel(null);
        this.error = 0;
        this.nestFrame = null;
        if (this.element != null && this.element instanceof IDOMNode) {
            IStructuredModel sm = null;
            if (src != null && !FramePageNodeImpl.hasImageExtension((IPath)new Path(src))) {
                IFile file;
                ModelManagerUtil mm;
                IPath path;
                sm = LinkUtil.getModel(LinkUtil.createURLContextFor((IStructuredModel)((IDOMNode)this.element).getModel()), this.element, src, false, newModelIfNoExisting, "FRAME", "src");
                if (sm == null && (path = LinkUtil.getFilePath(LinkUtil.createURLContextFor((IStructuredModel)((IDOMNode)this.element).getModel()), src, "FRAME", "src", true)) != null && (mm = new ModelManagerUtil(null, null)) != null) {
                    sm = mm.getModelForRead(path);
                }
                if (sm != null && !sm.isNew() && (file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(ModelManagerUtil.getBaseLocation(sm)))) != null && !file.exists()) {
                    sm.releaseFromEdit();
                    sm = null;
                }
            }
            if (sm == null) {
                this.error = 1;
            } else if (sm instanceof IDOMModel) {
                newModel = (IDOMModel)sm;
                if (!this.isLoop((Document)newModel.getDocument())) {
                    this.containingManager.setModel(newModel);
                    if (this.containingManager.isFrame()) {
                        this.nestFrame = this.containingManager.getTop();
                        this.containingManager.addListener(this);
                    } else {
                        this.containingManager.setModel(null);
                    }
                } else {
                    LinkUtil.releaseModel(sm, false);
                    newModel = null;
                    this.error = 2;
                }
            } else {
                Logger.log("Not IDOMModel in Frame");
                LinkUtil.releaseModel(sm, false);
            }
        }
        if (this.model != null) {
            LinkUtil.releaseModel((IStructuredModel)this.model, false);
        }
        this.model = newModel;
    }

    public static boolean hasImageExtension(IPath file) {
        String ext;
        return file != null && (ext = file.getFileExtension()) != null && (ext.compareToIgnoreCase("BMP") == 0 || ext.compareToIgnoreCase("TIF") == 0 || ext.compareToIgnoreCase("TIFF") == 0 || ext.compareToIgnoreCase("GIF") == 0 || ext.compareToIgnoreCase("JPG") == 0 || ext.compareToIgnoreCase("JPEG") == 0 || ext.compareToIgnoreCase("JPE") == 0 || ext.compareToIgnoreCase("PNG") == 0 || ext.compareToIgnoreCase("XBM") == 0 || ext.compareToIgnoreCase("FPX") == 0 || ext.compareToIgnoreCase("PCD") == 0 || ext.compareToIgnoreCase("MIF") == 0 || ext.compareToIgnoreCase("DCM") == 0 || ext.compareToIgnoreCase("WMF") == 0 || ext.compareToIgnoreCase("EMF") == 0 || ext.compareToIgnoreCase("WBMP") == 0);
    }
}

